/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.SystemUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrefetchSubscription
extends AbstractSubscription {
    private static final Logger LOG = LoggerFactory.getLogger(PrefetchSubscription.class);
    protected final Scheduler scheduler;
    protected PendingMessageCursor pending;
    protected final List<MessageReference> dispatched = new ArrayList<MessageReference>();
    protected final AtomicInteger prefetchExtension = new AtomicInteger();
    protected boolean usePrefetchExtension = true;
    protected long enqueueCounter;
    protected long dispatchCounter;
    protected long dequeueCounter;
    private int maxProducersToAudit = 32;
    private int maxAuditDepth = 2048;
    protected final SystemUsage usageManager;
    protected final Object pendingLock = new Object();
    protected final Object dispatchLock = new Object();
    private final CountDownLatch okForAckAsDispatchDone = new CountDownLatch(1);

    public PrefetchSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info, PendingMessageCursor cursor) throws InvalidSelectorException {
        super(broker, context, info);
        this.usageManager = usageManager;
        this.pending = cursor;
        this.scheduler = broker.getScheduler();
    }

    public PrefetchSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        this(broker, usageManager, context, info, new VMPendingMessageCursor(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response pullMessage(ConnectionContext context, MessagePull pull) throws Exception {
        if (this.getPrefetchSize() == 0 && !this.isSlave()) {
            this.prefetchExtension.incrementAndGet();
            final long dispatchCounterBeforePull = this.dispatchCounter;
            for (Destination dest : this.destinations) {
                dest.iterate();
            }
            this.dispatchPending();
            PrefetchSubscription prefetchSubscription = this;
            synchronized (prefetchSubscription) {
                if (dispatchCounterBeforePull == this.dispatchCounter) {
                    if (pull.getTimeout() == -1L) {
                        this.add(QueueMessageReference.NULL_MESSAGE);
                        this.dispatchPending();
                    }
                    if (pull.getTimeout() > 0L) {
                        this.scheduler.executeAfterDelay(new Runnable(){

                            @Override
                            public void run() {
                                PrefetchSubscription.this.pullTimeout(dispatchCounterBeforePull);
                            }
                        }, pull.getTimeout());
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void pullTimeout(long dispatchCounterBeforePull) {
        Object object = this.pendingLock;
        synchronized (object) {
            if (dispatchCounterBeforePull == this.dispatchCounter) {
                try {
                    this.add(QueueMessageReference.NULL_MESSAGE);
                    this.dispatchPending();
                }
                catch (Exception e) {
                    this.context.getConnection().serviceException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageReference node) throws Exception {
        Object object = this.pendingLock;
        synchronized (object) {
            if (!this.destinations.contains(node.getRegionDestination()) && node != QueueMessageReference.NULL_MESSAGE) {
                return;
            }
            if (!node.equals(QueueMessageReference.NULL_MESSAGE)) {
                ++this.enqueueCounter;
            }
            this.pending.addMessageLast(node);
        }
        this.dispatchPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessageDispatchNotification(MessageDispatchNotification mdn) throws Exception {
        Object object = this.pendingLock;
        synchronized (object) {
            try {
                this.pending.reset();
                while (true) {
                    if (!this.pending.hasNext()) break;
                    MessageReference node = this.pending.next();
                    node.decrementReferenceCount();
                    if (!node.getMessageId().equals(mdn.getMessageId())) continue;
                    Object object2 = this.dispatchLock;
                    synchronized (object2) {
                        this.pending.remove();
                        this.createMessageDispatch(node, node.getMessage());
                        this.dispatched.add(node);
                        this.onDispatch(node, node.getMessage());
                    }
                    return;
                }
            }
            finally {
                this.pending.release();
            }
        }
        throw new JMSException("Slave broker out of sync with master: Dispatched message (" + mdn.getMessageId() + ") was not in the pending list for " + mdn.getConsumerId() + " on " + mdn.getDestination().getPhysicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        boolean callDispatchMatched = false;
        Destination destination = null;
        if (!this.isSlave() && !this.okForAckAsDispatchDone.await(0L, TimeUnit.MILLISECONDS)) {
            LOG.warn("Ignoring ack received before dispatch; result of failover with an outstanding ack. Acked messages will be replayed if present on this broker. Ignored ack: " + ack);
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("ack:" + ack);
        }
        Object object = this.dispatchLock;
        synchronized (object) {
            if (ack.isStandardAck()) {
                this.assertAckMatchesDispatched(ack);
                int index = 0;
                boolean inAckRange = false;
                ArrayList<MessageReference> removeList = new ArrayList<MessageReference>();
                for (MessageReference node : this.dispatched) {
                    int newExtension;
                    int currentExtension;
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange) continue;
                    if (!context.isInTransaction()) {
                        ++this.dequeueCounter;
                        node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                        removeList.add(node);
                    } else {
                        this.registerRemoveSync(context, node);
                    }
                    ++index;
                    this.acknowledge(context, ack, node);
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    if (this.getPrefetchSize() == 0) {
                        while (!this.prefetchExtension.compareAndSet(currentExtension = this.prefetchExtension.get(), newExtension = Math.max(0, currentExtension - index))) {
                        }
                    } else if (this.usePrefetchExtension && context.isInTransaction()) {
                        while (!this.prefetchExtension.compareAndSet(currentExtension = this.prefetchExtension.get(), newExtension = Math.max(currentExtension, index))) {
                        }
                    }
                    destination = node.getRegionDestination();
                    callDispatchMatched = true;
                    break;
                }
                for (MessageReference node : removeList) {
                    this.dispatched.remove(node);
                }
                if (!callDispatchMatched) {
                    LOG.warn("Could not correlate acknowledgment with dispatched message: " + ack);
                }
            } else if (ack.isIndividualAck()) {
                for (MessageReference node : this.dispatched) {
                    int newExtension;
                    int currentExtension;
                    MessageId messageId = node.getMessageId();
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    if (!context.isInTransaction()) {
                        ++this.dequeueCounter;
                        node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                        this.dispatched.remove(node);
                    } else {
                        this.registerRemoveSync(context, node);
                    }
                    while (!this.prefetchExtension.compareAndSet(currentExtension = this.prefetchExtension.get(), newExtension = Math.max(0, currentExtension - 1))) {
                    }
                    this.acknowledge(context, ack, node);
                    destination = node.getRegionDestination();
                    callDispatchMatched = true;
                    break;
                }
            } else if (ack.isDeliveredAck()) {
                int index = 0;
                Iterator<MessageReference> iter = this.dispatched.iterator();
                while (iter.hasNext()) {
                    MessageReference node = iter.next();
                    if (node.isExpired()) {
                        if (this.broker.isExpired(node)) {
                            node.getRegionDestination().messageExpired(context, this, node);
                        }
                        iter.remove();
                        node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                    }
                    if (ack.getLastMessageId().equals(node.getMessageId())) {
                        if (this.usePrefetchExtension) {
                            int newExtension;
                            int currentExtension;
                            while (!this.prefetchExtension.compareAndSet(currentExtension = this.prefetchExtension.get(), newExtension = Math.max(currentExtension, index + 1))) {
                            }
                        }
                        destination = node.getRegionDestination();
                        callDispatchMatched = true;
                        break;
                    }
                    ++index;
                }
                if (!callDispatchMatched) {
                    throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
                }
            } else if (ack.isRedeliveredAck()) {
                boolean inAckRange = false;
                for (MessageReference node : this.dispatched) {
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange || !ack.getLastMessageId().equals(messageId)) continue;
                    destination = node.getRegionDestination();
                    callDispatchMatched = true;
                    break;
                }
                if (!callDispatchMatched) {
                    throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
                }
            } else if (ack.isPoisonAck()) {
                if (ack.isInTransaction()) {
                    throw new JMSException("Poison ack cannot be transacted: " + ack);
                }
                int index = 0;
                boolean inAckRange = false;
                ArrayList<MessageReference> removeList = new ArrayList<MessageReference>();
                for (MessageReference node : this.dispatched) {
                    int newExtension;
                    int currentExtension;
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange) continue;
                    if (ack.getPoisonCause() != null) {
                        node.getMessage().setProperty("dlqDeliveryFailureCause", ack.getPoisonCause().toString());
                    }
                    this.sendToDLQ(context, node);
                    node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                    removeList.add(node);
                    ++this.dequeueCounter;
                    ++index;
                    this.acknowledge(context, ack, node);
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    while (!this.prefetchExtension.compareAndSet(currentExtension = this.prefetchExtension.get(), newExtension = Math.max(0, currentExtension - (index + 1)))) {
                    }
                    destination = node.getRegionDestination();
                    callDispatchMatched = true;
                    break;
                }
                for (MessageReference node : removeList) {
                    this.dispatched.remove(node);
                }
                if (!callDispatchMatched) {
                    throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
                }
            }
        }
        if (callDispatchMatched && destination != null) {
            destination.wakeup();
            this.dispatchPending();
        } else {
            if (this.isSlave()) {
                throw new JMSException("Slave broker out of sync with master: Acknowledgment (" + ack + ") was not in the dispatch list: " + this.dispatched);
            }
            LOG.debug("Acknowledgment out of sync (Normally occurs when failover connection reconnects): " + ack);
        }
    }

    private void registerRemoveSync(ConnectionContext context, final MessageReference node) {
        context.getTransaction().addSynchronization(new Synchronization(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void afterCommit() throws Exception {
                Object object = PrefetchSubscription.this.dispatchLock;
                synchronized (object) {
                    ++PrefetchSubscription.this.dequeueCounter;
                    PrefetchSubscription.this.dispatched.remove(node);
                    node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void afterRollback() throws Exception {
                Object object = PrefetchSubscription.this.dispatchLock;
                synchronized (object) {
                    if (PrefetchSubscription.this.isSlave()) {
                        node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                    }
                }
            }
        });
    }

    protected void assertAckMatchesDispatched(MessageAck ack) throws JMSException {
        MessageId firstAckedMsg = ack.getFirstMessageId();
        MessageId lastAckedMsg = ack.getLastMessageId();
        int checkCount = 0;
        boolean checkFoundStart = false;
        boolean checkFoundEnd = false;
        for (MessageReference node : this.dispatched) {
            if (firstAckedMsg == null) {
                checkFoundStart = true;
            } else if (!checkFoundStart && firstAckedMsg.equals(node.getMessageId())) {
                checkFoundStart = true;
            }
            if (checkFoundStart) {
                ++checkCount;
            }
            if (lastAckedMsg == null || !lastAckedMsg.equals(node.getMessageId())) continue;
            checkFoundEnd = true;
            break;
        }
        if (!checkFoundStart && firstAckedMsg != null) {
            throw new JMSException("Unmatched acknowledge: " + ack + "; Could not find Message-ID " + firstAckedMsg + " in dispatched-list (start of ack)");
        }
        if (!checkFoundEnd && lastAckedMsg != null) {
            throw new JMSException("Unmatched acknowledge: " + ack + "; Could not find Message-ID " + lastAckedMsg + " in dispatched-list (end of ack)");
        }
        if (ack.getMessageCount() != checkCount && !ack.isInTransaction()) {
            throw new JMSException("Unmatched acknowledge: " + ack + "; Expected message count (" + ack.getMessageCount() + ") differs from count in dispatched-list (" + checkCount + ")");
        }
    }

    protected void sendToDLQ(ConnectionContext context, MessageReference node) throws IOException, Exception {
        this.broker.getRoot().sendToDeadLetterQueue(context, node, this);
    }

    @Override
    public int getInFlightSize() {
        return this.dispatched.size();
    }

    @Override
    public boolean isFull() {
        return this.dispatched.size() - this.prefetchExtension.get() >= this.info.getPrefetchSize();
    }

    @Override
    public boolean isLowWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension.get()) <= (double)this.info.getPrefetchSize() * 0.4;
    }

    @Override
    public boolean isHighWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension.get()) >= (double)this.info.getPrefetchSize() * 0.9;
    }

    @Override
    public int countBeforeFull() {
        return this.info.getPrefetchSize() + this.prefetchExtension.get() - this.dispatched.size();
    }

    @Override
    public int getPendingQueueSize() {
        return this.pending.size();
    }

    @Override
    public int getDispatchedQueueSize() {
        return this.dispatched.size();
    }

    @Override
    public long getDequeueCounter() {
        return this.dequeueCounter;
    }

    @Override
    public long getDispatchedCounter() {
        return this.dispatchCounter;
    }

    @Override
    public long getEnqueueCounter() {
        return this.enqueueCounter;
    }

    @Override
    public boolean isRecoveryRequired() {
        return this.pending.isRecoveryRequired();
    }

    public PendingMessageCursor getPending() {
        return this.pending;
    }

    public void setPending(PendingMessageCursor pending) {
        this.pending = pending;
        if (this.pending != null) {
            this.pending.setSystemUsage(this.usageManager);
            this.pending.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ConnectionContext context, Destination destination) throws Exception {
        Object object = this.pendingLock;
        synchronized (object) {
            super.add(context, destination);
            this.pending.add(context, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        ArrayList<MessageReference> rc = new ArrayList<MessageReference>();
        Object object = this.pendingLock;
        synchronized (object) {
            super.remove(context, destination);
            rc.addAll(this.pending.remove(context, destination));
            Object object2 = this.dispatchLock;
            synchronized (object2) {
                ArrayList<MessageReference> references = new ArrayList<MessageReference>();
                for (MessageReference r : this.dispatched) {
                    if (r.getRegionDestination() != destination) continue;
                    references.add(r);
                }
                rc.addAll(references);
                destination.getDestinationStatistics().getDispatched().subtract(references.size());
                destination.getDestinationStatistics().getInflight().subtract(references.size());
                this.dispatched.removeAll(references);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchPending() throws IOException {
        if (!this.isSlave()) {
            Object object = this.pendingLock;
            synchronized (object) {
                block18: {
                    try {
                        int numberToDispatch = this.countBeforeFull();
                        if (numberToDispatch > 0) {
                            this.setSlowConsumer(false);
                            this.setPendingBatchSize(this.pending, numberToDispatch);
                            int count = 0;
                            this.pending.reset();
                            while (this.pending.hasNext() && !this.isFull() && count < numberToDispatch) {
                                MessageReference node = this.pending.next();
                                if (node == null) {
                                    break block18;
                                }
                                Object object2 = this.dispatchLock;
                                synchronized (object2) {
                                    this.pending.remove();
                                    node.decrementReferenceCount();
                                    if (!this.isDropped(node) && this.canDispatch(node)) {
                                        if (node != QueueMessageReference.NULL_MESSAGE && node.isExpired()) {
                                            ++numberToDispatch;
                                            if (this.broker.isExpired(node)) {
                                                node.getRegionDestination().messageExpired(this.context, this, node);
                                            }
                                            continue;
                                        }
                                        this.dispatch(node);
                                        ++count;
                                    }
                                }
                            }
                            break block18;
                        }
                        if (!this.isSlowConsumer()) {
                            this.setSlowConsumer(true);
                            for (Destination dest : this.destinations) {
                                dest.slowConsumer(this.context, this);
                            }
                        }
                    }
                    finally {
                        this.pending.release();
                    }
                }
            }
        }
    }

    protected void setPendingBatchSize(PendingMessageCursor pending, int numberToDispatch) {
        pending.setMaxBatchSize(numberToDispatch);
    }

    protected boolean dispatch(final MessageReference node) throws IOException {
        final Message message = node.getMessage();
        if (message == null) {
            return false;
        }
        this.okForAckAsDispatchDone.countDown();
        if (!this.isSlave()) {
            MessageDispatch md = this.createMessageDispatch(node, message);
            if (node != QueueMessageReference.NULL_MESSAGE) {
                ++this.dispatchCounter;
                this.dispatched.add(node);
            } else {
                int newExtension;
                int currentExtension;
                while (!this.prefetchExtension.compareAndSet(currentExtension = this.prefetchExtension.get(), newExtension = Math.max(0, currentExtension - 1))) {
                }
            }
            if (this.info.isDispatchAsync()) {
                md.setTransmitCallback(new Runnable(){

                    @Override
                    public void run() {
                        PrefetchSubscription.this.onDispatch(node, message);
                    }
                });
                this.context.getConnection().dispatchAsync(md);
            } else {
                this.context.getConnection().dispatchSync(md);
                this.onDispatch(node, message);
            }
            return true;
        }
        return false;
    }

    protected void onDispatch(MessageReference node, Message message) {
        if (node.getRegionDestination() != null && node != QueueMessageReference.NULL_MESSAGE) {
            node.getRegionDestination().getDestinationStatistics().getDispatched().increment();
            node.getRegionDestination().getDestinationStatistics().getInflight().increment();
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.info.getConsumerId() + " dispatched: " + message.getMessageId() + " - " + message.getDestination() + ", dispatched: " + this.dispatchCounter + ", inflight: " + this.dispatched.size());
            }
        }
        if (this.info.isDispatchAsync()) {
            try {
                this.dispatchPending();
            }
            catch (IOException e) {
                this.context.getConnection().serviceExceptionAsync(e);
            }
        }
    }

    @Override
    public void updateConsumerPrefetch(int newPrefetch) {
        if (this.context != null && this.context.getConnection() != null && this.context.getConnection().isManageable()) {
            ConsumerControl cc = new ConsumerControl();
            cc.setConsumerId(this.info.getConsumerId());
            cc.setPrefetch(newPrefetch);
            this.context.getConnection().dispatchAsync(cc);
        }
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        if (node == QueueMessageReference.NULL_MESSAGE) {
            md.setMessage(null);
            md.setDestination(null);
        } else {
            md.setDestination(node.getRegionDestination().getActiveMQDestination());
            md.setMessage(message);
            md.setRedeliveryCounter(node.getRedeliveryCounter());
        }
        return md;
    }

    protected abstract boolean canDispatch(MessageReference var1) throws IOException;

    protected abstract boolean isDropped(MessageReference var1);

    protected abstract void acknowledge(ConnectionContext var1, MessageAck var2, MessageReference var3) throws IOException;

    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
    }

    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
    }

    public boolean isUsePrefetchExtension() {
        return this.usePrefetchExtension;
    }

    public void setUsePrefetchExtension(boolean usePrefetchExtension) {
        this.usePrefetchExtension = usePrefetchExtension;
    }

    protected int getPrefetchExtension() {
        return this.prefetchExtension.get();
    }

    @Override
    public void setPrefetchSize(int prefetchSize) {
        this.info.setPrefetchSize(prefetchSize);
        try {
            this.dispatchPending();
        }
        catch (Exception e) {
            LOG.trace("Caught exception during dispatch after prefetch change.", e);
        }
    }
}

