/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.fusesource.fabric.stream.log.LogStreamProducer;
import org.fusesource.fabric.stream.log.Main;

public class HttpSimulator {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("dd/MMM/yyyy:HH:mm::ss Z");
    private static final char[] SESSION_DATA_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' ', '=', '-', ';', '.', '{', '}', '[', ']'};
    int producers = 1;
    private ArrayList<String> brokers = new ArrayList();
    private ArrayList<String> destinations = new ArrayList();
    private int batchSize = 65536;
    private long batchTimeout = 5000L;
    private boolean compress = true;
    private double entriesPerSec = 10.0;
    private double entriesPerSecSD = 0.0;
    private long sessionSize = 512L;
    private long sessionSizeSD = 0L;
    int warmupTime = 5;
    int sampleTime = 60;
    private AtomicBoolean done = new AtomicBoolean(false);

    private static void displayHelpAndExit(int exitCode) {
        Main.displayResourceFile("http-simulator-usage.txt");
        System.exit(exitCode);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            System.err.println("Invalid usage: Missing argument");
            HttpSimulator.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    public static void main(String[] args) {
        HttpSimulator simulator = new HttpSimulator();
        LinkedList<String> argl = new LinkedList<String>(Arrays.asList(args));
        while (!argl.isEmpty()) {
            try {
                String arg = argl.removeFirst();
                if ("--help".equals(arg)) {
                    HttpSimulator.displayHelpAndExit(0);
                    continue;
                }
                if ("--producers".equals(arg)) {
                    simulator.producers = Integer.parseInt(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--broker".equals(arg)) {
                    simulator.brokers.add(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--destination".equals(arg)) {
                    simulator.destinations.add(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--batch-size".equals(arg)) {
                    simulator.batchSize = Integer.parseInt(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--batch-timeout".equals(arg)) {
                    simulator.batchTimeout = Long.parseLong(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--compress".equals(arg)) {
                    simulator.compress = Boolean.parseBoolean(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--entries-per-sec".equals(arg)) {
                    simulator.entriesPerSec = Double.parseDouble(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--entries-per-sec-sd".equals(arg)) {
                    simulator.entriesPerSecSD = Double.parseDouble(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--session-size".equals(arg)) {
                    simulator.sessionSize = Long.parseLong(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--session-size-sd".equals(arg)) {
                    simulator.sessionSizeSD = Long.parseLong(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--sample-time".equals(arg)) {
                    simulator.sampleTime = Integer.parseInt(HttpSimulator.shift(argl));
                    continue;
                }
                if ("--warmup-time".equals(arg)) {
                    simulator.warmupTime = Integer.parseInt(HttpSimulator.shift(argl));
                    continue;
                }
                System.err.println("Invalid usage: unknown option: " + arg);
                HttpSimulator.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid usage: argument not a number");
                HttpSimulator.displayHelpAndExit(1);
            }
        }
        if (simulator.brokers.isEmpty()) {
            System.err.println("At least one --broker option is required.");
            HttpSimulator.displayHelpAndExit(1);
        }
        if (simulator.destinations.isEmpty()) {
            System.err.println("At least one --destination option is required.");
            HttpSimulator.displayHelpAndExit(1);
        }
        try {
            simulator.execute();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void sleep(long value) throws InterruptedException {
        long now = System.currentTimeMillis();
        long end = now + value;
        long remaining = end - now;
        while (remaining > 0L && !this.done.get()) {
            Thread.sleep(Math.min(remaining, 1000L));
            now = System.currentTimeMillis();
            remaining = end - now;
        }
    }

    private void execute() throws Exception {
        int i;
        Thread.currentThread().setPriority(10);
        ArrayList<ProducerContext> contexts = new ArrayList<ProducerContext>(this.producers);
        CountDownLatch started = new CountDownLatch(this.producers);
        for (i = 0; i < this.producers; ++i) {
            ProducerContext ctx = new ProducerContext(i, started);
            contexts.add(ctx);
            ctx.start();
        }
        started.await();
        System.out.println(String.format("Warming up for %,d seconds before sampling", this.warmupTime));
        this.sleep(this.warmupTime * 1000);
        for (i = 0; i < this.producers; ++i) {
            ((ProducerContext)contexts.get((int)i)).counter.set(0L);
        }
        while (!this.done.get()) {
            System.out.println(String.format("Sampling for %,d seconds...", this.sampleTime));
            this.sleep(this.sampleTime * 1000);
            DescriptiveStatistics samples = new DescriptiveStatistics();
            samples.setWindowSize(this.producers);
            for (int i2 = 0; i2 < this.producers; ++i2) {
                ProducerContext producer = (ProducerContext)contexts.get(i2);
                samples.addValue(producer.counter.getAndSet(0L));
                producer.changeRate();
            }
            System.out.println(Arrays.toString(samples.getValues()));
            double scale = 1.0 / (double)this.sampleTime;
            System.out.println(String.format("avg producer rate=%,.2f events/sec, sd=%,.2f, total messages produced in the last sample: %.0f", samples.getMean() * scale, samples.getStandardDeviation() * scale, samples.getSum()));
        }
    }

    public void stop() {
        this.done.set(true);
    }

    public void start() {
        new Thread("Monitor thread"){

            @Override
            public void run() {
                try {
                    HttpSimulator.this.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void setBrokers(String brokers) {
        this.brokers = new ArrayList<String>(Arrays.asList(brokers.split("\\|")));
    }

    public void setDestinations(String destinations) {
        this.destinations = new ArrayList<String>(Arrays.asList(destinations.split("\\|")));
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setEntriesPerSec(double entriesPerSec) {
        this.entriesPerSec = entriesPerSec;
    }

    public void setEntriesPerSecSD(double entriesPerSecSD) {
        this.entriesPerSecSD = entriesPerSecSD;
    }

    public void setProducers(int producers) {
        this.producers = producers;
    }

    public void setSampleTime(int sampleTime) {
        this.sampleTime = sampleTime;
    }

    public void setSessionSize(long sessionSize) {
        this.sessionSize = sessionSize;
    }

    public void setSessionSizeSD(long sessionSizeSD) {
        this.sessionSizeSD = sessionSizeSD;
    }

    public void setWarmupTime(int warmupTime) {
        this.warmupTime = warmupTime;
    }

    private class ProducerContext
    implements Runnable {
        private final int id;
        private final CountDownLatch startedLatch;
        private Thread thread;
        private PrintStream out;
        private Random random;
        AtomicLong counter = new AtomicLong();
        volatile double randomEntriesPerSec;
        double feedingsPerMs;
        double msPerFeedings;
        long zeroDelays = 0L;

        public ProducerContext(int id, CountDownLatch started) {
            this.id = id;
            this.startedLatch = started;
            this.random = new Random(id);
            this.changeRate();
        }

        private synchronized void changeRate() {
            this.randomEntriesPerSec = HttpSimulator.this.entriesPerSecSD == 0.0 ? HttpSimulator.this.entriesPerSec : Math.max(0.0, this.random.nextGaussian() * HttpSimulator.this.entriesPerSecSD + HttpSimulator.this.entriesPerSec);
            this.feedingsPerMs = this.randomEntriesPerSec / (double)TimeUnit.SECONDS.toMillis(1L);
            this.msPerFeedings = 1.0 / this.feedingsPerMs;
        }

        private synchronized long nextFeedDelay() {
            if (this.zeroDelays > 0L) {
                --this.zeroDelays;
                if (this.zeroDelays == 0L) {
                    return 1L;
                }
                return 0L;
            }
            if (this.feedingsPerMs > 1.0) {
                this.zeroDelays = (long)this.feedingsPerMs;
                return this.nextFeedDelay();
            }
            return (long)this.msPerFeedings;
        }

        public void start() throws Exception {
            this.thread = new Thread((Runnable)this, "Simulator #: " + this.id);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DefaultCamelContext context = new DefaultCamelContext();
            try {
                PipedInputStream in = new PipedInputStream();
                this.out = new PrintStream(new PipedOutputStream(in));
                LogStreamProducer p = new LogStreamProducer();
                p.setBatchSize(HttpSimulator.this.batchSize);
                p.setBatchTimeout(HttpSimulator.this.batchTimeout);
                p.setCompress(HttpSimulator.this.compress);
                String broker = (String)HttpSimulator.this.brokers.get(this.id % HttpSimulator.this.brokers.size());
                p.setBroker(broker);
                String destination = (String)HttpSimulator.this.destinations.get(this.id % HttpSimulator.this.destinations.size());
                p.setDestination(destination);
                p.setIs(in);
                p.configure(context);
                context.start();
                System.out.println(String.format("Started HTTP log event simulator #" + this.id + " generating %,.2f events/sec", this.randomEntriesPerSec));
                this.startedLatch.countDown();
                long nextMealTime = System.currentTimeMillis() + this.nextFeedDelay();
                while (!HttpSimulator.this.done.get()) {
                    long now = System.currentTimeMillis();
                    if (now >= nextMealTime) {
                        this.feedTheCamel(now);
                        nextMealTime = now + this.nextFeedDelay();
                    }
                    long remaining = nextMealTime - now;
                    HttpSimulator.this.sleep(remaining);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    context.stop();
                }
                catch (Exception exception) {}
            }
        }

        private void feedTheCamel(long now) {
            String ip = "79.132.121.18";
            String date = DATE_FORMATTER.format(now);
            String resource = "/index.html";
            String referer = "http://fusesource.com/index.html";
            String userAgent = "Mozilla/5.0 (X11; Linux i686; rv:7.0.1) Gecko/20100101 Firefox/7.0.1";
            double randomSize = HttpSimulator.this.sessionSizeSD == 0L ? (double)HttpSimulator.this.sessionSize : Math.floor(this.random.nextGaussian() * (double)HttpSimulator.this.sessionSizeSD + (double)HttpSimulator.this.sessionSize);
            int size = Math.min((int)randomSize, 0x400000);
            char[] data = new char[size];
            for (int i = 0; i < size; ++i) {
                data[i] = SESSION_DATA_CHARS[this.random.nextInt(SESSION_DATA_CHARS.length)];
            }
            String session = new String(data);
            this.out.println(String.format("%s - - [%s] \"GET %s HTTP/1.1\" 200 1070 \"%s\" \"%s\" \"session=%s\"", ip, date, resource, referer, userAgent, session));
            this.out.flush();
            this.counter.incrementAndGet();
        }
    }
}

