/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.LifecycleStrategySupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgiServiceRegistry
extends LifecycleStrategySupport
implements Registry {
    private final BundleContext bundleContext;
    private final Map<String, Object> serviceCacheMap = new ConcurrentHashMap<String, Object>();
    private final Queue<ServiceReference> serviceReferenceQueue = new ConcurrentLinkedQueue<ServiceReference>();

    public OsgiServiceRegistry(BundleContext bc) {
        this.bundleContext = bc;
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        Object service = this.lookup(name);
        return type.cast(service);
    }

    @Override
    public Object lookup(String name) {
        ServiceReference sr;
        Object service = this.serviceCacheMap.get(name);
        if (service == null && (sr = this.bundleContext.getServiceReference(name)) != null) {
            this.serviceReferenceQueue.add(sr);
            service = this.bundleContext.getService(sr);
            if (service != null) {
                this.serviceCacheMap.put(name, service);
            }
        }
        return service;
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void onContextStop(CamelContext context) {
        ServiceReference sr = this.serviceReferenceQueue.poll();
        while (sr != null) {
            this.bundleContext.ungetService(sr);
            sr = this.serviceReferenceQueue.poll();
        }
        this.serviceReferenceQueue.clear();
        this.serviceCacheMap.clear();
    }
}

