/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.nio.charset.Charset;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.stream.StreamConsumer;
import org.apache.camel.component.stream.StreamProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(StreamEndpoint.class);
    private String url;
    private String fileName;
    private boolean scanStream;
    private boolean retry;
    private long scanStreamDelay;
    private long delay;
    private String encoding;
    private String promptMessage;
    private long promptDelay;
    private long initialPromptDelay = 2000L;
    private int groupLines;
    private int autoCloseCount = 0;
    private Charset charset;

    public StreamEndpoint(String endpointUri, Component component) throws Exception {
        super(endpointUri, component);
    }

    @Deprecated
    public StreamEndpoint(String endpointUri) {
        super(endpointUri);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new StreamConsumer(this, processor, this.getEndpointUri());
    }

    @Override
    public Producer createProducer() throws Exception {
        return new StreamProducer(this, this.getEndpointUri());
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPromptMessage() {
        return this.promptMessage;
    }

    public void setPromptMessage(String promptMessage) {
        this.promptMessage = promptMessage;
    }

    public long getPromptDelay() {
        return this.promptDelay;
    }

    public void setPromptDelay(long promptDelay) {
        this.promptDelay = promptDelay;
    }

    public long getInitialPromptDelay() {
        return this.initialPromptDelay;
    }

    public void setInitialPromptDelay(long initialPromptDelay) {
        this.initialPromptDelay = initialPromptDelay;
    }

    public boolean isScanStream() {
        return this.scanStream;
    }

    public void setScanStream(boolean scanStream) {
        this.scanStream = scanStream;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public long getScanStreamDelay() {
        return this.scanStreamDelay;
    }

    public void setScanStreamDelay(long scanStreamDelay) {
        this.scanStreamDelay = scanStreamDelay;
    }

    public int getGroupLines() {
        return this.groupLines;
    }

    public void setGroupLines(int groupLines) {
        this.groupLines = groupLines;
    }

    public int getAutoCloseCount() {
        return this.autoCloseCount;
    }

    public void setAutoCloseCount(int autoCloseCount) {
        this.autoCloseCount = autoCloseCount;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    protected void doStart() throws Exception {
        this.charset = this.loadCharset();
    }

    Charset loadCharset() {
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().name();
            LOG.debug("No encoding parameter using default charset: {}", (Object)this.encoding);
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding);
    }
}

