/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQQueueSender;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicPublisher;
import org.apache.activemq.AlreadyClosedException;
import org.apache.activemq.pool.PooledMessageConsumer;
import org.apache.activemq.pool.PooledProducer;
import org.apache.activemq.pool.PooledQueueSender;
import org.apache.activemq.pool.PooledTopicPublisher;
import org.apache.activemq.pool.SessionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledSession
implements Session,
TopicSession,
QueueSession,
XASession {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledSession.class);
    private ActiveMQSession session;
    private SessionPool sessionPool;
    private ActiveMQMessageProducer messageProducer;
    private ActiveMQQueueSender queueSender;
    private ActiveMQTopicPublisher topicPublisher;
    private boolean transactional = true;
    private boolean ignoreClose;
    private final CopyOnWriteArrayList<MessageConsumer> consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<QueueBrowser> browsers = new CopyOnWriteArrayList();
    private boolean isXa;

    public PooledSession(ActiveMQSession aSession, SessionPool sessionPool) {
        this.session = aSession;
        this.sessionPool = sessionPool;
        this.transactional = this.session.isTransacted();
    }

    protected boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    protected void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        if (!this.ignoreClose) {
            boolean invalidate = false;
            try {
                this.getInternalSession().setMessageListener(null);
                for (MessageConsumer consumer : this.consumers) {
                    consumer.close();
                }
                for (QueueBrowser browser : this.browsers) {
                    browser.close();
                }
                if (this.transactional && !this.isXa) {
                    try {
                        this.getInternalSession().rollback();
                    }
                    catch (JMSException e) {
                        invalidate = true;
                        LOG.warn("Caught exception trying rollback() when putting session back into the pool, will invalidate. " + e, e);
                    }
                }
            }
            catch (JMSException ex) {
                invalidate = true;
                LOG.warn("Caught exception trying close() when putting session back into the pool, will invalidate. " + ex, ex);
            }
            finally {
                this.consumers.clear();
                this.browsers.clear();
            }
            if (invalidate) {
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (JMSException e1) {
                        LOG.trace("Ignoring exception on close as discarding session: " + e1, e1);
                    }
                    this.session = null;
                }
                this.sessionPool.invalidateSession(this);
            } else {
                this.sessionPool.returnSession(this);
            }
        }
    }

    @Override
    public void commit() throws JMSException {
        this.getInternalSession().commit();
    }

    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        return this.getInternalSession().createBytesMessage();
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        return this.getInternalSession().createMapMessage();
    }

    @Override
    public Message createMessage() throws JMSException {
        return this.getInternalSession().createMessage();
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getInternalSession().createObjectMessage();
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getInternalSession().createObjectMessage(serializable);
    }

    @Override
    public Queue createQueue(String s) throws JMSException {
        return this.getInternalSession().createQueue(s);
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        return this.getInternalSession().createStreamMessage();
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getInternalSession().createTemporaryQueue();
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getInternalSession().createTemporaryTopic();
    }

    @Override
    public void unsubscribe(String s) throws JMSException {
        this.getInternalSession().unsubscribe(s);
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        return this.getInternalSession().createTextMessage();
    }

    @Override
    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getInternalSession().createTextMessage(s);
    }

    @Override
    public Topic createTopic(String s) throws JMSException {
        return this.getInternalSession().createTopic(s);
    }

    @Override
    public int getAcknowledgeMode() throws JMSException {
        return this.getInternalSession().getAcknowledgeMode();
    }

    @Override
    public boolean getTransacted() throws JMSException {
        return this.getInternalSession().getTransacted();
    }

    @Override
    public void recover() throws JMSException {
        this.getInternalSession().recover();
    }

    @Override
    public void rollback() throws JMSException {
        this.getInternalSession().rollback();
    }

    @Override
    public XAResource getXAResource() {
        if (this.session == null) {
            throw new IllegalStateException("Session is closed");
        }
        return this.session.getTransactionContext();
    }

    @Override
    public Session getSession() {
        return this;
    }

    @Override
    public void run() {
        if (this.session != null) {
            this.session.run();
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue));
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue, selector));
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination));
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector));
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector, noLocal));
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String selector) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, selector));
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, name, selector, noLocal));
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        return this.getInternalSession().getMessageListener();
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getInternalSession().setMessageListener(messageListener);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createSubscriber(topic));
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createSubscriber(topic, selector, local));
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.addQueueReceiver(this.getInternalSession().createReceiver(queue));
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        return this.addQueueReceiver(this.getInternalSession().createReceiver(queue, selector));
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new PooledProducer(this.getMessageProducer(), destination);
    }

    @Override
    public QueueSender createSender(Queue queue) throws JMSException {
        return new PooledQueueSender(this.getQueueSender(), (Destination)queue);
    }

    @Override
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new PooledTopicPublisher(this.getTopicPublisher(), (Destination)topic);
    }

    protected void onConsumerClose(MessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public ActiveMQSession getInternalSession() throws AlreadyClosedException {
        if (this.session == null) {
            throw new AlreadyClosedException("The session has already been closed");
        }
        return this.session;
    }

    public ActiveMQMessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = (ActiveMQMessageProducer)this.getInternalSession().createProducer(null);
        }
        return this.messageProducer;
    }

    public ActiveMQQueueSender getQueueSender() throws JMSException {
        if (this.queueSender == null) {
            this.queueSender = (ActiveMQQueueSender)this.getInternalSession().createSender(null);
        }
        return this.queueSender;
    }

    public ActiveMQTopicPublisher getTopicPublisher() throws JMSException {
        if (this.topicPublisher == null) {
            this.topicPublisher = (ActiveMQTopicPublisher)this.getInternalSession().createPublisher(null);
        }
        return this.topicPublisher;
    }

    private QueueBrowser addQueueBrowser(QueueBrowser browser) {
        this.browsers.add(browser);
        return browser;
    }

    private MessageConsumer addConsumer(MessageConsumer consumer) {
        this.consumers.add(consumer);
        return new PooledMessageConsumer(this, consumer);
    }

    private TopicSubscriber addTopicSubscriber(TopicSubscriber subscriber) {
        this.consumers.add(subscriber);
        return subscriber;
    }

    private QueueReceiver addQueueReceiver(QueueReceiver receiver) {
        this.consumers.add(receiver);
        return receiver;
    }

    public void setIsXa(boolean isXa) {
        this.isXa = isXa;
    }

    public String toString() {
        return "PooledSession { " + this.session + " }";
    }
}

