/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;
import org.apache.camel.util.concurrent.SynchronousExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceHelper {
    public static final String DEFAULT_PATTERN = "Camel Thread ${counter} - ${name}";
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorServiceHelper.class);
    private static AtomicLong threadCounter = new AtomicLong();

    private ExecutorServiceHelper() {
    }

    private static long nextThreadCounter() {
        return threadCounter.getAndIncrement();
    }

    public static String getThreadName(String pattern, String name) {
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        if (name.indexOf("$") > -1) {
            name = name.replaceAll("\\$", "CAMEL_REPLACE_ME");
        }
        String longName = name;
        String shortName = name.contains("?") ? ObjectHelper.before(name, "?") : name;
        String answer = pattern.replaceFirst("\\$\\{counter\\}", "" + ExecutorServiceHelper.nextThreadCounter());
        answer = answer.replaceFirst("\\$\\{longName\\}", longName);
        if ((answer = answer.replaceFirst("\\$\\{name\\}", shortName)).indexOf("$") > -1 || answer.indexOf("${") > -1 || answer.indexOf("}") > -1) {
            throw new IllegalArgumentException("Pattern is invalid: " + pattern);
        }
        if (answer.indexOf("CAMEL_REPLACE_ME") > -1) {
            answer = answer.replaceAll("CAMEL_REPLACE_ME", "\\$");
        }
        return answer;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, String pattern, String name, boolean daemon) {
        return ExecutorServiceHelper.newScheduledThreadPool(poolSize, 0, pattern, name, daemon);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, int maxQueueSize, String pattern, String name, boolean daemon) {
        ScheduledThreadPoolExecutor answer = new ScheduledThreadPoolExecutor(poolSize, new CamelThreadFactory(pattern, name, daemon));
        if (maxQueueSize > 0) {
            return new SizedScheduledExecutorService(answer, maxQueueSize);
        }
        return answer;
    }

    public static ExecutorService newFixedThreadPool(int poolSize, String pattern, String name, boolean daemon) {
        return Executors.newFixedThreadPool(poolSize, new CamelThreadFactory(pattern, name, daemon));
    }

    public static ExecutorService newSingleThreadExecutor(String pattern, String name, boolean daemon) {
        return Executors.newSingleThreadExecutor(new CamelThreadFactory(pattern, name, daemon));
    }

    public static ExecutorService newCachedThreadPool(String pattern, String name, boolean daemon) {
        return Executors.newCachedThreadPool(new CamelThreadFactory(pattern, name, daemon));
    }

    public static ExecutorService newSynchronousThreadPool() {
        return new SynchronousExecutorService();
    }

    public static ExecutorService newThreadPool(String pattern, String name, int corePoolSize, int maxPoolSize) {
        return ExecutorServiceHelper.newThreadPool(pattern, name, corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, -1, new ThreadPoolExecutor.CallerRunsPolicy(), true);
    }

    public static ExecutorService newThreadPool(String pattern, String name, int corePoolSize, int maxPoolSize, int maxQueueSize) {
        return ExecutorServiceHelper.newThreadPool(pattern, name, corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, maxQueueSize, new ThreadPoolExecutor.CallerRunsPolicy(), true);
    }

    public static ExecutorService newThreadPool(String pattern, String name, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, boolean daemon) {
        AbstractQueue queue;
        if (maxPoolSize < corePoolSize) {
            throw new IllegalArgumentException("MaxPoolSize must be >= corePoolSize, was " + maxPoolSize + " >= " + corePoolSize);
        }
        if (corePoolSize == 0 && maxQueueSize <= 0) {
            queue = new SynchronousQueue();
            corePoolSize = 1;
            maxPoolSize = 1;
        } else {
            queue = maxQueueSize <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(maxQueueSize);
        }
        ThreadPoolExecutor answer = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, (BlockingQueue<Runnable>)((Object)queue));
        answer.setThreadFactory(new CamelThreadFactory(pattern, name, daemon));
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        }
        answer.setRejectedExecutionHandler(rejectedExecutionHandler);
        return answer;
    }

    public static ExecutorService getConfiguredExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition definition) throws IllegalArgumentException {
        ExecutorServiceStrategy strategy = routeContext.getCamelContext().getExecutorServiceStrategy();
        ObjectHelper.notNull(strategy, "ExecutorServiceStrategy", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return definition.getExecutorService();
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = strategy.lookup(definition, name, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry.");
            }
            return answer;
        }
        return null;
    }

    public static ScheduledExecutorService getConfiguredScheduledExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition definition) throws IllegalArgumentException {
        ExecutorServiceStrategy strategy = routeContext.getCamelContext().getExecutorServiceStrategy();
        ObjectHelper.notNull(strategy, "ExecutorServiceStrategy", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            ExecutorService executorService = definition.getExecutorService();
            if (executorService instanceof ScheduledExecutorService) {
                return (ScheduledExecutorService)executorService;
            }
            throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " is not an ScheduledExecutorService instance");
        }
        if (definition.getExecutorServiceRef() != null) {
            ScheduledExecutorService answer = strategy.lookupScheduled(definition, name, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry.");
            }
            return answer;
        }
        return null;
    }

    public static void timeoutTask(CompletionService completionService) {
        if (completionService instanceof SubmitOrderedCompletionService) {
            ((SubmitOrderedCompletionService)completionService).timeoutTask();
        }
    }

    private static final class CamelThreadFactory
    implements ThreadFactory {
        private final String pattern;
        private final String name;
        private final boolean daemon;

        private CamelThreadFactory(String pattern, String name, boolean daemon) {
            this.pattern = pattern;
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String threadName = ExecutorServiceHelper.getThreadName(this.pattern, this.name);
            Thread answer = new Thread(runnable, threadName);
            answer.setDaemon(this.daemon);
            LOG.trace("Created thread[{}]: {}", (Object)this.name, (Object)answer);
            return answer;
        }

        public String toString() {
            return "CamelThreadFactory[" + this.name + "]";
        }
    }
}

