/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = -8538318195477618308L;
    private Map<String, String> originalKeys;
    private transient Set<Map.Entry<String, Object>> entrySetView;

    public CaseInsensitiveMap() {
        this.originalKeys = new HashMap<String, String>();
    }

    public CaseInsensitiveMap(Map<? extends String, ?> map) {
        this();
        this.putAll(map);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.originalKeys = new HashMap<String, String>(initialCapacity, loadFactor);
    }

    public CaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
        this.originalKeys = new HashMap<String, String>(initialCapacity);
    }

    @Override
    public Object get(Object key) {
        String s = CaseInsensitiveMap.assembleKey(key);
        Object answer = super.get(s);
        if (answer == null) {
            String originalKey = this.originalKeys.get(s);
            answer = super.get(originalKey);
        }
        return answer;
    }

    @Override
    public synchronized Object put(String key, Object value) {
        this.entrySetView = null;
        String s = CaseInsensitiveMap.assembleKey(key);
        if (key.startsWith("Camel")) {
            this.originalKeys.put(s, key.intern());
        } else {
            this.originalKeys.put(s, key);
        }
        return super.put(s, value);
    }

    @Override
    public synchronized void putAll(Map<? extends String, ?> map) {
        this.entrySetView = null;
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String s = CaseInsensitiveMap.assembleKey(key);
                if (key.startsWith("Camel")) {
                    this.originalKeys.put(s, key.intern());
                } else {
                    this.originalKeys.put(s, key);
                }
                super.put(s, value);
            }
        }
    }

    @Override
    public synchronized Object remove(Object key) {
        if (key == null) {
            return null;
        }
        this.entrySetView = null;
        String s = CaseInsensitiveMap.assembleKey(key);
        this.originalKeys.remove(s);
        return super.remove(s);
    }

    @Override
    public synchronized void clear() {
        this.entrySetView = null;
        this.originalKeys.clear();
        super.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String s = CaseInsensitiveMap.assembleKey(key);
        return super.containsKey(s);
    }

    private static String assembleKey(Object key) {
        String s = key.toString().toLowerCase();
        if (s.startsWith("camel")) {
            s = s.intern();
        }
        return s;
    }

    @Override
    public synchronized Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySetView == null) {
            this.entrySetView = new HashSet<Map.Entry<String, Object>>(this.size());
            for (final Map.Entry entry : super.entrySet()) {
                Map.Entry<String, Object> view = new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        String s = (String)entry.getKey();
                        return (String)CaseInsensitiveMap.this.originalKeys.get(s);
                    }

                    @Override
                    public Object getValue() {
                        return entry.getValue();
                    }

                    @Override
                    public Object setValue(Object o) {
                        return entry.setValue(o);
                    }
                };
                this.entrySetView.add(view);
            }
        }
        return this.entrySetView;
    }
}

