/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.processor.RedeliveryErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spring.spi.TransactionRollbackException;
import org.apache.camel.util.ObjectHelper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandler
extends RedeliveryErrorHandler {
    private final TransactionTemplate transactionTemplate;
    private final String transactionKey;

    public TransactionErrorHandler(CamelContext camelContext, Processor output, CamelLogger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, ExceptionPolicyStrategy exceptionPolicyStrategy, TransactionTemplate transactionTemplate, Predicate retryWhile, String executorServiceRef) {
        super(camelContext, output, logger, redeliveryProcessor, redeliveryPolicy, null, null, false, retryWhile, executorServiceRef);
        this.setExceptionPolicy(exceptionPolicyStrategy);
        this.transactionTemplate = transactionTemplate;
        this.transactionKey = ObjectHelper.getIdentityHashCode(transactionTemplate);
    }

    @Override
    public boolean supportTransacted() {
        return true;
    }

    public String toString() {
        if (this.output == null) {
            return "";
        }
        return "TransactionErrorHandler:" + TransactionErrorHandler.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getOutput() + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (exchange.getUnitOfWork().isTransactedBy(this.transactionKey)) {
            this.processByErrorHandler(exchange);
        } else {
            this.processInTransaction(exchange);
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInTransaction(Exchange exchange) throws Exception {
        try {
            exchange.getUnitOfWork().beginTransactedBy(this.transactionKey);
            this.log.debug("Transaction begin ({}) for ExchangeId: {}", (Object)this.transactionKey, (Object)exchange.getExchangeId());
            this.doInTransactionTemplate(exchange);
            this.log.debug("Transaction commit ({}) for ExchangeId: {}", (Object)this.transactionKey, (Object)exchange.getExchangeId());
        }
        catch (TransactionRollbackException e) {
            this.log.debug("Transaction rollback ({}) for ExchangeId: {} due exchange was marked for rollbackOnly", (Object)this.transactionKey, (Object)exchange.getExchangeId());
        }
        catch (Exception e) {
            this.log.warn("Transaction rollback (" + this.transactionKey + ") for ExchangeId: " + exchange.getExchangeId() + " due exception: " + e.getMessage());
            exchange.setException(e);
        }
        finally {
            exchange.getUnitOfWork().endTransactedBy(this.transactionKey);
        }
        Boolean onlyLast = (Boolean)exchange.removeProperty("CamelRollbackOnlyLast");
        if (onlyLast != null && onlyLast.booleanValue()) {
            if (this.log.isDebugEnabled()) {
                Exception cause = exchange.getException();
                if (cause != null) {
                    this.log.debug("Transaction rollback (" + this.transactionKey + ") for ExchangeId: " + exchange.getExchangeId() + " due exchange was marked for rollbackOnlyLast and due exception: ", cause);
                } else {
                    this.log.debug("Transaction rollback ({}) for ExchangeId: {} due exchange was marked for rollbackOnlyLast", (Object)this.transactionKey, (Object)exchange.getExchangeId());
                }
            }
            exchange.setException(null);
        }
    }

    protected void doInTransactionTemplate(final Exchange exchange) {
        this.transactionTemplate.execute(new TransactionCallbackWithoutResult(){

            @Override
            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TransactionErrorHandler.this.processByErrorHandler(exchange);
                if (exchange.getException() != null || exchange.isRollbackOnly()) {
                    RuntimeException rce = exchange.getException() != null ? ObjectHelper.wrapRuntimeCamelException(exchange.getException()) : new TransactionRollbackException();
                    if (!status.isRollbackOnly()) {
                        status.setRollbackOnly();
                    }
                    throw rce;
                }
            }
        });
    }

    protected void processByErrorHandler(Exchange exchange) {
        super.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
            }
        });
    }

    private static String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKNOWN";
            }
        }
        return rc;
    }
}

