/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.Processor;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.SamplingThrottler;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="sample")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SamplingDefinition
extends OutputDefinition<SamplingDefinition> {
    @XmlAttribute
    private Long samplePeriod;
    @XmlAttribute
    private Long messageFrequency;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit units;

    public SamplingDefinition() {
    }

    public SamplingDefinition(long samplePeriod, TimeUnit units) {
        this.samplePeriod = samplePeriod;
        this.units = units;
    }

    public SamplingDefinition(long messageFrequency) {
        this.messageFrequency = messageFrequency;
    }

    @Override
    public String toString() {
        if (this.messageFrequency != null) {
            return "Sample[1 Exchange per " + this.getMessageFrequency() + " messages received -> " + this.getOutputs() + "]";
        }
        TimeUnit tu = this.getUnits() != null ? this.getUnits() : TimeUnit.SECONDS;
        return "Sample[1 Exchange per " + this.getSamplePeriod() + " " + tu.toString().toLowerCase() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "sample";
    }

    @Override
    public String getLabel() {
        if (this.messageFrequency != null) {
            return "sample[1 Exchange per " + this.getMessageFrequency() + " messages received]";
        }
        TimeUnit tu = this.getUnits() != null ? this.getUnits() : TimeUnit.SECONDS;
        return "sample[1 Exchange per " + this.getSamplePeriod() + " " + tu.name().toLowerCase() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        if (this.messageFrequency != null) {
            return new SamplingThrottler(childProcessor, this.messageFrequency);
        }
        long time = this.getSamplePeriod() != null ? this.getSamplePeriod() : 1L;
        TimeUnit tu = this.getUnits() != null ? this.getUnits() : TimeUnit.SECONDS;
        return new SamplingThrottler(childProcessor, time, tu);
    }

    public SamplingDefinition sampleMessageFrequency(long messageFrequency) {
        this.setMessageFrequency(messageFrequency);
        return this;
    }

    public SamplingDefinition samplePeriod(long samplePeriod) {
        this.setSamplePeriod(samplePeriod);
        return this;
    }

    public SamplingDefinition timeUnits(TimeUnit units) {
        this.setUnits(units);
        return this;
    }

    public Long getSamplePeriod() {
        return this.samplePeriod;
    }

    public void setSamplePeriod(Long samplePeriod) {
        this.samplePeriod = samplePeriod;
    }

    public Long getMessageFrequency() {
        return this.messageFrequency;
    }

    public void setMessageFrequency(Long messageFrequency) {
        this.messageFrequency = messageFrequency;
    }

    public void setUnits(String units) {
        this.units = TimeUnit.valueOf(units);
    }

    public void setUnits(TimeUnit units) {
        this.units = units;
    }

    public TimeUnit getUnits() {
        return this.units;
    }
}

