/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@XmlType(name="dataFormat")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataFormatDefinition
extends IdentifiedType {
    @XmlTransient
    private DataFormat dataFormat;
    @XmlTransient
    private String dataFormatName;

    public DataFormatDefinition() {
    }

    public DataFormatDefinition(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    protected DataFormatDefinition(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public static DataFormat getDataFormat(RouteContext routeContext, DataFormatDefinition type, String ref) {
        if (type == null) {
            ObjectHelper.notNull(ref, "ref or type");
            type = routeContext.getCamelContext().resolveDataFormatDefinition(ref);
            if (type != null) {
                return type.getDataFormat(routeContext);
            }
            DataFormat dataFormat = routeContext.getCamelContext().resolveDataFormat(ref);
            if (dataFormat == null) {
                throw new IllegalArgumentException("Cannot find data format in registry with ref: " + ref);
            }
            return dataFormat;
        }
        return type.getDataFormat(routeContext);
    }

    public DataFormat getDataFormat(RouteContext routeContext) {
        if (this.dataFormat == null) {
            this.dataFormat = this.createDataFormat(routeContext);
            if (this.dataFormat != null) {
                this.configureDataFormat(this.dataFormat);
            } else {
                throw new IllegalArgumentException("Data format '" + (this.dataFormatName != null ? this.dataFormatName : "<null>") + "' could not be created. " + "Ensure that the data format is valid and the associated Camel component is present on the classpath");
            }
        }
        return this.dataFormat;
    }

    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.dataFormatName != null) {
            return routeContext.getCamelContext().resolveDataFormat(this.dataFormatName);
        }
        return null;
    }

    protected void configureDataFormat(DataFormat dataFormat) {
    }

    protected void setProperty(Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property: " + name + " on: " + bean + ". Reason: " + e, e);
        }
    }

    public String getDataFormatName() {
        return this.dataFormatName;
    }

    public void setDataFormatName(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getShortName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("DataFormat")) {
            name = name.substring(0, name.indexOf("DataFormat"));
        }
        return name;
    }
}

