/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.management.mbean.ManagedInstance;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;

public class JmxMBeanAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(JmxMBeanAssembler.class);
    private final MetadataMBeanInfoAssembler assembler;
    private final MBeanServer server;

    public JmxMBeanAssembler(MBeanServer server) {
        this.server = server;
        this.assembler = new MetadataMBeanInfoAssembler();
        this.assembler.setAttributeSource(new AnnotationJmxAttributeSource());
    }

    public RequiredModelMBean assemble(Object obj, ObjectName name) throws JMException {
        Object custom;
        ModelMBeanInfo mbi = null;
        if (obj instanceof ManagedInstance && (custom = ((ManagedInstance)obj).getInstance()) != null && ObjectHelper.hasAnnotation(custom.getClass().getAnnotations(), ManagedResource.class)) {
            LOG.trace("Assembling MBeanInfo for: {} from custom @ManagedResource object: {}", name, custom);
            mbi = this.assembler.getMBeanInfo(custom, name.toString());
            obj = custom;
        }
        if (mbi == null) {
            LOG.trace("Assembling MBeanInfo for: {} from @ManagedResource object: {}", name, obj);
            mbi = this.assembler.getMBeanInfo(obj, name.toString());
        }
        RequiredModelMBean mbean = (RequiredModelMBean)this.server.instantiate(RequiredModelMBean.class.getName());
        mbean.setModelMBeanInfo(mbi);
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new JMException(e.getMessage());
        }
        return mbean;
    }
}

