/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

public enum SimpleLanguageOperator {
    EQ,
    GT,
    GTE,
    LT,
    LTE,
    NOT,
    CONTAINS,
    NOT_CONTAINS,
    REGEX,
    NOT_REGEX,
    IN,
    NOT_IN,
    IS,
    NOT_IS,
    RANGE,
    NOT_RANGE,
    AND,
    OR;


    public static SimpleLanguageOperator asOperator(String text) {
        if ("==".equals(text)) {
            return EQ;
        }
        if (">".equals(text)) {
            return GT;
        }
        if (">=".equals(text)) {
            return GTE;
        }
        if ("<".equals(text)) {
            return LT;
        }
        if ("<=".equals(text)) {
            return LTE;
        }
        if ("!=".equals(text)) {
            return NOT;
        }
        if ("contains".equals(text)) {
            return CONTAINS;
        }
        if ("not contains".equals(text)) {
            return NOT_CONTAINS;
        }
        if ("regex".equals(text)) {
            return REGEX;
        }
        if ("not regex".equals(text)) {
            return NOT_REGEX;
        }
        if ("in".equals(text)) {
            return IN;
        }
        if ("not in".equals(text)) {
            return NOT_IN;
        }
        if ("is".equals(text)) {
            return IS;
        }
        if ("not is".equals(text)) {
            return NOT_IS;
        }
        if ("range".equals(text)) {
            return RANGE;
        }
        if ("not range".equals(text)) {
            return NOT_RANGE;
        }
        if ("and".equals(text)) {
            return AND;
        }
        if ("or".equals(text)) {
            return OR;
        }
        throw new IllegalArgumentException("Operator not supported: " + text);
    }

    public String getOperatorText(SimpleLanguageOperator operator) {
        if (operator == EQ) {
            return "==";
        }
        if (operator == GT) {
            return ">";
        }
        if (operator == GTE) {
            return ">=";
        }
        if (operator == LT) {
            return "<";
        }
        if (operator == LTE) {
            return "<=";
        }
        if (operator == NOT) {
            return "!=";
        }
        if (operator == CONTAINS) {
            return "contains";
        }
        if (operator == NOT_CONTAINS) {
            return "not contains";
        }
        if (operator == REGEX) {
            return "regex";
        }
        if (operator == NOT_REGEX) {
            return "not regex";
        }
        if (operator == IN) {
            return "in";
        }
        if (operator == NOT_IN) {
            return "not in";
        }
        if (operator == IS) {
            return "is";
        }
        if (operator == NOT_IS) {
            return "not is";
        }
        if (operator == RANGE) {
            return "range";
        }
        if (operator == NOT_RANGE) {
            return "not range";
        }
        if (operator == AND) {
            return "and";
        }
        if (operator == OR) {
            return "or";
        }
        return "";
    }

    public String toString() {
        return this.getOperatorText(this);
    }
}

