/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fabric;

import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.fabric.FabricTracer;
import org.apache.camel.fabric.FabricTracerEventMessage;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;

public class FabricTraceProcessor
extends DelegateAsyncProcessor {
    private final Queue<FabricTracerEventMessage> queue;
    private final FabricTracer tracer;
    private final ProcessorDefinition<?> processorDefinition;

    public FabricTraceProcessor(Queue<FabricTracerEventMessage> queue, Processor processor, ProcessorDefinition<?> processorDefinition, FabricTracer tracer) {
        super(processor);
        this.queue = queue;
        this.processorDefinition = processorDefinition;
        this.tracer = tracer;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.tracer.shouldTrace(this.processorDefinition)) {
                int drain = this.queue.size() - this.tracer.getQueueSize();
                if (drain > 0) {
                    for (int i = 0; i < drain; ++i) {
                        this.queue.poll();
                    }
                }
                FabricTracerEventMessage event = new FabricTracerEventMessage(this.tracer.incrementTraceCounter(), exchange, this.processorDefinition);
                this.queue.add(event);
            }
            return super.process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.queue.clear();
    }

    @Override
    public String toString() {
        return this.processor.toString();
    }
}

