/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.seda.CollectionProducer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.util.ExchangeHelper;

public class SedaProducer
extends CollectionProducer {
    private final SedaEndpoint endpoint;
    private final WaitForTaskToComplete waitForTaskToComplete;
    private final long timeout;

    public SedaProducer(SedaEndpoint endpoint, BlockingQueue<Exchange> queue, WaitForTaskToComplete waitForTaskToComplete, long timeout) {
        super(endpoint, queue);
        this.endpoint = endpoint;
        this.waitForTaskToComplete = waitForTaskToComplete;
        this.timeout = timeout;
    }

    @Override
    public boolean process(final Exchange exchange, AsyncCallback callback) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, true);
        copy.setFromEndpoint(this.endpoint);
        WaitForTaskToComplete wait = this.waitForTaskToComplete;
        if (exchange.getProperty("CamelAsyncWait") != null) {
            wait = exchange.getProperty("CamelAsyncWait", WaitForTaskToComplete.class);
        }
        if (wait == WaitForTaskToComplete.Always || wait == WaitForTaskToComplete.IfReplyExpected && ExchangeHelper.isOutCapable(exchange)) {
            final CountDownLatch latch = new CountDownLatch(1);
            copy.addOnCompletion(new SynchronizationAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onDone(Exchange response) {
                    if (latch.getCount() == 0L) {
                        if (SedaProducer.this.log.isTraceEnabled()) {
                            SedaProducer.this.log.trace("{}. Timeout occurred so response will be ignored: {}", this, (Object)(response.hasOut() ? response.getOut() : response.getIn()));
                        }
                        return;
                    }
                    if (SedaProducer.this.log.isTraceEnabled()) {
                        SedaProducer.this.log.trace("{} with response: {}", this, (Object)(response.hasOut() ? response.getOut() : response.getIn()));
                    }
                    try {
                        ExchangeHelper.copyResults(exchange, response);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                @Override
                public boolean allowHandover() {
                    return false;
                }

                public String toString() {
                    return "onDone at [" + SedaProducer.this.endpoint.getEndpointUri() + "]";
                }
            });
            this.log.trace("Adding Exchange to queue: {}", copy);
            this.queue.add(copy);
            if (this.timeout > 0L) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Waiting for task to complete using timeout (ms): {} at [{}]", this.timeout, (Object)this.endpoint.getEndpointUri());
                }
                boolean done = false;
                try {
                    done = latch.await(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!done) {
                    exchange.setException(new ExchangeTimedOutException(exchange, this.timeout));
                    latch.countDown();
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Waiting for task to complete (blocking) at [{}]", (Object)this.endpoint.getEndpointUri());
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {}
            }
        } else {
            this.log.trace("Adding Exchange to queue: {}", copy);
            this.queue.add(copy);
        }
        callback.done(true);
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.onStarted(this);
    }

    @Override
    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        super.doStop();
    }
}

