/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class DirectEndpoint
extends DefaultEndpoint {
    private volatile Map<String, DirectConsumer> consumers;

    public DirectEndpoint() {
        this.consumers = new HashMap<String, DirectConsumer>();
    }

    public DirectEndpoint(String endpointUri) {
        super(endpointUri);
        this.consumers = new HashMap<String, DirectConsumer>();
    }

    public DirectEndpoint(String endpointUri, Component component) {
        this(endpointUri, component, new HashMap<String, DirectConsumer>());
    }

    public DirectEndpoint(String uri, Component component, Map<String, DirectConsumer> consumers) {
        super(uri, component);
        this.consumers = consumers;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DirectProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new DirectConsumer(this, processor);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public void addConsumer(DirectConsumer consumer) {
        String key = consumer.getEndpoint().getEndpointKey();
        this.consumers.put(key, consumer);
    }

    public void removeConsumer(DirectConsumer consumer) {
        String key = consumer.getEndpoint().getEndpointKey();
        this.consumers.remove(key);
    }

    public boolean hasConsumer(DirectConsumer consumer) {
        String key = consumer.getEndpoint().getEndpointKey();
        return this.consumers.containsKey(key);
    }

    public DirectConsumer getConsumer() {
        String key = this.getEndpointKey();
        return this.consumers.get(key);
    }
}

