/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInfoCache;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelInvocationHandler
implements InvocationHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelInvocationHandler.class);
    private static ExecutorService executorService;
    private final Endpoint endpoint;
    private final Producer producer;
    private final MethodInfoCache methodInfoCache;

    public CamelInvocationHandler(Endpoint endpoint, Producer producer, MethodInfoCache methodInfoCache) {
        this.endpoint = endpoint;
        this.producer = producer;
        this.methodInfoCache = methodInfoCache;
    }

    @Override
    public Object invoke(Object proxy, final Method method, Object[] args) throws Throwable {
        BeanInvocation invocation = new BeanInvocation(method, args);
        MethodInfo methodInfo = this.methodInfoCache.getMethodInfo(method);
        final ExchangePattern pattern = methodInfo != null ? methodInfo.getPattern() : ExchangePattern.InOut;
        final DefaultExchange exchange = new DefaultExchange(this.endpoint, pattern);
        exchange.getIn().setBody(invocation);
        final boolean isFuture = method.getReturnType() == Future.class;
        FutureTask<Object> task = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LOG.trace("Proxied method call {} invoking producer: {}", (Object)method.getName(), (Object)CamelInvocationHandler.this.producer);
                CamelInvocationHandler.this.producer.process(exchange);
                Object answer = CamelInvocationHandler.this.afterInvoke(method, exchange, pattern, isFuture);
                LOG.trace("Proxied method call {} returning: {}", (Object)method.getName(), answer);
                return answer;
            }
        });
        if (isFuture) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting task for exchange id {}", (Object)exchange.getExchangeId());
            }
            CamelInvocationHandler.getExecutorService(exchange.getContext()).submit(task);
            return task;
        }
        try {
            task.run();
            return task.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    protected Object afterInvoke(Method method, Exchange exchange, ExchangePattern pattern, boolean isFuture) throws Exception {
        Object answer;
        Exception cause = exchange.getException();
        if (cause != null) {
            Throwable found = this.findSuitableException(cause, method);
            if (found != null) {
                if (found instanceof Exception) {
                    throw (Exception)found;
                }
                throw new CamelExchangeException("Error processing exchange", exchange, cause);
            }
            if (cause instanceof RuntimeCamelException) {
                if (cause.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)((RuntimeCamelException)cause).getCause();
                }
                throw (RuntimeCamelException)cause;
            }
            if (cause instanceof Exception) {
                throw cause;
            }
            throw new CamelExchangeException("Error processing exchange", exchange, cause);
        }
        Class<?> to = method.getReturnType();
        if (to == Void.TYPE) {
            return null;
        }
        if (!isFuture) {
            answer = CamelInvocationHandler.getBody(exchange, to);
        } else {
            Class returnTo = CamelInvocationHandler.getGenericType(exchange.getContext(), method.getGenericReturnType());
            answer = CamelInvocationHandler.getBody(exchange, returnTo);
        }
        return answer;
    }

    private static Object getBody(Exchange exchange, Class<?> type) throws InvalidPayloadException {
        if (exchange.hasOut()) {
            if (exchange.getOut().getBody() != null) {
                return exchange.getOut().getMandatoryBody(type);
            }
            return null;
        }
        if (exchange.getIn().getBody() != null) {
            return exchange.getIn().getMandatoryBody(type);
        }
        return null;
    }

    protected static Class getGenericType(CamelContext context, Type type) throws ClassNotFoundException {
        if (type == null) {
            return Object.class;
        }
        String name = ObjectHelper.between(type.toString(), "<", ">");
        if (name != null) {
            if (name.contains("<")) {
                name = ObjectHelper.before(name, "<");
            }
            return context.getClassResolver().resolveMandatoryClass(name);
        }
        return Object.class;
    }

    protected Throwable findSuitableException(Throwable cause, Method method) {
        if (method.getExceptionTypes() == null || method.getExceptionTypes().length == 0) {
            return null;
        }
        for (Class<?> type : method.getExceptionTypes()) {
            Object fault = ObjectHelper.getException(type, cause);
            if (fault == null) continue;
            return (Throwable)Throwable.class.cast(fault);
        }
        return null;
    }

    protected static synchronized ExecutorService getExecutorService(CamelContext context) {
        if ((executorService == null || executorService.isTerminated() || executorService.isShutdown()) && (executorService = context.getExecutorServiceStrategy().lookup(CamelInvocationHandler.class, "CamelInvocationHandler", "CamelInvocationHandler")) == null) {
            executorService = context.getExecutorServiceStrategy().newDefaultThreadPool(CamelInvocationHandler.class, "CamelInvocationHandler");
        }
        return executorService;
    }
}

