/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.activemq.store.jdbc.DatabaseLocker;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.util.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseLocker
implements DatabaseLocker {
    public static final long DEFAULT_LOCK_ACQUIRE_SLEEP_INTERVAL = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDatabaseLocker.class);
    protected DataSource dataSource;
    protected Statements statements;
    protected long lockAcquireSleepInterval = 1000L;
    protected Connection connection;
    protected boolean stopping;
    protected Handler<Exception> exceptionHandler;

    public DefaultDatabaseLocker() {
    }

    public DefaultDatabaseLocker(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        this.setPersistenceAdapter(persistenceAdapter);
    }

    @Override
    public void setPersistenceAdapter(JDBCPersistenceAdapter adapter) throws IOException {
        this.dataSource = adapter.getLockDataSource();
        this.statements = adapter.getStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.stopping = false;
        LOG.info("Attempting to acquire the exclusive lock to become the Master broker");
        String sql = this.statements.getLockCreateStatement();
        LOG.debug("Locking Query is " + sql);
        Statement statement = null;
        while (true) {
            try {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                statement = this.connection.prepareStatement(sql);
                statement.execute();
                break;
            }
            catch (Exception e) {
                try {
                    if (this.stopping) {
                        throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                    }
                    if (this.exceptionHandler != null) {
                        try {
                            this.exceptionHandler.handle(e);
                        }
                        catch (Throwable handlerException) {
                            LOG.error("The exception handler " + this.exceptionHandler.getClass().getCanonicalName() + " threw this exception: " + handlerException + " while trying to handle this exception: " + e, handlerException);
                        }
                    } else {
                        LOG.debug("Lock failure: " + e, e);
                    }
                }
                finally {
                    if (null != this.connection) {
                        try {
                            this.connection.close();
                        }
                        catch (SQLException e1) {
                            LOG.error("Caught exception while closing connection: " + e1, e1);
                        }
                        this.connection = null;
                    }
                }
            }
            finally {
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e1) {
                        LOG.debug("Caught while closing statement: " + e1, e1);
                    }
                    statement = null;
                }
            }
            LOG.info("Failed to acquire lock.  Sleeping for " + this.lockAcquireSleepInterval + " milli(s) before trying again...");
            try {
                Thread.sleep(this.lockAcquireSleepInterval);
            }
            catch (InterruptedException ie) {
                LOG.warn("Master lock retry sleep interrupted", ie);
            }
        }
        LOG.info("Becoming the master on dataSource: " + this.dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        block13: {
            this.stopping = true;
            try {
                if (this.connection == null || this.connection.isClosed()) break block13;
                try {
                    this.connection.rollback();
                }
                catch (SQLException sqle) {
                    LOG.warn("Exception while rollbacking the connection on shutdown", sqle);
                }
                finally {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException ignored) {
                        LOG.debug("Exception while closing connection on shutdown", ignored);
                    }
                }
            }
            catch (SQLException sqle) {
                LOG.warn("Exception while checking close status of connection on shutdown", sqle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keepAlive() {
        PreparedStatement statement = null;
        boolean result = false;
        try {
            statement = this.connection.prepareStatement(this.statements.getLockUpdateStatement());
            statement.setLong(1, System.currentTimeMillis());
            int rows = statement.executeUpdate();
            if (rows == 1) {
                result = true;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to update database lock: " + e, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error("Failed to close statement", e);
                }
            }
        }
        return result;
    }

    public long getLockAcquireSleepInterval() {
        return this.lockAcquireSleepInterval;
    }

    @Override
    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }

    public Handler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Handler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

