/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.examples.cxf.jaxrs.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public final class Client {
    private Client() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Sent HTTP GET request to query customer info");
        URL url = new URL("http://localhost:8181/cxf/crm/customerservice/customers/123");
        InputStream in = url.openStream();
        System.out.println(Client.getStringFromInputStream(in));
        System.out.println("\n");
        System.out.println("Sent HTTP GET request to query sub resource product info");
        url = new URL("http://localhost:8181/cxf/crm/customerservice/orders/223/products/323");
        in = url.openStream();
        System.out.println(Client.getStringFromInputStream(in));
        System.out.println("\n");
        System.out.println("Sent HTTP PUT request to update customer info");
        Client client = new Client();
        String inputFile = client.getClass().getResource("update_customer.xml").getFile();
        File input = new File(inputFile);
        PutMethod put = new PutMethod("http://localhost:8181/cxf/crm/customerservice/customers");
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)put);
            System.out.println("Response status code: " + result);
            System.out.println("Response body: ");
            System.out.println(put.getResponseBodyAsString());
        }
        finally {
            put.releaseConnection();
        }
        System.out.println("\n");
        System.out.println("Sent HTTP POST request to add customer");
        inputFile = client.getClass().getResource("add_customer.xml").getFile();
        input = new File(inputFile);
        PostMethod post = new PostMethod("http://localhost:8181/cxf/crm/customerservice/customers");
        post.addRequestHeader("Accept", "text/xml");
        entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            System.out.println("Response status code: " + result);
            System.out.println("Response body: ");
            System.out.println(post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
        System.out.println("\n");
        System.exit(0);
    }

    private static String getStringFromInputStream(InputStream in) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int c = 0;
        while ((c = in.read()) != -1) {
            bos.write(c);
        }
        in.close();
        bos.close();
        return bos.toString();
    }
}

