/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import io.fury.Fury;
import io.fury.builder.JITContext;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CompatibleSerializerBase;
import io.fury.serializer.Serializer;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;

public interface Generated {

    public static abstract class GeneratedCompatibleSerializer
    extends CompatibleSerializerBase
    implements Generated {
        public GeneratedCompatibleSerializer(Fury fury, Class<?> type) {
            super(fury, type);
        }
    }

    public static abstract class GeneratedMetaSharedSerializer
    extends GeneratedSerializer
    implements Generated {
        public static final String SERIALIZER_FIELD_NAME = "serializer";
        public Serializer serializer;

        public GeneratedMetaSharedSerializer(Fury fury, Class<?> cls) {
            super(fury, cls);
        }

        public void write(MemoryBuffer buffer, Object value) {
            this.serializer.write(buffer, value);
        }
    }

    public static abstract class GeneratedObjectSerializer
    extends GeneratedSerializer
    implements Generated {
        public GeneratedObjectSerializer(Fury fury, Class<?> cls) {
            super(fury, cls);
        }
    }

    public static abstract class GeneratedSerializer
    extends Serializer
    implements Generated {
        public GeneratedSerializer(Fury fury, Class<?> cls) {
            super(fury, cls);
        }

        public void registerJITNotifyCallback(final Serializer subclassSerializer, Object ... serializerFieldInfos) {
            if (serializerFieldInfos.length > 0) {
                HashMap<String, Field> fieldsMap = new HashMap<String, Field>(serializerFieldInfos.length / 2);
                for (final Field field : this.getClass().getDeclaredFields()) {
                    if (field.getType() != Serializer.class) continue;
                    fieldsMap.put(field.getName(), field);
                }
                for (int i = 0; i < serializerFieldInfos.length; i += 2) {
                    Field field;
                    String serializerFieldName = (String)serializerFieldInfos[i];
                    final Class beanFieldType = (Class)serializerFieldInfos[i + 1];
                    field = Objects.requireNonNull((Field)fieldsMap.get(serializerFieldName));
                    this.fury.getJITContext().registerJITNotifyCallback(beanFieldType, new JITContext.NotifyCallback(){

                        @Override
                        public void onNotifyResult(Object result) {
                            Serializer fieldSerializer = fury.getClassResolver().getSerializer(beanFieldType);
                            Preconditions.checkState(beanFieldType == fieldSerializer.getType());
                            Preconditions.checkState(result == fieldSerializer.getClass());
                            ReflectionUtils.setObjectFieldValue((Object)subclassSerializer, field, fieldSerializer);
                        }

                        @Override
                        public void onNotifyMissed() {
                            Serializer fieldSerializer = fury.getClassResolver().getSerializer(beanFieldType);
                            ReflectionUtils.setObjectFieldValue((Object)subclassSerializer, field, fieldSerializer);
                        }
                    });
                }
            }
        }
    }
}

