/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util.unsafe;

import io.fury.collection.Tuple2;
import io.fury.type.TypeUtils;
import io.fury.util.Preconditions;
import io.fury.util.Utils;
import io.fury.util.function.ToByteFunction;
import io.fury.util.function.ToCharFunction;
import io.fury.util.function.ToFloatFunction;
import io.fury.util.function.ToShortFunction;
import io.fury.util.unsafe._Lookup;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import sun.misc.Unsafe;

public class _JDKAccess {
    public static final int JAVA_VERSION;
    public static final boolean OPEN_J9;
    public static final Unsafe UNSAFE;
    public static final Class<?> _INNER_UNSAFE_CLASS;
    public static final Object _INNER_UNSAFE;
    private static final ClassValue<MethodHandles.Lookup> lookupCache;
    private static final MethodType jdkFunctionMethodType;
    private static final MethodType jdkConsumerMethodType;
    private static final MethodType jdkBiConsumerMethodType;
    private static final Map<Class<?>, Tuple2<Class<?>, String>> methodMap;

    public static MethodHandles.Lookup _trustedLookup(Class<?> objectClass) {
        return lookupCache.get(objectClass);
    }

    public static <T> T tryMakeFunction(MethodHandles.Lookup lookup, MethodHandle handle, Class<T> functionInterface) {
        try {
            return _JDKAccess.makeFunction(lookup, handle, functionInterface);
        }
        catch (Throwable e) {
            Utils.ignore(e);
            throw new IllegalStateException();
        }
    }

    public static <T, R> Function<T, R> makeJDKFunction(MethodHandles.Lookup lookup, MethodHandle handle) {
        try {
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), jdkFunctionMethodType, handle, _JDKAccess.boxedMethodType(handle.type()));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    public static <T> Consumer<T> makeJDKConsumer(MethodHandles.Lookup lookup, MethodHandle handle) {
        try {
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(Consumer.class), jdkConsumerMethodType, handle, _JDKAccess.boxedMethodType(handle.type()));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    public static <T, U> BiConsumer<T, U> makeJDKBiConsumer(MethodHandles.Lookup lookup, MethodHandle handle) {
        try {
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(BiConsumer.class), jdkBiConsumerMethodType, handle, _JDKAccess.boxedMethodType(handle.type()));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    private static MethodType boxedMethodType(MethodType methodType) {
        Class[] paramTypes = new Class[methodType.parameterCount()];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> t = methodType.parameterType(i);
            if (t.isPrimitive()) {
                t = TypeUtils.wrap(t);
            }
            paramTypes[i] = t;
        }
        return MethodType.methodType(methodType.returnType(), paramTypes);
    }

    public static <T> T makeFunction(MethodHandles.Lookup lookup, MethodHandle handle, Method methodToImpl) {
        MethodType instantiatedMethodType = _JDKAccess.boxedMethodType(handle.type());
        MethodType methodToImplType = MethodType.methodType(methodToImpl.getReturnType(), methodToImpl.getParameterTypes());
        try {
            CallSite callSite = LambdaMetafactory.metafactory(lookup, methodToImpl.getName(), MethodType.methodType(methodToImpl.getDeclaringClass()), methodToImplType, handle, instantiatedMethodType);
            return (T)callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    public static <T> T makeFunction(MethodHandles.Lookup lookup, MethodHandle handle, Class<T> functionInterface) {
        String invokedName = "apply";
        try {
            Method[] methods;
            Method method = null;
            for (Method interfaceMethod : methods = functionInterface.getMethods()) {
                if (!interfaceMethod.getName().equals(invokedName)) continue;
                method = interfaceMethod;
                break;
            }
            if (method == null) {
                Preconditions.checkArgument(methods.length == 1);
                method = methods[0];
                invokedName = method.getName();
            }
            MethodType interfaceType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            CallSite callSite = LambdaMetafactory.metafactory(lookup, invokedName, MethodType.methodType(functionInterface), interfaceType, handle, interfaceType);
            return (T)callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    public static Tuple2<Class<?>, String> getterMethodInfo(Class<?> type) {
        Tuple2<Class<?>, String> info = methodMap.get(type);
        if (info == null) {
            return Tuple2.of(Function.class, "apply");
        }
        return info;
    }

    public static Object makeGetterFunction(MethodHandles.Lookup lookup, MethodHandle handle, Class<?> returnType) {
        MethodType factoryType;
        Tuple2<Class<Object>, String> methodInfo = methodMap.get(returnType);
        if (methodInfo == null) {
            methodInfo = Tuple2.of(Function.class, "apply");
            factoryType = jdkFunctionMethodType;
        } else {
            factoryType = MethodType.methodType(returnType, Object.class);
        }
        try {
            CallSite callSite = LambdaMetafactory.metafactory(lookup, (String)methodInfo.f1, MethodType.methodType((Class)methodInfo.f0), factoryType, handle, handle.type());
            return callSite.getTarget().invoke();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return _JDKAccess.makeGetterFunction(lookup, handle, Object.class);
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    static {
        Unsafe unsafe;
        String property = System.getProperty("java.specification.version");
        if (property.startsWith("1.")) {
            property = property.substring(2);
        }
        String jmvName = System.getProperty("java.vm.name", "");
        OPEN_J9 = jmvName.contains("OpenJ9");
        JAVA_VERSION = Integer.parseInt(property);
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
        }
        catch (Throwable cause) {
            throw new UnsupportedOperationException("Unsafe is not supported in this platform.");
        }
        UNSAFE = unsafe;
        if (JAVA_VERSION >= 11) {
            try {
                Field theInternalUnsafeField = Unsafe.class.getDeclaredField("theInternalUnsafe");
                theInternalUnsafeField.setAccessible(true);
                _INNER_UNSAFE = theInternalUnsafeField.get(null);
                _INNER_UNSAFE_CLASS = _INNER_UNSAFE.getClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            _INNER_UNSAFE_CLASS = null;
            _INNER_UNSAFE = null;
        }
        lookupCache = new ClassValue<MethodHandles.Lookup>(){

            @Override
            protected MethodHandles.Lookup computeValue(Class type) {
                return _Lookup._trustedLookup(type);
            }
        };
        jdkFunctionMethodType = MethodType.methodType(Object.class, Object.class);
        jdkConsumerMethodType = MethodType.methodType(Void.TYPE, Object.class);
        jdkBiConsumerMethodType = MethodType.methodType(Void.TYPE, Object.class, Object.class);
        methodMap = new HashMap();
        methodMap.put(Boolean.TYPE, Tuple2.of(Predicate.class, "test"));
        methodMap.put(Byte.TYPE, Tuple2.of(ToByteFunction.class, "applyAsByte"));
        methodMap.put(Character.TYPE, Tuple2.of(ToCharFunction.class, "applyAsChar"));
        methodMap.put(Short.TYPE, Tuple2.of(ToShortFunction.class, "applyAsShort"));
        methodMap.put(Integer.TYPE, Tuple2.of(ToIntFunction.class, "applyAsInt"));
        methodMap.put(Long.TYPE, Tuple2.of(ToLongFunction.class, "applyAsLong"));
        methodMap.put(Float.TYPE, Tuple2.of(ToFloatFunction.class, "applyAsFloat"));
        methodMap.put(Double.TYPE, Tuple2.of(ToDoubleFunction.class, "applyAsDouble"));
    }
}

