/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import com.google.common.reflect.TypeToken;
import io.fury.annotation.Internal;
import io.fury.collection.Tuple3;
import io.fury.type.TypeUtils;
import io.fury.util.FieldAccessor;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.function.Functions;
import io.fury.util.unsafe._JDKAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public class ReflectionUtils {
    private static final ClassValue<MethodHandle> ctrHandleCache = new ClassValue<MethodHandle>(){

        @Override
        protected MethodHandle computeValue(Class<?> type) {
            return ReflectionUtils.createNoArgCtrHandle(type);
        }
    };

    public static boolean isAbstract(Class<?> clazz) {
        if (clazz.isArray()) {
            return false;
        }
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean hasNoArgConstructor(Class<?> clazz) {
        return ReflectionUtils.getNoArgConstructor(clazz) != null;
    }

    public static boolean hasPublicNoArgConstructor(Class<?> clazz) {
        Constructor<?> constructor = ReflectionUtils.getNoArgConstructor(clazz);
        return constructor != null && Modifier.isPublic(constructor.getModifiers());
    }

    static <T> Constructor<T> getNoArgConstructor(Class<T> clazz) {
        if (clazz.isInterface()) {
            return null;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length == 0) {
            return null;
        }
        return Stream.of(constructors).filter(c -> c.getParameterCount() == 0).findAny().orElse(null);
    }

    private static MethodHandle createNoArgCtrHandle(Class<?> cls) {
        Constructor<?> ctr = ReflectionUtils.getNoArgConstructor(cls);
        if (ctr == null) {
            return null;
        }
        MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(ctr.getDeclaringClass());
        try {
            return lookup.findConstructor(ctr.getDeclaringClass(), MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            Platform.throwException(e);
            throw new IllegalStateException("unreachable");
        }
    }

    public static MethodHandle getCtrHandle(Class<?> cls, boolean checked) {
        MethodHandle methodHandle = ctrHandleCache.get(cls);
        if (checked && methodHandle == null) {
            throw new RuntimeException(String.format("Class %s doesn't have a no-arg constructor", cls));
        }
        return methodHandle;
    }

    public static MethodHandle getCtrHandle(Class<?> cls, Class<?> ... types) {
        MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(cls);
        try {
            return lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, types));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            Platform.throwException(e);
            throw new IllegalStateException("unreachable");
        }
    }

    public static List<Method> findMethods(Class<?> cls, String methodName) {
        ArrayList classes = new ArrayList();
        for (Class<?> clazz = cls; clazz != null; clazz = clazz.getSuperclass()) {
            classes.add(clazz);
        }
        classes.addAll(ReflectionUtils.getAllInterfaces(cls));
        if (classes.indexOf(Object.class) == -1) {
            classes.add(Object.class);
        }
        LinkedHashMap methods = new LinkedHashMap();
        for (Class clazz : classes) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                List<Class<?>> params = Arrays.asList(m.getParameterTypes());
                Method method = (Method)methods.get(params);
                if (method == null) {
                    methods.put(params, m);
                    continue;
                }
                if (!method.getReturnType().isAssignableFrom(m.getReturnType())) continue;
                methods.put(params, m);
            }
        }
        return new ArrayList<Method>(methods.values());
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ReflectionUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, LinkedHashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
                if (interfacesFound.contains(anInterface)) continue;
                interfacesFound.add(anInterface);
                ReflectionUtils.getAllInterfaces(anInterface, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static boolean hasException(Class<?> cls, String methodName) {
        List<Method> methods = ReflectionUtils.findMethods(cls, methodName);
        if (methods.isEmpty()) {
            String msg = String.format("class %s doesn't have method %s", cls, methodName);
            throw new IllegalArgumentException(msg);
        }
        return methods.get(0).getExceptionTypes().length > 0;
    }

    public static boolean hasCheckedException(Class<?> cls, String methodName) {
        List<Method> methods = ReflectionUtils.findMethods(cls, methodName);
        if (methods.isEmpty()) {
            String msg = String.format("class %s doesn't have method %s", cls, methodName);
            throw new IllegalArgumentException(msg);
        }
        for (Class<?> exceptionType : methods.get(0).getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getReturnType(Class<?> cls, String methodName) {
        List<Method> methods = ReflectionUtils.findMethods(cls, methodName);
        if (methods.isEmpty()) {
            String msg = String.format("class %s doesn't have method %s", cls, methodName);
            throw new IllegalArgumentException(msg);
        }
        Set returnTypes = methods.stream().map(Method::getReturnType).collect(Collectors.toSet());
        Preconditions.checkArgument(returnTypes.size() == 1);
        return methods.get(0).getReturnType();
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) {
        try {
            return cls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Platform.throwException(e);
            throw new IllegalStateException("Unreachable");
        }
    }

    public static Field getField(Class<?> cls, String fieldName) {
        Field field = ReflectionUtils.getFieldNullable(cls, fieldName);
        if (field == null) {
            String msg = String.format("class %s doesn't have field %s", cls, fieldName);
            throw new IllegalArgumentException(msg);
        }
        return field;
    }

    public static Field getFieldNullable(Class<?> cls, String fieldName) {
        Class<?> clazz = cls;
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public static List<Field> getFields(Class<?> cls, boolean searchParent) {
        Preconditions.checkNotNull(cls);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (searchParent) {
            Class<?> clazz = cls;
            do {
                Collections.addAll(fields, clazz.getDeclaredFields());
            } while ((clazz = clazz.getSuperclass()) != null);
        } else {
            Collections.addAll(fields, cls.getDeclaredFields());
        }
        return fields;
    }

    public static List<Object> getFieldValues(Collection<Field> fields, Object o) {
        ArrayList<Object> results = new ArrayList<Object>(fields.size());
        for (Field field : fields) {
            Object fieldValue = FieldAccessor.createAccessor(field).get(o);
            results.add(fieldValue);
        }
        return results;
    }

    public static long getFieldOffset(Field field) {
        return field == null ? -1L : Platform.objectFieldOffset(field);
    }

    public static long getFieldOffset(Class<?> cls, String fieldName) {
        Field field = ReflectionUtils.getFieldNullable(cls, fieldName);
        return ReflectionUtils.getFieldOffset(field);
    }

    public static long getFieldOffsetChecked(Class<?> cls, String fieldName) {
        long offset = ReflectionUtils.getFieldOffset(cls, fieldName);
        Preconditions.checkArgument(offset != -1L);
        return offset;
    }

    public static Object getObjectFieldValue(Object obj, String fieldName) {
        Class<?> cls = obj.getClass();
        Preconditions.checkArgument(!cls.isPrimitive());
        while (cls != Object.class) {
            try {
                Field field = cls.getDeclaredField(fieldName);
                long fieldOffset = Platform.objectFieldOffset(field);
                return Platform.getObject(obj, fieldOffset);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                cls = cls.getSuperclass();
            }
        }
        return null;
    }

    public static String getClassNameWithoutPackage(Class<?> clz) {
        String className = clz.getName();
        int index = className.lastIndexOf(".");
        if (index != -1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static boolean isPublic(TypeToken<?> targetType) {
        return Modifier.isPublic(TypeUtils.getRawType(targetType).getModifiers());
    }

    public static boolean isPublic(Class<?> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static boolean isPrivate(TypeToken<?> targetType) {
        return Modifier.isPrivate(TypeUtils.getRawType(targetType).getModifiers());
    }

    public static boolean isPrivate(Class<?> cls) {
        return Modifier.isPrivate(cls.getModifiers());
    }

    public static boolean isFinal(Class<?> targetType) {
        return Modifier.isFinal(targetType.getModifiers());
    }

    public static TypeToken getPublicSuperType(TypeToken typeToken) {
        if (!ReflectionUtils.isPublic(typeToken)) {
            Class<?> rawType;
            Class<?> cls;
            for (cls = rawType = Objects.requireNonNull(TypeUtils.getRawType(typeToken)); cls != null && !ReflectionUtils.isPublic(cls); cls = cls.getSuperclass()) {
            }
            if (cls == null) {
                for (Class<?> typeInterface : rawType.getInterfaces()) {
                    if (!ReflectionUtils.isPublic(typeInterface)) continue;
                    return TypeToken.of(typeInterface);
                }
                return TypeUtils.OBJECT_TYPE;
            }
            return TypeToken.of(cls);
        }
        return typeToken;
    }

    public static String getPackage(Class<?> cls) {
        String className;
        int index;
        String pkg = cls.getPackage() == null ? ((index = (className = cls.getName()).lastIndexOf(".")) != -1 ? className.substring(0, index) : "") : cls.getPackage().getName();
        return pkg;
    }

    public static String getCanonicalName(Class<?> cls) {
        String canonicalName = cls.getCanonicalName();
        Preconditions.checkArgument(canonicalName != null, "Class %s doesn't have canonical name", cls, new Object[0]);
        return canonicalName;
    }

    public static Class<?> loadClass(Class<?> neighbor, String className) {
        try {
            if (className.equals(neighbor.getName())) {
                return neighbor;
            }
            ClassLoader classLoader = neighbor.getClassLoader();
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    return loader.loadClass(className);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T unsafeCopy(T obj) {
        Object newInstance = Platform.newInstance(obj.getClass());
        for (Field field : ReflectionUtils.getFields(obj.getClass(), true)) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            FieldAccessor accessor = FieldAccessor.createAccessor(field);
            accessor.set(newInstance, accessor.get(obj));
        }
        return (T)newInstance;
    }

    public static void unsafeCopy(Object from, Object to) {
        Tuple3<Set<String>, Map<String, Field>, Map<String, Field>> commonFieldsInfo = ReflectionUtils.getCommonFields(from.getClass(), to.getClass());
        Map fieldMap1 = (Map)commonFieldsInfo.f1;
        Map fieldMap2 = (Map)commonFieldsInfo.f2;
        for (String commonField : (Set)commonFieldsInfo.f0) {
            Field field1 = (Field)fieldMap1.get(commonField);
            Field field2 = (Field)fieldMap2.get(commonField);
            FieldAccessor accessor1 = FieldAccessor.createAccessor(field1);
            FieldAccessor accessor2 = FieldAccessor.createAccessor(field2);
            accessor2.set(to, accessor1.get(from));
        }
    }

    public static boolean objectFieldsEquals(Object o1, Object o2) {
        List<Field> fields1 = ReflectionUtils.getFields(o1.getClass(), true);
        List<Field> fields2 = ReflectionUtils.getFields(o2.getClass(), true);
        if (fields1.size() != fields2.size()) {
            return false;
        }
        Tuple3<Set<String>, Map<String, Field>, Map<String, Field>> commonFieldsInfo = ReflectionUtils.getCommonFields(o1.getClass(), o2.getClass());
        if (((Map)commonFieldsInfo.f1).size() != fields1.size()) {
            return false;
        }
        if (((Map)commonFieldsInfo.f1).size() != ((Map)commonFieldsInfo.f2).size()) {
            return false;
        }
        return ReflectionUtils.objectCommonFieldsEquals(commonFieldsInfo, o1, o2);
    }

    public static boolean objectFieldsEquals(Set<String> fields, Object o1, Object o2) {
        Tuple3<Set<String>, Map<String, Field>, Map<String, Field>> commonFieldsInfo = ReflectionUtils.getCommonFields(o1.getClass(), o2.getClass());
        Map<String, Field> map1 = ((Map)commonFieldsInfo.f1).entrySet().stream().filter(e -> fields.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Field> map2 = ((Map)commonFieldsInfo.f2).entrySet().stream().filter(e -> fields.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return ReflectionUtils.objectCommonFieldsEquals(Tuple3.of(fields, map1, map2), o1, o2);
    }

    public static boolean objectCommonFieldsEquals(Object o1, Object o2) {
        Tuple3<Set<String>, Map<String, Field>, Map<String, Field>> commonFieldsInfo = ReflectionUtils.getCommonFields(o1.getClass(), o2.getClass());
        return ReflectionUtils.objectCommonFieldsEquals(commonFieldsInfo, o1, o2);
    }

    private static boolean objectCommonFieldsEquals(Tuple3<Set<String>, Map<String, Field>, Map<String, Field>> commonFieldsInfo, Object o1, Object o2) {
        for (String commonField : (Set)commonFieldsInfo.f0) {
            Field field1 = (Field)((Map)commonFieldsInfo.f1).get(commonField);
            Field field2 = (Field)((Map)commonFieldsInfo.f2).get(commonField);
            FieldAccessor accessor1 = FieldAccessor.createAccessor(field1);
            FieldAccessor accessor2 = FieldAccessor.createAccessor(field2);
            Object f1 = accessor1.get(o1);
            Object f2 = accessor2.get(o2);
            if (!(f1 == null ? f2 != null : (field1.getType().isArray() ? (field1.getType() == boolean[].class ? !Arrays.equals((boolean[])f1, (boolean[])f2) : (field1.getType() == byte[].class ? !Arrays.equals((byte[])f1, (byte[])f2) : (field1.getType() == short[].class ? !Arrays.equals((short[])f1, (short[])f2) : (field1.getType() == char[].class ? !Arrays.equals((char[])f1, (char[])f2) : (field1.getType() == int[].class ? !Arrays.equals((int[])f1, (int[])f2) : (field1.getType() == long[].class ? !Arrays.equals((long[])f1, (long[])f2) : (field1.getType() == float[].class ? !Arrays.equals((float[])f1, (float[])f2) : (field1.getType() == double[].class ? !Arrays.equals((double[])f1, (double[])f2) : !Arrays.deepEquals((Object[])f1, (Object[])f2))))))))) : !f1.equals(f2)))) continue;
            return false;
        }
        return true;
    }

    public static Tuple3<Set<String>, Map<String, Field>, Map<String, Field>> getCommonFields(Class<?> cls1, Class<?> cls2) {
        List<Field> fields1 = ReflectionUtils.getFields(cls1, true);
        List<Field> fields2 = ReflectionUtils.getFields(cls2, true);
        return ReflectionUtils.getCommonFields(fields1, fields2);
    }

    public static Tuple3<Set<String>, Map<String, Field>, Map<String, Field>> getCommonFields(List<Field> fields1, List<Field> fields2) {
        Map<String, Field> fieldMap1 = fields1.stream().collect(Collectors.toMap(f -> f.getDeclaringClass().getSimpleName() + f.getType() + f.getName(), f -> f));
        Map<String, Field> fieldMap2 = fields2.stream().collect(Collectors.toMap(f -> f.getDeclaringClass().getSimpleName() + f.getType() + f.getName(), f -> f));
        Set<String> commonFields = fieldMap1.keySet();
        commonFields.retainAll(fieldMap2.keySet());
        return Tuple3.of(commonFields, fieldMap1, fieldMap2);
    }

    public static boolean isJdkProxy(Class<?> clz) {
        return Proxy.isProxyClass(clz);
    }

    public static boolean isDynamicGeneratedCLass(Class<?> cls) {
        return Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls);
    }

    public static boolean isScalaSingletonObject(Class<?> cls) {
        try {
            cls.getDeclaredField("MODULE$");
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }
}

