/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.MapSerializers;
import io.fury.serializer.Serializer;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.slf4j.Logger;

public class UnmodifiableSerializers {
    private static final Logger LOG = LoggerFactory.getLogger(UnmodifiableSerializers.class);
    private static Field SOURCE_COLLECTION_FIELD;
    private static Field SOURCE_MAP_FIELD;
    private static final long SOURCE_COLLECTION_FIELD_OFFSET;
    private static final long SOURCE_MAP_FIELD_OFFSET;

    static Serializer createSerializer(Fury fury, Class<?> cls) {
        for (Tuple2<Class<?>, Function> factory : UnmodifiableSerializers.unmodifiableFactories()) {
            if (factory.f0 != cls) continue;
            return UnmodifiableSerializers.createSerializer(fury, factory);
        }
        throw new IllegalArgumentException("Unsupported type " + cls);
    }

    private static Serializer<?> createSerializer(Fury fury, Tuple2<Class<?>, Function> factory) {
        if (Collection.class.isAssignableFrom((Class)factory.f0)) {
            return new UnmodifiableCollectionSerializer(fury, (Class)factory.f0, (Function)factory.f1, SOURCE_COLLECTION_FIELD_OFFSET);
        }
        return new UnmodifiableMapSerializer(fury, (Class)factory.f0, (Function)factory.f1, SOURCE_MAP_FIELD_OFFSET);
    }

    static Tuple2<Class<?>, Function>[] unmodifiableFactories() {
        Tuple2<Class<?>, Function<Object, Object>> collectionFactory = Tuple2.of(Collections.unmodifiableCollection(Collections.singletonList("")).getClass(), o -> Collections.unmodifiableCollection((Collection)o));
        Tuple2<Class<?>, Function<Object, Object>> randomAccessListFactory = Tuple2.of(Collections.unmodifiableList(new ArrayList()).getClass(), o -> Collections.unmodifiableList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> listFactory = Tuple2.of(Collections.unmodifiableList(new LinkedList()).getClass(), o -> Collections.unmodifiableList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> setFactory = Tuple2.of(Collections.unmodifiableSet(new HashSet()).getClass(), o -> Collections.unmodifiableSet((Set)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedsetFactory = Tuple2.of(Collections.unmodifiableSortedSet(new TreeSet()).getClass(), o -> Collections.unmodifiableSortedSet((SortedSet)o));
        Tuple2<Class<?>, Function<Object, Object>> mapFactory = Tuple2.of(Collections.unmodifiableMap(new HashMap()).getClass(), o -> Collections.unmodifiableMap((Map)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedmapFactory = Tuple2.of(Collections.unmodifiableSortedMap(new TreeMap()).getClass(), o -> Collections.unmodifiableSortedMap((SortedMap)o));
        return new Tuple2[]{collectionFactory, randomAccessListFactory, listFactory, setFactory, sortedsetFactory, mapFactory, sortedmapFactory};
    }

    public static void registerSerializers(Fury fury) {
        if (SOURCE_COLLECTION_FIELD != null && SOURCE_MAP_FIELD != null) {
            for (Tuple2<Class<?>, Function> factory : UnmodifiableSerializers.unmodifiableFactories()) {
                fury.registerSerializer((Class)factory.f0, UnmodifiableSerializers.createSerializer(fury, factory));
            }
        }
    }

    static {
        try {
            SOURCE_COLLECTION_FIELD = Collections.unmodifiableCollection(new ArrayList()).getClass().getDeclaredField("c");
            SOURCE_MAP_FIELD = Collections.unmodifiableMap(new HashMap()).getClass().getDeclaredField("m");
        }
        catch (Exception e) {
            LOG.warn("Could not access source collection field in java.util.Collections$UnmodifiableCollection: {}.", (Object)e.toString());
        }
        SOURCE_COLLECTION_FIELD_OFFSET = ReflectionUtils.getFieldOffset(SOURCE_COLLECTION_FIELD);
        SOURCE_MAP_FIELD_OFFSET = ReflectionUtils.getFieldOffset(SOURCE_MAP_FIELD);
    }

    public static final class UnmodifiableMapSerializer
    extends MapSerializers.MapSerializer<Map> {
        private final Function factory;
        private final long offset;

        public UnmodifiableMapSerializer(Fury fury, Class cls, Function factory, long offset) {
            super(fury, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        @Override
        public void write(MemoryBuffer buffer, Map value) {
            Preconditions.checkArgument((value.getClass() == this.type ? 1 : 0) != 0);
            Object fieldValue = Platform.getObject(value, this.offset);
            this.fury.writeRef(buffer, fieldValue);
        }

        @Override
        public Map read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Map)this.factory.apply(sourceCollection);
        }
    }

    public static final class UnmodifiableCollectionSerializer
    extends CollectionSerializers.CollectionSerializer<Collection> {
        private final Function factory;
        private final long offset;

        public UnmodifiableCollectionSerializer(Fury fury, Class cls, Function factory, long offset) {
            super(fury, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        @Override
        public void write(MemoryBuffer buffer, Collection value) {
            Preconditions.checkArgument((value.getClass() == this.type ? 1 : 0) != 0);
            Object fieldValue = Platform.getObject(value, this.offset);
            this.fury.writeRef(buffer, fieldValue);
        }

        @Override
        public Collection read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Collection)this.factory.apply(sourceCollection);
        }
    }
}

