/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.config.Language;
import io.fury.exception.FuryException;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.ReplaceResolveSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.type.GenericType;
import io.fury.type.Type;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListSet;

public class CollectionSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(ArrayList.class, new ArrayListSerializer(fury));
        Class<List<?>> arrayAsListClass = Arrays.asList(1, 2).getClass();
        fury.registerSerializer(arrayAsListClass, new ArraysAsListSerializer(fury, arrayAsListClass));
        fury.registerSerializer(LinkedList.class, new CollectionSerializer<LinkedList>(fury, LinkedList.class, true));
        fury.registerSerializer(HashSet.class, new HashSetSerializer(fury));
        fury.registerSerializer(LinkedHashSet.class, new LinkedHashSetSerializer(fury));
        fury.registerSerializer(TreeSet.class, new SortedSetSerializer<TreeSet>(fury, TreeSet.class));
        fury.registerSerializer(Collections.EMPTY_LIST.getClass(), new EmptyListSerializer(fury, Collections.EMPTY_LIST.getClass()));
        fury.registerSerializer(Collections.emptySortedSet().getClass(), new EmptySortedSetSerializer(fury, Collections.emptySortedSet().getClass()));
        fury.registerSerializer(Collections.EMPTY_SET.getClass(), new EmptySetSerializer(fury, Collections.EMPTY_SET.getClass()));
        fury.registerSerializer(Collections.singletonList(null).getClass(), new CollectionsSingletonListSerializer(fury, Collections.singletonList(null).getClass()));
        fury.registerSerializer(Collections.singleton(null).getClass(), new CollectionsSingletonSetSerializer(fury, Collections.singleton(null).getClass()));
        fury.registerSerializer(ConcurrentSkipListSet.class, new ConcurrentSkipListSetSerializer(fury, ConcurrentSkipListSet.class));
        fury.registerSerializer(Vector.class, new VectorSerializer(fury, Vector.class));
        fury.registerSerializer(ArrayDeque.class, new ArrayDequeSerializer(fury, ArrayDeque.class));
        fury.registerSerializer(BitSet.class, new BitSetSerializer(fury, BitSet.class));
        fury.registerSerializer(PriorityQueue.class, new PriorityQueueSerializer(fury, PriorityQueue.class));
    }

    public static final class JDKCompatibleCollectionSerializer<T extends Collection>
    extends CollectionSerializer<T> {
        private final Serializer serializer;

        public JDKCompatibleCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            Class serializerType = ClassResolver.useReplaceResolveSerializer(cls) ? ReplaceResolveSerializer.class : fury.getDefaultJDKStreamSerializerType();
            this.serializer = Serializers.newSerializer(fury, cls, serializerType);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)((Collection)this.serializer.read(buffer));
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.serializer.write(buffer, value);
        }
    }

    public static final class DefaultJavaCollectionSerializer<T extends Collection>
    extends CollectionSerializer<T> {
        private Serializer<T> dataSerializer;

        public DefaultJavaCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            Preconditions.checkArgument((fury.getLanguage() == Language.JAVA ? 1 : 0) != 0, (Object)("Python default collection serializer should use " + CollectionSerializer.class));
            fury.getClassResolver().setSerializer(cls, this);
            Class<? extends Serializer> serializerClass = fury.getClassResolver().getObjectSerializerClass(cls, sc -> {
                this.dataSerializer = Serializers.newSerializer(fury, cls, sc);
            });
            this.dataSerializer = Serializers.newSerializer(fury, cls, serializerClass);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.dataSerializer.write(buffer, value);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)((Collection)this.dataSerializer.read(buffer));
        }
    }

    public static class PriorityQueueSerializer
    extends CollectionSerializer<PriorityQueue> {
        public PriorityQueueSerializer(Fury fury, Class<PriorityQueue> cls) {
            super(fury, cls, true);
        }

        @Override
        public void writeHeader(MemoryBuffer buffer, PriorityQueue value) {
            this.fury.writeRef(buffer, value.comparator());
        }

        @Override
        public PriorityQueue newCollection(MemoryBuffer buffer, int numElements) {
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            PriorityQueue queue = new PriorityQueue(comparator);
            this.fury.getRefResolver().reference(queue);
            return queue;
        }
    }

    public static class BitSetSerializer
    extends Serializer<BitSet> {
        public BitSetSerializer(Fury fury, Class<BitSet> type) {
            super(fury, type);
        }

        @Override
        public void write(MemoryBuffer buffer, BitSet set) {
            long[] values = set.toLongArray();
            buffer.writePrimitiveArrayWithSizeEmbedded(values, Platform.LONG_ARRAY_OFFSET, Math.multiplyExact(values.length, 8));
        }

        @Override
        public BitSet read(MemoryBuffer buffer) {
            long[] values = buffer.readLongsWithSizeEmbedded();
            return BitSet.valueOf(values);
        }
    }

    public static class EnumSetSerializer
    extends CollectionSerializer<EnumSet> {
        public EnumSetSerializer(Fury fury, Class<EnumSet> type) {
            super(fury, type, false);
        }

        @Override
        public void write(MemoryBuffer buffer, EnumSet object) {
            Class<?> elemClass;
            if (object.isEmpty()) {
                EnumSet tmp = EnumSet.complementOf(object);
                if (tmp.isEmpty()) {
                    throw new FuryException("An EnumSet must have a defined Enum to be serialized.");
                }
                elemClass = tmp.iterator().next().getClass();
            } else {
                elemClass = object.iterator().next().getClass();
            }
            this.fury.getClassResolver().writeClassAndUpdateCache(buffer, elemClass);
            Serializer<?> serializer = this.fury.getClassResolver().getSerializer(elemClass);
            buffer.writePositiveVarIntAligned(object.size());
            for (Object element : object) {
                serializer.write(buffer, element);
            }
        }

        @Override
        public EnumSet read(MemoryBuffer buffer) {
            Class<?> elemClass = this.fury.getClassResolver().readClassInfo(buffer).getCls();
            EnumSet<?> object = EnumSet.noneOf(elemClass);
            Serializer<?> elemSerializer = this.fury.getClassResolver().getSerializer(elemClass);
            int length = buffer.readPositiveAlignedVarInt();
            for (int i = 0; i < length; ++i) {
                object.add(elemSerializer.read(buffer));
            }
            return object;
        }
    }

    public static final class ArrayDequeSerializer
    extends CollectionSerializer<ArrayDeque> {
        public ArrayDequeSerializer(Fury fury, Class<ArrayDeque> cls) {
            super(fury, cls, true);
        }

        @Override
        public ArrayDeque newCollection(MemoryBuffer buffer, int numElements) {
            ArrayDeque deque = new ArrayDeque(numElements);
            this.fury.getRefResolver().reference(deque);
            return deque;
        }
    }

    public static final class VectorSerializer
    extends CollectionSerializer<Vector> {
        public VectorSerializer(Fury fury, Class<Vector> cls) {
            super(fury, cls, true);
        }

        @Override
        public Vector newCollection(MemoryBuffer buffer, int numElements) {
            Vector vector = new Vector(numElements);
            this.fury.getRefResolver().reference(vector);
            return vector;
        }
    }

    public static final class ConcurrentSkipListSetSerializer
    extends SortedSetSerializer<ConcurrentSkipListSet> {
        public ConcurrentSkipListSetSerializer(Fury fury, Class<ConcurrentSkipListSet> cls) {
            super(fury, cls);
        }

        @Override
        public ConcurrentSkipListSet newCollection(MemoryBuffer buffer, int numElements) {
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            ConcurrentSkipListSet skipListSet = new ConcurrentSkipListSet(comparator);
            this.fury.getRefResolver().reference(skipListSet);
            return skipListSet;
        }
    }

    public static final class CollectionsSingletonSetSerializer
    extends CollectionSerializer<Set<?>> {
        public CollectionsSingletonSetSerializer(Fury fury, Class<Set<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, Set<?> value) {
            this.fury.writeRef(buffer, value.iterator().next());
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Set<?> value) {
            buffer.writePositiveVarInt(1);
            this.fury.xwriteRef(buffer, value.iterator().next());
        }

        @Override
        public Set<?> read(MemoryBuffer buffer) {
            return Collections.singleton(this.fury.readRef(buffer));
        }

        @Override
        public Set<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.singleton(this.fury.xreadRef(buffer));
        }
    }

    public static final class CollectionsSingletonListSerializer
    extends CollectionSerializer<List<?>> {
        public CollectionsSingletonListSerializer(Fury fury, Class<List<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
            this.fury.writeRef(buffer, value.get(0));
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            buffer.writePositiveVarInt(1);
            this.fury.xwriteRef(buffer, value.get(0));
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            return Collections.singletonList(this.fury.readRef(buffer));
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.singletonList(this.fury.xreadRef(buffer));
        }
    }

    public static final class EmptySortedSetSerializer
    extends CollectionSerializer<SortedSet<?>> {
        public EmptySortedSetSerializer(Fury fury, Class<SortedSet<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, SortedSet<?> value) {
        }

        @Override
        public SortedSet<?> read(MemoryBuffer buffer) {
            return Collections.emptySortedSet();
        }
    }

    public static final class EmptySetSerializer
    extends CollectionSerializer<Set<?>> {
        public EmptySetSerializer(Fury fury, Class<Set<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, Set<?> value) {
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Set<?> value) {
            buffer.writePositiveVarInt(0);
        }

        @Override
        public Set<?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.EMPTY_SET;
        }
    }

    public static final class EmptyListSerializer
    extends CollectionSerializer<List<?>> {
        public EmptyListSerializer(Fury fury, Class<List<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            buffer.writePositiveVarInt(0);
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.EMPTY_LIST;
        }
    }

    public static class SortedSetSerializer<T extends SortedSet>
    extends CollectionSerializer<T> {
        private Constructor<?> constructor;

        public SortedSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true);
            if (cls != TreeSet.class) {
                try {
                    this.constructor = cls.getConstructor(Comparator.class);
                    if (!this.constructor.isAccessible()) {
                        this.constructor.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(e);
                }
            }
        }

        @Override
        public void writeHeader(MemoryBuffer buffer, T value) {
            this.fury.writeRef(buffer, value.comparator());
        }

        public T newCollection(MemoryBuffer buffer, int numElements) {
            SortedSet collection;
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            if (this.type == TreeSet.class) {
                collection = new TreeSet(comparator);
            } else {
                try {
                    collection = (SortedSet)this.constructor.newInstance(comparator);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            this.fury.getRefResolver().reference(collection);
            return (T)collection;
        }
    }

    public static final class LinkedHashSetSerializer
    extends CollectionSerializer<LinkedHashSet> {
        public LinkedHashSetSerializer(Fury fury) {
            super(fury, LinkedHashSet.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.FURY_SET.getId();
        }

        @Override
        public LinkedHashSet newCollection(MemoryBuffer buffer, int numElements) {
            LinkedHashSet hashSet = new LinkedHashSet(numElements);
            this.fury.getRefResolver().reference(hashSet);
            return hashSet;
        }
    }

    public static final class HashSetSerializer
    extends CollectionSerializer<HashSet> {
        public HashSetSerializer(Fury fury) {
            super(fury, HashSet.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.FURY_SET.getId();
        }

        @Override
        public HashSet newCollection(MemoryBuffer buffer, int numElements) {
            HashSet hashSet = new HashSet(numElements);
            this.fury.getRefResolver().reference(hashSet);
            return hashSet;
        }
    }

    public static final class ArraysAsListSerializer
    extends CollectionSerializer<List<?>> {
        private final long arrayFieldOffset;

        public ArraysAsListSerializer(Fury fury, Class<List<?>> cls) {
            super(fury, cls, false);
            try {
                Field arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
                this.arrayFieldOffset = ReflectionUtils.getFieldOffset(arrayField);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
            try {
                Object[] array = (Object[])Platform.getObject(value, this.arrayFieldOffset);
                this.fury.writeRef(buffer, array);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            super.xwrite(buffer, value);
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            Object[] array = (Object[])this.fury.readRef(buffer);
            Preconditions.checkNotNull((Object)array);
            return Arrays.asList(array);
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            int numElements = buffer.readPositiveVarInt();
            Object[] arr = new Object[numElements];
            for (int i = 0; i < numElements; ++i) {
                Object elem;
                arr[i] = elem = this.fury.xreadRef(buffer);
            }
            return Arrays.asList(arr);
        }
    }

    public static final class ArrayListSerializer
    extends CollectionSerializer<ArrayList> {
        public ArrayListSerializer(Fury fury) {
            super(fury, ArrayList.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.LIST.getId();
        }

        @Override
        public ArrayList newCollection(MemoryBuffer buffer, int numElements) {
            ArrayList arrayList = new ArrayList(numElements);
            this.fury.getRefResolver().reference(arrayList);
            return arrayList;
        }
    }

    public static class CollectionSerializer<T extends Collection>
    extends Serializer<T> {
        private MethodHandle constructor;
        private final boolean supportCodegenHook;
        private Serializer<?> elemSerializer;
        protected final ClassInfoHolder elementClassInfoHolder;

        public CollectionSerializer(Fury fury, Class<T> cls) {
            this(fury, cls, !ReflectionUtils.isDynamicGeneratedCLass(cls));
        }

        public CollectionSerializer(Fury fury, Class<T> cls, boolean supportCodegenHook) {
            super(fury, cls);
            this.supportCodegenHook = supportCodegenHook;
            this.elementClassInfoHolder = fury.getClassResolver().nilClassInfoHolder();
        }

        private GenericType getElementGenericType(Fury fury) {
            GenericType genericType = fury.getGenerics().nextGenericType();
            GenericType elemGenericType = null;
            if (genericType != null) {
                elemGenericType = genericType.getTypeParameter0();
            }
            return elemGenericType;
        }

        public void setElementSerializer(Serializer serializer) {
            this.elemSerializer = serializer;
        }

        public final boolean supportCodegenHook() {
            return this.supportCodegenHook;
        }

        public void writeHeader(MemoryBuffer buffer, T value) {
        }

        protected final int writeElementsHeader(MemoryBuffer buffer, T value) {
            GenericType elemGenericType = this.getElementGenericType(this.fury);
            if (elemGenericType != null) {
                boolean trackingRef = elemGenericType.trackingRef(this.fury.getClassResolver());
                if (elemGenericType.isFinal()) {
                    if (trackingRef) {
                        buffer.writeByte(Flags.TRACKING_REF);
                        return Flags.TRACKING_REF;
                    }
                    return this.writeNullabilityHeader(buffer, value);
                }
                if (trackingRef) {
                    return this.writeTypeHeader(buffer, value, elemGenericType.getCls(), this.elementClassInfoHolder);
                }
                return this.writeTypeNullabilityHeader(buffer, value, elemGenericType.getCls(), this.elementClassInfoHolder);
            }
            if (this.elemSerializer != null) {
                if (this.elemSerializer.needToWriteRef) {
                    buffer.writeByte(Flags.TRACKING_REF);
                    return Flags.TRACKING_REF;
                }
                return this.writeNullabilityHeader(buffer, value);
            }
            if (this.fury.trackingRef()) {
                return this.writeTypeHeader(buffer, value, this.elementClassInfoHolder);
            }
            return this.writeTypeNullabilityHeader(buffer, value, null, this.elementClassInfoHolder);
        }

        public int writeNullabilityHeader(MemoryBuffer buffer, T value) {
            for (Object elem : value) {
                if (elem != null) continue;
                buffer.writeByte(Flags.HAS_NULL);
                return Flags.HAS_NULL;
            }
            buffer.writeByte(0);
            return 0;
        }

        public int writeTypeHeader(MemoryBuffer buffer, T value, Class<?> declareElementType, ClassInfoHolder cache) {
            int bitmap = Flags.TRACKING_REF;
            boolean hasDifferentClass = false;
            Class<?> elemClass = null;
            for (Object elem : value) {
                if (elem == null) continue;
                if (elemClass == null) {
                    elemClass = elem.getClass();
                    continue;
                }
                if (elemClass == elem.getClass()) continue;
                hasDifferentClass = true;
                break;
            }
            if (hasDifferentClass) {
                buffer.writeByte(bitmap |= Flags.NOT_SAME_TYPE | Flags.NOT_DECL_ELEMENT_TYPE);
            } else if (!this.fury.getConfig().shareMetaContext() && elemClass == declareElementType) {
                buffer.writeByte(bitmap);
            } else {
                buffer.writeByte(bitmap |= Flags.NOT_DECL_ELEMENT_TYPE);
                ClassResolver classResolver = this.fury.getClassResolver();
                ClassInfo classInfo = classResolver.getClassInfo(elemClass, cache);
                classResolver.writeClass(buffer, classInfo);
            }
            return bitmap;
        }

        public int writeTypeHeader(MemoryBuffer buffer, T value, ClassInfoHolder cache) {
            int bitmap = Flags.NOT_DECL_ELEMENT_TYPE;
            boolean hasDifferentClass = false;
            Class<?> elemClass = null;
            boolean containsNull = false;
            for (Object elem : value) {
                if (elem == null) {
                    containsNull = true;
                    continue;
                }
                if (elemClass == null) {
                    elemClass = elem.getClass();
                    continue;
                }
                if (hasDifferentClass || elem.getClass() == elemClass) continue;
                hasDifferentClass = true;
            }
            if (containsNull) {
                bitmap |= Flags.HAS_NULL;
            }
            if (hasDifferentClass) {
                buffer.writeByte(bitmap |= Flags.NOT_SAME_TYPE | Flags.TRACKING_REF);
            } else {
                ClassResolver classResolver = this.fury.getClassResolver();
                ClassInfo classInfo = classResolver.getClassInfo(elemClass, cache);
                if (classInfo.getSerializer().needToWriteRef) {
                    bitmap |= Flags.TRACKING_REF;
                }
                buffer.writeByte(bitmap);
                classResolver.writeClass(buffer, classInfo);
            }
            return bitmap;
        }

        public int writeTypeNullabilityHeader(MemoryBuffer buffer, T value, Class<?> declareElementType, ClassInfoHolder cache) {
            int bitmap = 0;
            boolean containsNull = false;
            boolean hasDifferentClass = false;
            Class<?> elemClass = null;
            for (Object elem : value) {
                if (elem == null) {
                    containsNull = true;
                    continue;
                }
                if (elemClass == null) {
                    elemClass = elem.getClass();
                    continue;
                }
                if (hasDifferentClass || elem.getClass() == elemClass) continue;
                hasDifferentClass = true;
            }
            if (containsNull) {
                bitmap |= Flags.HAS_NULL;
            }
            if (hasDifferentClass) {
                buffer.writeByte(bitmap |= Flags.NOT_SAME_TYPE | Flags.NOT_DECL_ELEMENT_TYPE);
            } else if (!this.fury.getConfig().shareMetaContext() && elemClass == declareElementType) {
                buffer.writeByte(bitmap);
            } else {
                buffer.writeByte(bitmap |= Flags.NOT_DECL_ELEMENT_TYPE);
                ClassResolver classResolver = this.fury.getClassResolver();
                ClassInfo classInfo = classResolver.getClassInfo(elemClass, cache);
                classResolver.writeClass(buffer, classInfo);
            }
            return bitmap;
        }

        public Collection newCollection(MemoryBuffer buffer, int numElements) {
            if (this.constructor == null) {
                this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
            }
            try {
                Collection instance = this.constructor.invoke();
                this.fury.getRefResolver().reference(instance);
                return instance;
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
            }
        }

        public T onCollectionRead(Collection collection) {
            return (T)collection;
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            int len = value.size();
            buffer.writePositiveVarInt(len);
            this.writeHeader(buffer, value);
            if (len != 0) {
                this.writeElements(this.fury, buffer, value);
            }
        }

        protected final void writeElements(Fury fury, MemoryBuffer buffer, T value) {
            int flags = this.writeElementsHeader(buffer, value);
            Serializer<?> serializer = this.elemSerializer;
            this.elemSerializer = null;
            if (serializer == null) {
                GenericType elemGenericType = this.getElementGenericType(fury);
                if (elemGenericType != null) {
                    this.javaWriteWithGenerics(fury, buffer, value, elemGenericType, flags);
                } else {
                    this.generalJavaWrite(fury, buffer, value, elemGenericType, flags);
                }
            } else {
                CollectionSerializer.compatibleWrite(fury, buffer, value, serializer, flags);
            }
        }

        private static <T extends Collection> void compatibleWrite(Fury fury, MemoryBuffer buffer, T value, Serializer serializer, int flags) {
            if (serializer.needToWriteRef) {
                for (Object elem : value) {
                    fury.writeRef(buffer, elem, serializer);
                }
            } else {
                boolean hasNull;
                boolean bl = hasNull = (flags & Flags.HAS_NULL) == Flags.HAS_NULL;
                if (hasNull) {
                    for (Object elem : value) {
                        if (elem == null) {
                            buffer.writeByte((byte)-3);
                            continue;
                        }
                        buffer.writeByte((byte)-1);
                        serializer.write(buffer, elem);
                    }
                } else {
                    for (Object elem : value) {
                        serializer.write(buffer, elem);
                    }
                }
            }
        }

        private void javaWriteWithGenerics(Fury fury, MemoryBuffer buffer, T collection, GenericType elemGenericType, int flags) {
            boolean hasGenericParameters = elemGenericType.hasGenericParameters();
            if (hasGenericParameters) {
                fury.getGenerics().pushGenericType(elemGenericType);
            }
            if (elemGenericType.isFinal()) {
                Serializer<?> serializer = elemGenericType.getSerializer(fury.getClassResolver());
                CollectionSerializer.writeSameTypeElements(fury, buffer, serializer, flags, collection);
            } else {
                this.generalJavaWrite(fury, buffer, collection, elemGenericType, flags);
            }
            if (hasGenericParameters) {
                fury.getGenerics().popGenericType();
            }
        }

        private void generalJavaWrite(Fury fury, MemoryBuffer buffer, T collection, GenericType elemGenericType, int flags) {
            if ((flags & Flags.NOT_SAME_TYPE) != Flags.NOT_SAME_TYPE) {
                Serializer<?> serializer = (flags & Flags.NOT_DECL_ELEMENT_TYPE) != Flags.NOT_DECL_ELEMENT_TYPE ? elemGenericType.getSerializer(fury.getClassResolver()) : this.elementClassInfoHolder.getSerializer();
                CollectionSerializer.writeSameTypeElements(fury, buffer, serializer, flags, collection);
            } else {
                CollectionSerializer.writeDifferentTypeElements(fury, buffer, flags, collection);
            }
        }

        private static <T extends Collection> void writeSameTypeElements(Fury fury, MemoryBuffer buffer, Serializer serializer, int flags, T collection) {
            fury.incDepth(1);
            if ((flags & Flags.TRACKING_REF) == Flags.TRACKING_REF) {
                RefResolver refResolver = fury.getRefResolver();
                for (Object elem : collection) {
                    if (refResolver.writeRefOrNull(buffer, elem)) continue;
                    serializer.write(buffer, elem);
                }
            } else if ((flags & Flags.HAS_NULL) != Flags.HAS_NULL) {
                for (Object elem : collection) {
                    serializer.write(buffer, elem);
                }
            } else {
                for (Object elem : collection) {
                    if (elem == null) {
                        buffer.writeByte((byte)-3);
                        continue;
                    }
                    buffer.writeByte((byte)-1);
                    serializer.write(buffer, elem);
                }
            }
            fury.incDepth(-1);
        }

        private static <T extends Collection> void writeDifferentTypeElements(Fury fury, MemoryBuffer buffer, int flags, T collection) {
            if ((flags & Flags.TRACKING_REF) == Flags.TRACKING_REF) {
                for (Object elem : collection) {
                    fury.writeRef(buffer, elem);
                }
            } else if ((flags & Flags.HAS_NULL) != Flags.HAS_NULL) {
                for (Object elem : collection) {
                    fury.writeNonRef(buffer, elem);
                }
            } else {
                for (Object elem : collection) {
                    fury.writeNullable(buffer, elem);
                }
            }
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            int len = value.size();
            buffer.writePositiveVarInt(len);
            this.xwriteElements(this.fury, buffer, (Collection)value);
        }

        private void xwriteElements(Fury fury, MemoryBuffer buffer, Collection value) {
            GenericType elemGenericType = this.getElementGenericType(fury);
            if (elemGenericType != null) {
                boolean hasGenericParameters = elemGenericType.hasGenericParameters();
                if (hasGenericParameters) {
                    fury.getGenerics().pushGenericType(elemGenericType);
                }
                if (elemGenericType.isFinal()) {
                    Serializer<?> elemSerializer = elemGenericType.getSerializer(fury.getClassResolver());
                    for (Object elem : value) {
                        fury.xwriteRef(buffer, elem, elemSerializer);
                    }
                } else {
                    for (Object elem : value) {
                        fury.xwriteRef(buffer, elem);
                    }
                }
                if (hasGenericParameters) {
                    fury.getGenerics().popGenericType();
                }
            } else {
                for (Object elem : value) {
                    fury.xwriteRef(buffer, elem);
                }
            }
        }

        @Override
        public T read(MemoryBuffer buffer) {
            int numElements = buffer.readPositiveVarInt();
            Collection collection = this.newCollection(buffer, numElements);
            if (numElements != 0) {
                this.readElements(this.fury, buffer, collection, numElements);
            }
            return this.onCollectionRead(collection);
        }

        private void readElements(Fury fury, MemoryBuffer buffer, Collection collection, int numElements) {
            byte flags = buffer.readByte();
            Serializer<?> serializer = this.elemSerializer;
            this.elemSerializer = null;
            if (serializer == null) {
                GenericType elemGenericType = this.getElementGenericType(fury);
                if (elemGenericType != null) {
                    this.javaReadWithGenerics(fury, buffer, collection, numElements, elemGenericType, flags);
                } else {
                    this.generalJavaRead(fury, buffer, collection, numElements, flags, null);
                }
            } else {
                CollectionSerializer.compatibleRead(fury, buffer, collection, numElements, serializer, flags);
            }
        }

        private static void compatibleRead(Fury fury, MemoryBuffer buffer, Collection collection, int numElements, Serializer serializer, int flags) {
            if (serializer.needToWriteRef) {
                for (int i = 0; i < numElements; ++i) {
                    collection.add(fury.readRef(buffer, serializer));
                }
            } else if ((flags & Flags.HAS_NULL) == Flags.HAS_NULL) {
                for (int i = 0; i < numElements; ++i) {
                    if (buffer.readByte() == -3) {
                        collection.add(null);
                        continue;
                    }
                    Object elem = serializer.read(buffer);
                    collection.add(elem);
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    Object elem = serializer.read(buffer);
                    collection.add(elem);
                }
            }
        }

        private void javaReadWithGenerics(Fury fury, MemoryBuffer buffer, Collection collection, int numElements, GenericType elemGenericType, int flags) {
            boolean hasGenericParameters = elemGenericType.hasGenericParameters();
            if (hasGenericParameters) {
                fury.getGenerics().pushGenericType(elemGenericType);
            }
            if (elemGenericType.isFinal()) {
                Serializer<?> serializer = elemGenericType.getSerializer(fury.getClassResolver());
                CollectionSerializer.readSameTypeElements(fury, buffer, serializer, flags, collection, numElements);
            } else {
                this.generalJavaRead(fury, buffer, collection, numElements, flags, elemGenericType);
            }
            if (hasGenericParameters) {
                fury.getGenerics().popGenericType();
            }
        }

        private void generalJavaRead(Fury fury, MemoryBuffer buffer, Collection collection, int numElements, int flags, GenericType elemGenericType) {
            if ((flags & Flags.NOT_SAME_TYPE) != Flags.NOT_SAME_TYPE) {
                Serializer<Object> serializer;
                ClassResolver classResolver = fury.getClassResolver();
                if ((flags & Flags.NOT_DECL_ELEMENT_TYPE) == Flags.NOT_DECL_ELEMENT_TYPE) {
                    serializer = classResolver.readClassInfo(buffer, this.elementClassInfoHolder).getSerializer();
                } else {
                    Preconditions.checkNotNull((Object)elemGenericType);
                    serializer = elemGenericType.getSerializer(classResolver);
                }
                CollectionSerializer.readSameTypeElements(fury, buffer, serializer, flags, collection, numElements);
            } else {
                CollectionSerializer.readDifferentTypeElements(fury, buffer, flags, collection, numElements);
            }
        }

        private static <T extends Collection> void readSameTypeElements(Fury fury, MemoryBuffer buffer, Serializer serializer, int flags, T collection, int numElements) {
            fury.incDepth(1);
            if ((flags & Flags.TRACKING_REF) == Flags.TRACKING_REF) {
                for (int i = 0; i < numElements; ++i) {
                    collection.add(fury.readRef(buffer, serializer));
                }
            } else if ((flags & Flags.HAS_NULL) != Flags.HAS_NULL) {
                for (int i = 0; i < numElements; ++i) {
                    collection.add(serializer.read(buffer));
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    if (buffer.readByte() == -3) {
                        collection.add(null);
                        continue;
                    }
                    collection.add(serializer.read(buffer));
                }
            }
            fury.incDepth(-1);
        }

        private static <T extends Collection> void readDifferentTypeElements(Fury fury, MemoryBuffer buffer, int flags, T collection, int numElements) {
            if ((flags & Flags.TRACKING_REF) == Flags.TRACKING_REF) {
                for (int i = 0; i < numElements; ++i) {
                    collection.add((Object)fury.readRef(buffer));
                }
            } else if ((flags & Flags.HAS_NULL) != Flags.HAS_NULL) {
                for (int i = 0; i < numElements; ++i) {
                    collection.add((Object)fury.readNonRef(buffer));
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    collection.add((Object)fury.readNullable(buffer));
                }
            }
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int numElements = buffer.readPositiveVarInt();
            Collection collection = this.newCollection(buffer, numElements);
            this.xreadElements(this.fury, buffer, collection, numElements);
            return this.onCollectionRead(collection);
        }

        public void xreadElements(Fury fury, MemoryBuffer buffer, Collection collection, int numElements) {
            GenericType elemGenericType = this.getElementGenericType(fury);
            if (elemGenericType != null) {
                boolean hasGenericParameters = elemGenericType.hasGenericParameters();
                if (hasGenericParameters) {
                    fury.getGenerics().pushGenericType(elemGenericType);
                }
                if (elemGenericType.isFinal()) {
                    Serializer<?> elemSerializer = elemGenericType.getSerializer(fury.getClassResolver());
                    for (int i = 0; i < numElements; ++i) {
                        Object elem = fury.xreadRefByNullableSerializer(buffer, elemSerializer);
                        collection.add(elem);
                    }
                } else {
                    for (int i = 0; i < numElements; ++i) {
                        Object elem = fury.xreadRef(buffer);
                        collection.add(elem);
                    }
                }
                if (hasGenericParameters) {
                    fury.getGenerics().popGenericType();
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    Object elem = fury.xreadRef(buffer);
                    collection.add(elem);
                }
            }
        }
    }

    public static class Flags {
        public static int TRACKING_REF = 1;
        public static int HAS_NULL = 2;
        public static int NOT_DECL_ELEMENT_TYPE = 4;
        public static int NOT_SAME_TYPE = 8;
    }
}

