/*
 * Decompiled with CFR 0.152.
 */
package io.fury.config;

import io.fury.Fury;
import io.fury.ThreadLocalFury;
import io.fury.ThreadSafeFury;
import io.fury.config.CompatibleMode;
import io.fury.config.Language;
import io.fury.config.LongEncoding;
import io.fury.pool.ThreadPoolFury;
import io.fury.serializer.JavaSerializer;
import io.fury.serializer.ObjectStreamSerializer;
import io.fury.serializer.Serializer;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class FuryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FuryBuilder.class);
    private static final boolean ENABLE_CLASS_REGISTRATION_FORCIBLY;
    boolean checkClassVersion = false;
    Language language = Language.JAVA;
    boolean trackingRef = false;
    boolean basicTypesRefIgnored = true;
    boolean stringRefIgnored = true;
    boolean timeRefIgnored = true;
    ClassLoader classLoader;
    boolean compressInt = true;
    public LongEncoding longEncoding = LongEncoding.SLI;
    boolean compressString = true;
    CompatibleMode compatibleMode = CompatibleMode.SCHEMA_CONSISTENT;
    boolean checkJdkClassSerializable = true;
    Class<? extends Serializer> defaultJDKStreamSerializerType = ObjectStreamSerializer.class;
    boolean requireClassRegistration = true;
    boolean shareMetaContext = false;
    boolean codeGenEnabled = true;
    public boolean deserializeUnexistedClass = false;
    public boolean asyncCompilationEnabled = false;
    public boolean registerGuavaTypes = true;

    public FuryBuilder withLanguage(Language language) {
        this.language = language;
        return this;
    }

    public FuryBuilder withRefTracking(boolean trackingRef) {
        this.trackingRef = trackingRef;
        return this;
    }

    public FuryBuilder ignoreBasicTypesRef(boolean ignoreBasicTypesRef) {
        this.basicTypesRefIgnored = ignoreBasicTypesRef;
        return this;
    }

    public FuryBuilder ignoreStringRef(boolean ignoreStringRef) {
        this.stringRefIgnored = ignoreStringRef;
        return this;
    }

    public FuryBuilder ignoreTimeRef(boolean ignoreTimeRef) {
        this.timeRefIgnored = ignoreTimeRef;
        return this;
    }

    public FuryBuilder withNumberCompressed(boolean numberCompressed) {
        this.compressInt = numberCompressed;
        this.withLongCompressed(numberCompressed);
        return this;
    }

    public FuryBuilder withIntCompressed(boolean intCompressed) {
        this.compressInt = intCompressed;
        return this;
    }

    public FuryBuilder withLongCompressed(boolean longCompressed) {
        return this.withLongCompressed(longCompressed ? LongEncoding.SLI : LongEncoding.LE_RAW_BYTES);
    }

    public FuryBuilder withLongCompressed(LongEncoding longEncoding) {
        this.longEncoding = Objects.requireNonNull(longEncoding);
        return this;
    }

    public FuryBuilder withStringCompressed(boolean stringCompressed) {
        this.compressString = stringCompressed;
        return this;
    }

    public FuryBuilder withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public FuryBuilder withCompatibleMode(CompatibleMode compatibleMode) {
        this.compatibleMode = compatibleMode;
        return this;
    }

    public FuryBuilder withClassVersionCheck(boolean checkClassVersion) {
        this.checkClassVersion = checkClassVersion;
        return this;
    }

    public FuryBuilder withJdkClassSerializableCheck(boolean checkJdkClassSerializable) {
        this.checkJdkClassSerializable = checkJdkClassSerializable;
        return this;
    }

    public FuryBuilder registerGuavaTypes(boolean register) {
        this.registerGuavaTypes = register;
        return this;
    }

    public FuryBuilder requireClassRegistration(boolean requireClassRegistration) {
        this.requireClassRegistration = requireClassRegistration;
        return this;
    }

    public FuryBuilder withMetaContextShare(boolean shareMetaContext) {
        this.shareMetaContext = shareMetaContext;
        return this;
    }

    public FuryBuilder withDeserializeUnexistedClass(boolean deserializeUnexistedClass) {
        this.deserializeUnexistedClass = deserializeUnexistedClass;
        return this;
    }

    public FuryBuilder withCodegen(boolean codeGen) {
        this.codeGenEnabled = codeGen;
        return this;
    }

    public FuryBuilder withAsyncCompilation(boolean asyncCompilation) {
        this.asyncCompilationEnabled = asyncCompilation;
        return this;
    }

    private void finish() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.language != Language.JAVA) {
            this.stringRefIgnored = false;
        }
        if (ENABLE_CLASS_REGISTRATION_FORCIBLY && !this.requireClassRegistration) {
            LOG.warn("Class registration is enabled forcibly.");
            this.requireClassRegistration = true;
        }
        if (this.defaultJDKStreamSerializerType == JavaSerializer.class) {
            LOG.warn("JDK serialization is used for types which customized java serialization by implementing methods such as writeObject/readObject. This is not secure, try to use {} instead, or implement a custom {}.", ObjectStreamSerializer.class, Serializer.class);
        }
        if (this.compatibleMode == CompatibleMode.COMPATIBLE) {
            this.checkClassVersion = false;
        }
        if (!this.requireClassRegistration) {
            LOG.warn("Class registration isn't forced, unknown classes can be deserialized. If the environment isn't secure, please enable class registration by `FuryBuilder#requireClassRegistration(true)` or configure ClassChecker by `ClassResolver#setClassChecker`");
        }
    }

    private static Fury newFury(FuryBuilder builder, ClassLoader classLoader) {
        try {
            return new Fury(builder, classLoader);
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.error("Fury creation failed with classloader {}", (Object)classLoader);
            Platform.throwException(t);
            throw new RuntimeException(t);
        }
    }

    public Fury build() {
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        return FuryBuilder.newFury(this, loader);
    }

    public ThreadSafeFury buildThreadSafeFury() {
        return this.buildThreadLocalFury();
    }

    public ThreadLocalFury buildThreadLocalFury() {
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        ThreadLocalFury threadSafeFury = new ThreadLocalFury(classLoader -> FuryBuilder.newFury(this, classLoader));
        threadSafeFury.setClassLoader(loader);
        return threadSafeFury;
    }

    public ThreadSafeFury buildThreadSafeFuryPool(int minPoolSize, int maxPoolSize) {
        return this.buildThreadSafeFuryPool(minPoolSize, maxPoolSize, 30L, TimeUnit.SECONDS);
    }

    public ThreadSafeFury buildThreadSafeFuryPool(int minPoolSize, int maxPoolSize, long expireTime, TimeUnit timeUnit) {
        if (minPoolSize < 0 || maxPoolSize < 0 || minPoolSize > maxPoolSize) {
            throw new IllegalArgumentException(String.format("thread safe fury pool's init pool size error, please check it, min:[%s], max:[%s]", minPoolSize, maxPoolSize));
        }
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        ThreadPoolFury threadSafeFury = new ThreadPoolFury(classLoader -> FuryBuilder.newFury(this, classLoader), minPoolSize, maxPoolSize, expireTime, timeUnit);
        threadSafeFury.setClassLoader(loader);
        return threadSafeFury;
    }

    static {
        String flagValue = System.getProperty("fury.enable_fury_security_mode_forcibly", System.getenv("ENABLE_CLASS_REGISTRATION_FORCIBLY"));
        if (flagValue == null) {
            flagValue = "false";
        }
        ENABLE_CLASS_REGISTRATION_FORCIBLY = "true".equals(flagValue) || "1".equals(flagValue);
    }
}

