/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.collection.Tuple3;
import io.fury.exception.FuryException;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.type.FinalObjectTypeStub;
import io.fury.type.GenericType;
import io.fury.type.Generics;
import io.fury.type.TypeUtils;
import io.fury.util.FieldAccessor;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import io.fury.util.record.RecordInfo;
import io.fury.util.record.RecordUtils;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ObjectSerializer<T>
extends Serializer<T> {
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final boolean isRecord;
    private final RecordInfo recordInfo;
    private final FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final GenericTypeField[] otherFields;
    private final GenericTypeField[] containerFields;
    private final MethodHandle constructor;
    private final int classVersionHash;

    public ObjectSerializer(Fury fury, Class<T> cls) {
        this(fury, cls, true);
    }

    public ObjectSerializer(Fury fury, Class<T> cls, boolean resolveParent) {
        super(fury, cls);
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.classResolver.setSerializerIfAbsent(cls, this);
        Collection<Descriptor> descriptors = fury.getClassResolver().getAllDescriptorsMap(cls, resolveParent).values();
        DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(descriptors, false, fury.compressInt(), fury.compressLong());
        this.isRecord = RecordUtils.isRecord(cls);
        if (this.isRecord) {
            this.constructor = (MethodHandle)RecordUtils.getRecordConstructor(cls).f1;
            List<String> fieldNames = descriptorGrouper.getSortedDescriptors().stream().map(Descriptor::getName).collect(Collectors.toList());
            this.recordInfo = new RecordInfo(cls, fieldNames);
        } else {
            this.constructor = ReflectionUtils.getExecutableNoArgConstructorHandle(cls);
            this.recordInfo = null;
        }
        this.classVersionHash = fury.checkClassVersion() ? ObjectSerializer.computeVersionHash(descriptors) : 0;
        Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> infos = ObjectSerializer.buildFieldInfos(fury, descriptorGrouper);
        this.finalFields = (FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (GenericTypeField[])infos.f1;
        this.containerFields = (GenericTypeField[])infos.f2;
    }

    static Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> buildFieldInfos(Fury fury, DescriptorGrouper grouper) {
        Collection<Descriptor> primitives = grouper.getPrimitiveDescriptors();
        Collection<Descriptor> boxed = grouper.getBoxedDescriptors();
        Collection<Descriptor> finals = grouper.getFinalDescriptors();
        FinalTypeField[] finalFields = new FinalTypeField[primitives.size() + boxed.size() + finals.size()];
        int cnt = 0;
        for (Descriptor d : primitives) {
            finalFields[cnt++] = ObjectSerializer.buildFinalTypeField(fury, d);
        }
        for (Descriptor d : boxed) {
            finalFields[cnt++] = ObjectSerializer.buildFinalTypeField(fury, d);
        }
        for (Descriptor d : finals) {
            finalFields[cnt++] = ObjectSerializer.buildFinalTypeField(fury, d);
        }
        boolean[] isFinal = new boolean[finalFields.length];
        for (int i = 0; i < isFinal.length; ++i) {
            ClassInfo classInfo = finalFields[i].classInfo;
            isFinal[i] = classInfo != null && fury.getClassResolver().isFinal(classInfo.getCls());
        }
        cnt = 0;
        GenericTypeField[] otherFields = new GenericTypeField[grouper.getOtherDescriptors().size()];
        for (Descriptor descriptor : grouper.getOtherDescriptors()) {
            GenericTypeField genericTypeField = new GenericTypeField(descriptor.getRawType(), descriptor.getDeclaringClass() + "." + descriptor.getName(), descriptor.getField() != null ? FieldAccessor.createAccessor(descriptor.getField()) : null, fury);
            otherFields[cnt++] = genericTypeField;
        }
        cnt = 0;
        Collection<Descriptor> collections = grouper.getCollectionDescriptors();
        Collection<Descriptor> maps = grouper.getMapDescriptors();
        GenericTypeField[] containerFields = new GenericTypeField[collections.size() + maps.size()];
        for (Descriptor d : collections) {
            containerFields[cnt++] = ObjectSerializer.buildContainerField(fury, d);
        }
        for (Descriptor d : maps) {
            containerFields[cnt++] = ObjectSerializer.buildContainerField(fury, d);
        }
        return Tuple3.of(Tuple2.of(finalFields, isFinal), otherFields, containerFields);
    }

    private static FinalTypeField buildFinalTypeField(Fury fury, Descriptor d) {
        return new FinalTypeField(d.getRawType(), d.getDeclaringClass() + "." + d.getName(), d.getField() != null ? FieldAccessor.createAccessor(d.getField()) : null, fury);
    }

    private static GenericTypeField buildContainerField(Fury fury, Descriptor d) {
        return new GenericTypeField(d.getTypeToken(), d.getDeclaringClass() + "." + d.getName(), d.getField() != null ? FieldAccessor.createAccessor(d.getField()) : null, fury);
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            buffer.writeInt(this.classVersionHash);
        }
        this.writeFinalFields(buffer, value, fury, refResolver, classResolver);
        for (GenericTypeField fieldInfo : this.otherFields) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            if (fieldInfo.trackingRef) {
                fury.writeRef(buffer, fieldValue, fieldInfo.classInfoHolder);
                continue;
            }
            fury.writeNullable(buffer, fieldValue, fieldInfo.classInfoHolder);
        }
        this.writeContainerFields(buffer, value, fury, refResolver, classResolver);
    }

    private void writeFinalFields(MemoryBuffer buffer, T value, Fury fury, RefResolver refResolver, ClassResolver classResolver) {
        FinalTypeField[] finalFields = this.finalFields;
        boolean metaContextShareEnabled = fury.getConfig().shareMetaContext();
        for (int i = 0; i < finalFields.length; ++i) {
            Object fieldValue;
            FinalTypeField fieldInfo = finalFields[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.writePrimitiveFieldValueFailed(fury, buffer, value, fieldAccessor, classId) || !ObjectSerializer.writeBasicObjectFieldValueFailed(fury, buffer, fieldValue = fieldAccessor.getObject(value), classId)) continue;
            Serializer<Object> serializer = fieldInfo.classInfo.getSerializer();
            if (!metaContextShareEnabled || this.isFinal[i]) {
                fury.writeRef(buffer, fieldValue, serializer);
                continue;
            }
            if (serializer.needToWriteRef()) {
                if (refResolver.writeRefOrNull(buffer, fieldValue)) continue;
                classResolver.writeClass(buffer, fieldInfo.classInfo);
                serializer.write(buffer, fieldValue);
                continue;
            }
            fury.writeNullable(buffer, fieldValue, fieldInfo.classInfo);
        }
    }

    private void writeContainerFields(MemoryBuffer buffer, T value, Fury fury, RefResolver refResolver, ClassResolver classResolver) {
        Generics generics = fury.getGenerics();
        for (GenericTypeField fieldInfo : this.containerFields) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            ObjectSerializer.writeContainerFieldValue(fury, refResolver, classResolver, generics, fieldInfo, buffer, fieldValue);
        }
    }

    static void writeContainerFieldValue(Fury fury, RefResolver refResolver, ClassResolver classResolver, Generics generics, GenericTypeField fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        if (fieldInfo.trackingRef) {
            if (!refResolver.writeRefOrNull(buffer, fieldValue)) {
                ClassInfo classInfo = classResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoHolder);
                generics.pushGenericType(fieldInfo.genericType);
                fury.writeNonRef(buffer, fieldValue, classInfo);
                generics.popGenericType();
            }
        } else if (fieldValue == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            generics.pushGenericType(fieldInfo.genericType);
            fury.writeNonRef(buffer, fieldValue, classResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoHolder));
            generics.popGenericType();
        }
    }

    @Override
    public T read(MemoryBuffer buffer) {
        if (this.isRecord) {
            Object[] fields = this.readFields(buffer);
            RecordUtils.remapping(this.recordInfo, fields);
            try {
                Object obj = this.constructor.invokeWithArguments(this.recordInfo.getRecordComponents());
                Arrays.fill(this.recordInfo.getRecordComponents(), null);
                return (T)obj;
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        T obj = ObjectSerializer.newBean(this.constructor, this.type);
        this.refResolver.reference(obj);
        return this.readAndSetFields(buffer, obj);
    }

    public Object[] readFields(MemoryBuffer buffer) {
        Object fieldValue;
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            int hash = buffer.readInt();
            ObjectSerializer.checkClassVersion(fury, hash, this.classVersionHash);
        }
        Object[] fieldValues = new Object[this.finalFields.length + this.otherFields.length + this.containerFields.length];
        int counter = 0;
        FinalTypeField[] finalFields = this.finalFields;
        boolean metaContextShareEnabled = fury.getConfig().shareMetaContext();
        for (int i = 0; i < finalFields.length; ++i) {
            FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = !metaContextShareEnabled || this.isFinal[i];
            short classId = fieldInfo.classId;
            if (classId >= 5 && classId <= 12) {
                fieldValues[counter++] = Serializers.readPrimitiveValue(fury, buffer, classId);
                continue;
            }
            fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
            fieldValues[counter++] = fieldValue;
        }
        for (GenericTypeField fieldInfo : this.otherFields) {
            fieldValue = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            fieldValues[counter++] = fieldValue;
        }
        Generics generics = fury.getGenerics();
        for (GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue2 = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            fieldValues[counter++] = fieldValue2;
        }
        return fieldValues;
    }

    public T readAndSetFields(MemoryBuffer buffer, T obj) {
        Object fieldValue;
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            int hash = buffer.readInt();
            ObjectSerializer.checkClassVersion(fury, hash, this.classVersionHash);
        }
        FinalTypeField[] finalFields = this.finalFields;
        boolean metaContextShareEnabled = fury.getConfig().shareMetaContext();
        for (int i = 0; i < finalFields.length; ++i) {
            FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = !metaContextShareEnabled || this.isFinal[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, obj, fieldAccessor, classId) || !ObjectSerializer.readBasicObjectFieldValueFailed(fury, buffer, obj, fieldAccessor, classId)) continue;
            fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
            fieldAccessor.putObject(obj, fieldValue);
        }
        for (GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue2 = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue2);
        }
        Generics generics = fury.getGenerics();
        for (GenericTypeField fieldInfo : this.containerFields) {
            fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    static Object readFinalObjectFieldValue(Fury fury, RefResolver refResolver, ClassResolver classResolver, FinalTypeField fieldInfo, boolean isFinal, MemoryBuffer buffer) {
        Object fieldValue;
        Serializer serializer = fieldInfo.classInfo.getSerializer();
        if (isFinal) {
            fieldValue = fury.readRef(buffer, serializer);
        } else if (serializer.needToWriteRef()) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                classResolver.readClassInfo(buffer, fieldInfo.classInfo);
                fieldValue = serializer.read(buffer);
                refResolver.setReadObject(nextReadRefId, fieldValue);
            } else {
                fieldValue = refResolver.getReadObject();
            }
        } else {
            byte headFlag = buffer.readByte();
            if (headFlag == -3) {
                fieldValue = null;
            } else {
                classResolver.readClassInfo(buffer, fieldInfo.classInfo);
                fieldValue = serializer.read(buffer);
            }
        }
        return fieldValue;
    }

    static Object readOtherFieldValue(Fury fury, GenericTypeField fieldInfo, MemoryBuffer buffer) {
        byte headFlag;
        Object fieldValue = fieldInfo.trackingRef ? fury.readRef(buffer, fieldInfo.classInfoHolder) : ((headFlag = buffer.readByte()) == -3 ? null : fury.readNonRef(buffer, fieldInfo.classInfoHolder));
        return fieldValue;
    }

    static Object readContainerFieldValue(Fury fury, Generics generics, GenericTypeField fieldInfo, MemoryBuffer buffer) {
        Object fieldValue;
        if (fieldInfo.trackingRef) {
            generics.pushGenericType(fieldInfo.genericType);
            fieldValue = fury.readRef(buffer, fieldInfo.classInfoHolder);
            generics.popGenericType();
        } else {
            byte headFlag = buffer.readByte();
            if (headFlag == -3) {
                fieldValue = null;
            } else {
                generics.pushGenericType(fieldInfo.genericType);
                fieldValue = fury.readNonRef(buffer, fieldInfo.classInfoHolder);
                generics.popGenericType();
            }
        }
        return fieldValue;
    }

    static boolean writePrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        long fieldOffset = fieldAccessor.getFieldOffset();
        if (fieldOffset != -1L) {
            return ObjectSerializer.writePrimitiveFieldValueFailed(fury, buffer, targetObject, fieldOffset, classId);
        }
        switch (classId) {
            case 5: {
                buffer.writeBoolean((Boolean)fieldAccessor.get(targetObject));
                return false;
            }
            case 6: {
                buffer.writeByte((Byte)fieldAccessor.get(targetObject));
                return false;
            }
            case 7: {
                buffer.writeChar(((Character)fieldAccessor.get(targetObject)).charValue());
                return false;
            }
            case 8: {
                buffer.writeShort((Short)fieldAccessor.get(targetObject));
                return false;
            }
            case 9: {
                int fieldValue = (Integer)fieldAccessor.get(targetObject);
                if (fury.compressInt()) {
                    buffer.writeVarInt(fieldValue);
                } else {
                    buffer.writeInt(fieldValue);
                }
                return false;
            }
            case 10: {
                buffer.writeFloat(((Float)fieldAccessor.get(targetObject)).floatValue());
                return false;
            }
            case 11: {
                long fieldValue = (Long)fieldAccessor.get(targetObject);
                fury.writeLong(buffer, fieldValue);
                return false;
            }
            case 12: {
                buffer.writeDouble((Double)fieldAccessor.get(targetObject));
                return false;
            }
        }
        return true;
    }

    static boolean writePrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                buffer.writeBoolean(Platform.getBoolean(targetObject, fieldOffset));
                return false;
            }
            case 6: {
                buffer.writeByte(Platform.getByte(targetObject, fieldOffset));
                return false;
            }
            case 7: {
                buffer.writeChar(Platform.getChar(targetObject, fieldOffset));
                return false;
            }
            case 8: {
                buffer.writeShort(Platform.getShort(targetObject, fieldOffset));
                return false;
            }
            case 9: {
                int fieldValue = Platform.getInt(targetObject, fieldOffset);
                if (fury.compressInt()) {
                    buffer.writeVarInt(fieldValue);
                } else {
                    buffer.writeInt(fieldValue);
                }
                return false;
            }
            case 10: {
                buffer.writeFloat(Platform.getFloat(targetObject, fieldOffset));
                return false;
            }
            case 11: {
                long fieldValue = Platform.getLong(targetObject, fieldOffset);
                fury.writeLong(buffer, fieldValue);
                return false;
            }
            case 12: {
                buffer.writeDouble(Platform.getDouble(targetObject, fieldOffset));
                return false;
            }
        }
        return true;
    }

    static boolean writeBasicObjectFieldValueFailed(Fury fury, MemoryBuffer buffer, Object fieldValue, short classId) {
        if (!fury.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fury.writeJavaStringRef(buffer, (String)fieldValue);
                return false;
            }
            case 14: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeBoolean((Boolean)fieldValue);
                }
                return false;
            }
            case 15: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeByte((Byte)fieldValue);
                }
                return false;
            }
            case 16: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeChar(((Character)fieldValue).charValue());
                }
                return false;
            }
            case 17: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeShort((Short)fieldValue);
                }
                return false;
            }
            case 18: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    if (fury.compressInt()) {
                        buffer.writeVarInt((Integer)fieldValue);
                    } else {
                        buffer.writeInt((Integer)fieldValue);
                    }
                }
                return false;
            }
            case 19: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeFloat(((Float)fieldValue).floatValue());
                }
                return false;
            }
            case 20: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    fury.writeLong(buffer, (Long)fieldValue);
                }
                return false;
            }
            case 21: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeDouble((Double)fieldValue);
                }
                return false;
            }
        }
        return true;
    }

    static boolean readPrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        long fieldOffset = fieldAccessor.getFieldOffset();
        if (fieldOffset != -1L) {
            return ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, targetObject, fieldOffset, classId);
        }
        switch (classId) {
            case 5: {
                fieldAccessor.set(targetObject, buffer.readBoolean());
                return false;
            }
            case 6: {
                fieldAccessor.set(targetObject, buffer.readByte());
                return false;
            }
            case 7: {
                fieldAccessor.set(targetObject, Character.valueOf(buffer.readChar()));
                return false;
            }
            case 8: {
                fieldAccessor.set(targetObject, buffer.readShort());
                return false;
            }
            case 9: {
                if (fury.compressInt()) {
                    fieldAccessor.set(targetObject, buffer.readVarInt());
                } else {
                    fieldAccessor.set(targetObject, buffer.readInt());
                }
                return false;
            }
            case 10: {
                fieldAccessor.set(targetObject, Float.valueOf(buffer.readFloat()));
                return false;
            }
            case 11: {
                fieldAccessor.set(targetObject, fury.readLong(buffer));
                return false;
            }
            case 12: {
                fieldAccessor.set(targetObject, buffer.readDouble());
                return false;
            }
            case 22: {
                fieldAccessor.putObject(targetObject, fury.readJavaStringRef(buffer));
                return false;
            }
        }
        return true;
    }

    private static boolean readPrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                Platform.putBoolean(targetObject, fieldOffset, buffer.readBoolean());
                return false;
            }
            case 6: {
                Platform.putByte(targetObject, fieldOffset, buffer.readByte());
                return false;
            }
            case 7: {
                Platform.putChar(targetObject, fieldOffset, buffer.readChar());
                return false;
            }
            case 8: {
                Platform.putShort(targetObject, fieldOffset, buffer.readShort());
                return false;
            }
            case 9: {
                if (fury.compressInt()) {
                    Platform.putInt(targetObject, fieldOffset, buffer.readVarInt());
                } else {
                    Platform.putInt(targetObject, fieldOffset, buffer.readInt());
                }
                return false;
            }
            case 10: {
                Platform.putFloat(targetObject, fieldOffset, buffer.readFloat());
                return false;
            }
            case 11: {
                Platform.putLong(targetObject, fieldOffset, fury.readLong(buffer));
                return false;
            }
            case 12: {
                Platform.putDouble(targetObject, fieldOffset, buffer.readDouble());
                return false;
            }
            case 22: {
                Platform.putObject(targetObject, fieldOffset, fury.readJavaStringRef(buffer));
                return false;
            }
        }
        return true;
    }

    static boolean readBasicObjectFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        if (!fury.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fieldAccessor.putObject(targetObject, fury.readJavaStringRef(buffer));
                return false;
            }
            case 14: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readBoolean());
                }
                return false;
            }
            case 15: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readByte());
                }
                return false;
            }
            case 16: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Character.valueOf(buffer.readChar()));
                }
                return false;
            }
            case 17: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readShort());
                }
                return false;
            }
            case 18: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else if (fury.compressInt()) {
                    fieldAccessor.putObject(targetObject, buffer.readVarInt());
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readInt());
                }
                return false;
            }
            case 19: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Float.valueOf(buffer.readFloat()));
                }
                return false;
            }
            case 20: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, fury.readLong(buffer));
                }
                return false;
            }
            case 21: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readDouble());
                }
                return false;
            }
        }
        return true;
    }

    static <T> T newBean(MethodHandle constructor, Class<T> type) {
        if (constructor != null) {
            try {
                return (T)constructor.invoke();
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        return Platform.newInstance(type);
    }

    private static short getRegisteredClassId(Fury fury, Class<?> cls) {
        Short classId = fury.getClassResolver().getRegisteredClassId(cls);
        return classId == null ? (short)0 : classId;
    }

    public static int computeVersionHash(Collection<Descriptor> descriptors) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Descriptor d : descriptors) {
            Integer integer = Objects.hash(d.getName(), d.getRawType().getName(), d.getDeclaringClass());
            list.add(integer);
        }
        return list.hashCode();
    }

    public static void checkClassVersion(Fury fury, int readHash, int classVersionHash) {
        if (readHash != classVersionHash) {
            throw new FuryException(String.format("Read class %s version %s is not consistent with %s", fury.getClassResolver().getCurrentReadClass(), readHash, classVersionHash));
        }
    }

    static final class GenericTypeField
    extends InternalFieldInfo {
        private final GenericType genericType;
        final ClassInfoHolder classInfoHolder;
        final boolean trackingRef;

        private GenericTypeField(Class<?> cls, String qualifiedFieldName, FieldAccessor accessor, Fury fury) {
            super(ObjectSerializer.getRegisteredClassId(fury, cls), qualifiedFieldName, accessor);
            this.genericType = fury.getClassResolver().buildGenericType(cls);
            this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
            this.trackingRef = fury.getClassResolver().needToWriteRef(cls);
        }

        private GenericTypeField(TypeToken<?> typeToken, String qualifiedFieldName, FieldAccessor accessor, Fury fury) {
            super(ObjectSerializer.getRegisteredClassId(fury, TypeUtils.getRawType(typeToken)), qualifiedFieldName, accessor);
            this.genericType = fury.getClassResolver().buildGenericType(typeToken);
            this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
            this.trackingRef = fury.getClassResolver().needToWriteRef(TypeUtils.getRawType(typeToken));
        }

        @Override
        public String toString() {
            return "GenericTypeField{genericType=" + this.genericType + ", classId=" + this.classId + ", qualifiedFieldName=" + this.qualifiedFieldName + ", field=" + (this.fieldAccessor != null ? this.fieldAccessor.getField() : null) + '}';
        }
    }

    static final class FinalTypeField
    extends InternalFieldInfo {
        final ClassInfo classInfo;

        private FinalTypeField(Class<?> type, String fieldName, FieldAccessor accessor, Fury fury) {
            super(ObjectSerializer.getRegisteredClassId(fury, type), fieldName, accessor);
            this.classInfo = type == FinalObjectTypeStub.class ? null : fury.getClassResolver().getClassInfo(type);
        }
    }

    static class InternalFieldInfo {
        protected final short classId;
        protected final String qualifiedFieldName;
        protected final FieldAccessor fieldAccessor;

        private InternalFieldInfo(short classId, String qualifiedFieldName, FieldAccessor fieldAccessor) {
            this.classId = classId;
            this.qualifiedFieldName = qualifiedFieldName;
            this.fieldAccessor = fieldAccessor;
        }

        public String toString() {
            return "InternalFieldInfo{classId=" + this.classId + ", fieldName=" + this.qualifiedFieldName + ", field=" + (this.fieldAccessor != null ? this.fieldAccessor.getField() : null) + '}';
        }
    }
}

