/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CollectionContainer;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.JDKImmutableMapContainer;
import io.fury.serializer.MapSerializers;
import io.fury.util.Platform;
import io.fury.util.unsafe._JDKAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImmutableCollectionSerializers {
    private static Class<?> List12;
    private static Class<?> ListN;
    private static Class<?> SubList;
    private static Class<?> Set12;
    private static Class<?> SetN;
    private static Class<?> Map1;
    private static Class<?> MapN;
    private static MethodHandle listFactory;
    private static MethodHandle setFactory;
    private static MethodHandle map1Factory;
    private static MethodHandle mapNFactory;

    public static void registerSerializers(Fury fury) {
        fury.registerSerializer(List12, new ImmutableListSerializer(fury, (Class)List12));
        fury.registerSerializer(ListN, new ImmutableListSerializer(fury, (Class)ListN));
        fury.registerSerializer(SubList, new ImmutableListSerializer(fury, (Class)SubList));
        fury.registerSerializer(Set12, new ImmutableSetSerializer(fury, (Class)Set12));
        fury.registerSerializer(SetN, new ImmutableSetSerializer(fury, (Class)SetN));
        fury.registerSerializer(Map1, new ImmutableMapSerializer(fury, (Class)Map1));
        fury.registerSerializer(MapN, new ImmutableMapSerializer(fury, (Class)MapN));
    }

    static {
        if (Platform.JAVA_VERSION > 8) {
            try {
                List12 = Class.forName("java.util.ImmutableCollections$List12");
                ListN = Class.forName("java.util.ImmutableCollections$ListN");
                SubList = Class.forName("java.util.ImmutableCollections$SubList");
                Set12 = Class.forName("java.util.ImmutableCollections$Set12");
                SetN = Class.forName("java.util.ImmutableCollections$SetN");
                Map1 = Class.forName("java.util.ImmutableCollections$Map1");
                MapN = Class.forName("java.util.ImmutableCollections$MapN");
                listFactory = _JDKAccess._trustedLookup(List.class).findStatic(List.class, "of", MethodType.methodType(List.class, Object[].class));
                setFactory = _JDKAccess._trustedLookup(Set.class).findStatic(Set.class, "of", MethodType.methodType(Set.class, Object[].class));
                map1Factory = _JDKAccess._trustedLookup(Map1).findConstructor(Map1, MethodType.methodType(Void.TYPE, Object.class, Object.class));
                mapNFactory = _JDKAccess._trustedLookup(MapN).findConstructor(MapN, MethodType.methodType(Void.TYPE, Object[].class));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
                Platform.throwException(e);
            }
        } else {
            class List12Stub {
                List12Stub() {
                }
            }
            List12 = List12Stub.class;
            class ListNStub {
                ListNStub() {
                }
            }
            ListN = ListNStub.class;
            class SubListStub {
                SubListStub() {
                }
            }
            SubList = SubListStub.class;
            class Set12Stub {
                Set12Stub() {
                }
            }
            Set12 = Set12Stub.class;
            class SetNStub {
                SetNStub() {
                }
            }
            SetN = SetNStub.class;
            class Map1Stub {
                Map1Stub() {
                }
            }
            Map1 = Map1Stub.class;
            class MapNStub {
                MapNStub() {
                }
            }
            MapN = MapNStub.class;
        }
    }

    public static class ImmutableMapSerializer
    extends MapSerializers.MapSerializer {
        public ImmutableMapSerializer(Fury fury, Class cls) {
            super(fury, cls, true);
        }

        @Override
        public Map newMap(MemoryBuffer buffer, int numElements) {
            if (Platform.JAVA_VERSION > 8) {
                return new JDKImmutableMapContainer(numElements);
            }
            return new HashMap(numElements);
        }

        public Map onMapRead(Map map) {
            if (Platform.JAVA_VERSION > 8) {
                JDKImmutableMapContainer container = (JDKImmutableMapContainer)map;
                try {
                    if (container.size() == 1) {
                        map = map1Factory.invoke(container.array[0], container.array[1]);
                    }
                    map = mapNFactory.invoke(container.array);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                map = Collections.unmodifiableMap(map);
            }
            this.fury.getRefResolver().reference(map);
            return map;
        }
    }

    public static class ImmutableSetSerializer
    extends CollectionSerializers.CollectionSerializer {
        public ImmutableSetSerializer(Fury fury, Class cls) {
            super(fury, cls, true);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer, int numElements) {
            if (Platform.JAVA_VERSION > 8) {
                return new CollectionContainer(numElements);
            }
            return new HashSet(numElements);
        }

        public Collection onCollectionRead(Collection collection) {
            if (Platform.JAVA_VERSION > 8) {
                CollectionContainer container = (CollectionContainer)collection;
                try {
                    collection = setFactory.invoke(container.elements);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                collection = Collections.unmodifiableSet((HashSet)collection);
            }
            this.fury.getRefResolver().reference(collection);
            return collection;
        }
    }

    public static class ImmutableListSerializer
    extends CollectionSerializers.CollectionSerializer {
        public ImmutableListSerializer(Fury fury, Class cls) {
            super(fury, cls, true);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer, int numElements) {
            if (Platform.JAVA_VERSION > 8) {
                return new CollectionContainer(numElements);
            }
            return new ArrayList(numElements);
        }

        public Collection onCollectionRead(Collection collection) {
            if (Platform.JAVA_VERSION > 8) {
                CollectionContainer container = (CollectionContainer)collection;
                try {
                    collection = listFactory.invoke(container.elements);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                collection = Collections.unmodifiableList((List)collection);
            }
            this.fury.getRefResolver().reference(collection);
            return collection;
        }
    }
}

