/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CollectionContainer;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.MapContainer;
import io.fury.serializer.MapSerializers;
import io.fury.serializer.SortedCollectionContainer;
import io.fury.serializer.SortedMapContainer;
import io.fury.type.Type;
import io.fury.util.Platform;
import io.fury.util.unsafe._JDKAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class GuavaSerializers {
    private static final String pkg = "com.google.common.collect";
    private static Function regularImmutableListInvokeCache;
    private static final ClassValue<Function> builderCtrCache;

    private static synchronized Function regularImmutableListInvoke() {
        if (regularImmutableListInvokeCache == null) {
            Class<?> cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableList", ImmutableList.of((Object)1, (Object)2).getClass());
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(cls);
            MethodHandle ctr = null;
            try {
                ctr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Object[].class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                Platform.throwException(e);
            }
            regularImmutableListInvokeCache = _JDKAccess.makeJDKFunction(lookup, ctr);
        }
        return regularImmutableListInvokeCache;
    }

    public static void registerDefaultSerializers(Fury fury) {
        Class<?> cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableBiMap", ImmutableBiMap.of().getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.SingletonImmutableBiMap", ImmutableBiMap.of((Object)1, (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableMap", ImmutableMap.of().getClass());
        fury.registerSerializer(cls, new ImmutableMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableList", ImmutableList.of().getClass());
        fury.registerSerializer(cls, new RegularImmutableListSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.SingletonImmutableList", ImmutableList.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableListSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableSet", ImmutableSet.of().getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.SingletonImmutableSet", ImmutableSet.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableSortedSet", ImmutableSortedSet.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)).getClass());
        fury.registerSerializer(cls, new ImmutableSortedSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.ImmutableSortedMap", ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableSortedMapSerializer(fury, cls));
    }

    static Class<?> loadClass(String className, Class<?> cache) {
        if (cache.getName().equals(className)) {
            return cache;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Function access$000() {
        return GuavaSerializers.regularImmutableListInvoke();
    }

    static /* synthetic */ ClassValue access$100() {
        return builderCtrCache;
    }

    static {
        builderCtrCache = new ClassValue<Function>(){

            @Override
            protected Function computeValue(Class<?> builderClass) {
                MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(builderClass);
                MethodHandle ctr = null;
                try {
                    ctr = lookup.findConstructor(builderClass, MethodType.methodType(Void.TYPE, Integer.TYPE));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    Platform.throwException(e);
                }
                return _JDKAccess.makeJDKFunction(lookup, ctr);
            }
        };
    }

    public static final class ImmutableSortedMapSerializer<T extends ImmutableSortedMap>
    extends MapSerializers.MapSerializer<T> {
        public ImmutableSortedMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public void writeHeader(MemoryBuffer buffer, T value) {
            this.fury.writeRef(buffer, value.comparator());
        }

        @Override
        public Map newMap(MemoryBuffer buffer, int numElements) {
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            return new SortedMapContainer(comparator, numElements);
        }

        @Override
        public T onMapRead(Map map) {
            SortedMapContainer mapContainer = (SortedMapContainer)map;
            ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(mapContainer.comparator);
            int size = mapContainer.size;
            Object[] keyArray = mapContainer.keyArray;
            Object[] valueArray = mapContainer.valueArray;
            for (int i = 0; i < size; ++i) {
                builder.put(keyArray[i], valueArray[i]);
            }
            ImmutableSortedMap t = (ImmutableSortedMap)builder.build();
            this.fury.getRefResolver().reference(t);
            return (T)t;
        }
    }

    public static final class ImmutableBiMapSerializer<T extends ImmutableBiMap>
    extends GuavaMapSerializer<T> {
        private final Function<Integer, ImmutableBiMap.Builder> builderCtr = (Function)GuavaSerializers.access$100().get(ImmutableBiMap.Builder.class);

        public ImmutableBiMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected ImmutableMap.Builder makeBuilder(int size) {
            return (ImmutableMap.Builder)this.builderCtr.apply(size);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableBiMap.copyOf((Map)map);
        }
    }

    public static final class ImmutableMapSerializer<T extends ImmutableMap>
    extends GuavaMapSerializer<T> {
        private final Function<Integer, ImmutableMap.Builder> builderCtr = (Function)GuavaSerializers.access$100().get(ImmutableMap.Builder.class);

        public ImmutableMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected ImmutableMap.Builder makeBuilder(int size) {
            return this.builderCtr.apply(size);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableMap.copyOf((Map)map);
        }
    }

    static abstract class GuavaMapSerializer<T extends Map>
    extends MapSerializers.MapSerializer<T> {
        public GuavaMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true);
            fury.getClassResolver().setSerializer(cls, this);
        }

        protected abstract ImmutableMap.Builder makeBuilder(int var1);

        @Override
        public Map newMap(MemoryBuffer buffer, int numElements) {
            return new MapContainer(numElements);
        }

        @Override
        public T onMapRead(Map map) {
            MapContainer container = (MapContainer)map;
            int size = container.size;
            ImmutableMap.Builder builder = this.makeBuilder(size);
            Object[] keyArray = container.keyArray;
            Object[] valueArray = container.valueArray;
            for (int i = 0; i < size; ++i) {
                builder.put(keyArray[i], valueArray[i]);
            }
            ImmutableMap t = builder.build();
            this.fury.getRefResolver().reference(t);
            return (T)t;
        }

        @Override
        public short getXtypeId() {
            return -Type.MAP.getId();
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            HashMap map = new HashMap();
            GuavaMapSerializer.xreadElements(this.fury, buffer, map, size);
            T immutableMap = this.xnewInstance(map);
            this.fury.getRefResolver().reference(immutableMap);
            return immutableMap;
        }

        protected abstract T xnewInstance(Map var1);
    }

    public static final class ImmutableSortedSetSerializer<T extends ImmutableSortedSet>
    extends CollectionSerializers.CollectionSerializer<T> {
        public ImmutableSortedSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public void writeHeader(MemoryBuffer buffer, T value) {
            this.fury.writeRef(buffer, value.comparator());
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer, int numElements) {
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            return new SortedCollectionContainer(comparator, numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            SortedCollectionContainer data = (SortedCollectionContainer)collection;
            Object[] elements = data.elements;
            ImmutableSortedSet t = new ImmutableSortedSet.Builder(data.comparator).add(elements).build();
            this.fury.getRefResolver().reference(t);
            return (T)t;
        }
    }

    public static final class ImmutableSetSerializer<T extends ImmutableSet>
    extends GuavaCollectionSerializer<T> {
        public ImmutableSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer, int numElements) {
            return new CollectionContainer(numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            Object[] elements = ((CollectionContainer)collection).elements;
            ImmutableSet t = ImmutableSet.copyOf((Object[])elements);
            this.fury.getRefResolver().reference(t);
            return (T)t;
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        protected T xnewInstance(Collection collection) {
            return (T)ImmutableSet.copyOf((Collection)collection);
        }
    }

    public static final class RegularImmutableListSerializer<T extends ImmutableList>
    extends GuavaCollectionSerializer<T> {
        private final Function<Object[], ImmutableList> function = GuavaSerializers.access$000();

        public RegularImmutableListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer, int numElements) {
            return new CollectionContainer(numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            Object[] elements = ((CollectionContainer)collection).elements;
            ImmutableList t = this.function.apply(elements);
            this.fury.getRefResolver().reference(t);
            return (T)t;
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        protected T xnewInstance(Collection collection) {
            return (T)ImmutableList.copyOf((Collection)collection);
        }
    }

    public static final class ImmutableListSerializer<T extends ImmutableList>
    extends GuavaCollectionSerializer<T> {
        public ImmutableListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer, int numElements) {
            return new CollectionContainer(numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            Object[] elements = ((CollectionContainer)collection).elements;
            ImmutableList list = ImmutableList.copyOf((Object[])elements);
            this.fury.getRefResolver().reference(list);
            return (T)list;
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public T xnewInstance(Collection collection) {
            return (T)ImmutableList.copyOf((Collection)collection);
        }
    }

    static abstract class GuavaCollectionSerializer<T extends Collection>
    extends CollectionSerializers.CollectionSerializer<T> {
        public GuavaCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            ArrayList list = new ArrayList();
            this.xreadElements(this.fury, buffer, list, size);
            T immutableList = this.xnewInstance(list);
            this.fury.getRefResolver().reference(immutableList);
            return immutableList;
        }

        protected abstract T xnewInstance(Collection var1);
    }
}

