/*
 * Decompiled with CFR 0.152.
 */
package io.fury.resolver;

import com.google.common.base.Preconditions;
import io.fury.config.Language;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.EnumStringBytes;
import io.fury.resolver.EnumStringResolver;
import io.fury.serializer.Serializer;
import io.fury.util.ReflectionUtils;
import io.fury.util.function.Functions;

public class ClassInfo {
    final Class<?> cls;
    final EnumStringBytes fullClassNameBytes;
    final EnumStringBytes packageNameBytes;
    final EnumStringBytes classNameBytes;
    final boolean isDynamicGeneratedClass;
    final EnumStringBytes typeTagBytes;
    Serializer<?> serializer;
    short classId;

    ClassInfo(Class<?> cls, EnumStringBytes fullClassNameBytes, EnumStringBytes packageNameBytes, EnumStringBytes classNameBytes, boolean isDynamicGeneratedClass, EnumStringBytes typeTagBytes, Serializer<?> serializer, short classId) {
        this.cls = cls;
        this.fullClassNameBytes = fullClassNameBytes;
        this.packageNameBytes = packageNameBytes;
        this.classNameBytes = classNameBytes;
        this.isDynamicGeneratedClass = isDynamicGeneratedClass;
        this.typeTagBytes = typeTagBytes;
        this.serializer = serializer;
        this.classId = classId;
        if (cls != null && classId == 0) {
            Preconditions.checkArgument((classNameBytes != null ? 1 : 0) != 0);
        }
    }

    ClassInfo(ClassResolver classResolver, Class<?> cls, String tag, Serializer<?> serializer, short classId) {
        this.cls = cls;
        this.serializer = serializer;
        EnumStringResolver enumStringResolver = classResolver.getEnumStringResolver();
        this.fullClassNameBytes = cls != null && classResolver.getFury().getLanguage() != Language.JAVA ? enumStringResolver.getOrCreateEnumStringBytes(cls.getName()) : null;
        if (cls != null && (classId == 0 || classId == 3)) {
            String packageName = ReflectionUtils.getPackage(cls);
            this.packageNameBytes = enumStringResolver.getOrCreateEnumStringBytes(packageName);
            this.classNameBytes = enumStringResolver.getOrCreateEnumStringBytes(ReflectionUtils.getClassNameWithoutPackage(cls));
        } else {
            this.packageNameBytes = null;
            this.classNameBytes = null;
        }
        this.typeTagBytes = tag != null ? enumStringResolver.getOrCreateEnumStringBytes(tag) : null;
        this.classId = classId;
        if (cls != null) {
            boolean isLambda = Functions.isLambda(cls);
            boolean isProxy = ReflectionUtils.isJdkProxy(cls);
            boolean bl = this.isDynamicGeneratedClass = isLambda || isProxy;
            if (isLambda) {
                this.classId = 1;
            }
            if (isProxy) {
                this.classId = (short)2;
            }
        } else {
            this.isDynamicGeneratedClass = false;
        }
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public short getClassId() {
        return this.classId;
    }

    public EnumStringBytes getPackageNameBytes() {
        return this.packageNameBytes;
    }

    public EnumStringBytes getClassNameBytes() {
        return this.classNameBytes;
    }

    public <T> Serializer<T> getSerializer() {
        return this.serializer;
    }

    public String toString() {
        return "ClassInfo{cls=" + this.cls + ", fullClassNameBytes=" + this.fullClassNameBytes + ", isDynamicGeneratedClass=" + this.isDynamicGeneratedClass + ", serializer=" + this.serializer + ", classId=" + this.classId + '}';
    }
}

