/*
 * Decompiled with CFR 0.152.
 */
package io.fury.io;

import com.google.common.base.Preconditions;
import io.fury.memory.MemoryBuffer;
import java.io.IOException;
import java.io.InputStream;

public class FuryInputStream
extends InputStream {
    private final MemoryBuffer buffer;

    public FuryInputStream(MemoryBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() {
        if (this.buffer.remaining() == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int size = Math.min(this.buffer.remaining(), length);
        if (size == 0) {
            return -1;
        }
        this.buffer.readBytes(bytes, offset, size);
        return size;
    }

    @Override
    public long skip(long n) throws IOException {
        Preconditions.checkArgument((n < Integer.MAX_VALUE ? 1 : 0) != 0);
        int nbytes = (int)Math.min(n, (long)this.buffer.remaining());
        this.buffer.increaseReaderIndex(nbytes);
        return nbytes;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }
}

