/*
 * Decompiled with CFR 0.152.
 */
package io.fury.codegen;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.codegen.ClosureVisitable;
import io.fury.codegen.Expression;
import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class ExpressionVisitor {
    public void traverseExpression(Expression expr, Function<ExprSite, Boolean> func) {
        Preconditions.checkNotNull((Object)expr);
        if (!func.apply(new ExprSite(expr)).booleanValue()) {
            return;
        }
        this.traverseChildren(expr, func);
    }

    public void traverseChildren(Expression expr, Function<ExprSite, Boolean> func) {
        if (expr instanceof Expression.ListExpression) {
            this.traverseList(expr, ((Expression.ListExpression)expr).expressions(), func);
        } else {
            for (Field field : ReflectionUtils.getFields(expr.getClass(), true)) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                try {
                    TypeToken fieldType;
                    if (Expression.class.isAssignableFrom(field.getType())) {
                        this.traverseField(expr, field, func);
                        continue;
                    }
                    if (Expression[].class == field.getType()) {
                        Expression[] expressions = (Expression[])Platform.getObject(expr, ReflectionUtils.getFieldOffset(field));
                        this.traverseArray(expr, expressions, func);
                        continue;
                    }
                    if (field.getAnnotation(ClosureVisitable.class) != null) {
                        this.traverseClosure(expr, field, func);
                        continue;
                    }
                    if (!Iterable.class.isAssignableFrom(field.getType()) || !TypeUtils.getElementType(fieldType = TypeToken.of((Type)field.getGenericType())).equals((Object)TypeToken.of(Expression.class))) continue;
                    List expressions = (List)Platform.getObject(expr, ReflectionUtils.getFieldOffset(field));
                    this.traverseList(expr, expressions, func);
                }
                catch (Exception e) {
                    Platform.throwException(e);
                }
            }
        }
    }

    private void traverseClosure(Expression expr, Field field, Function<ExprSite, Boolean> func) throws IllegalAccessException, InvocationTargetException {
        Object closure = Platform.getObject(expr, ReflectionUtils.getFieldOffset(field));
        Preconditions.checkArgument((boolean)(closure instanceof Serializable));
        Method writeReplace = ReflectionUtils.findMethods(closure.getClass(), "writeReplace").get(0);
        writeReplace.setAccessible(true);
        SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke(closure, new Object[0]);
        for (int i = 0; i < serializedLambda.getCapturedArgCount(); ++i) {
            Object capturedArg = serializedLambda.getCapturedArg(i);
            if (capturedArg instanceof Expression || capturedArg == Expression[].class) {
                throw new IllegalStateException(String.format("Capture expression [%s: %s] in lambda %s are not allowed. \nSerializedLambda: %s", capturedArg.getClass(), capturedArg, closure, serializedLambda));
            }
            if (!(capturedArg instanceof ExprHolder)) continue;
            this.traverseMap(expr, ((ExprHolder)capturedArg).expressionsMap, func);
        }
    }

    private void traverseMap(Expression expr, Map<Object, Expression> expressionsMap, Function<ExprSite, Boolean> func) {
        new HashMap<Object, Expression>(expressionsMap).forEach((k, childExpr) -> {
            if (((Boolean)func.apply(new ExprSite(expr, (Expression)childExpr, newChildExpr -> expressionsMap.put(k, (Expression)newChildExpr)))).booleanValue()) {
                this.traverseChildren((Expression)childExpr, func);
            }
        });
    }

    private void traverseList(Expression expr, List<Expression> expressions, Function<ExprSite, Boolean> func) {
        for (int i = 0; i < expressions.size(); ++i) {
            int index;
            Expression childExpr = expressions.get(i);
            if (!func.apply(new ExprSite(expr, childExpr, arg_0 -> ExpressionVisitor.lambda$traverseList$2(expressions, index = i, arg_0))).booleanValue()) continue;
            this.traverseChildren(childExpr, func);
        }
    }

    private void traverseField(Expression expr, Field field, Function<ExprSite, Boolean> func) {
        long fieldOffset = ReflectionUtils.getFieldOffset(field);
        Expression childExpr = (Expression)Platform.getObject(expr, fieldOffset);
        if (childExpr == null) {
            return;
        }
        Boolean continueVisit = func.apply(new ExprSite(expr, childExpr, newChildExpr -> Platform.putObject(expr, fieldOffset, newChildExpr)));
        if (continueVisit.booleanValue()) {
            this.traverseChildren(childExpr, func);
        }
    }

    private void traverseArray(Expression expr, Expression[] expressions, Function<ExprSite, Boolean> func) {
        for (int i = 0; i < expressions.length; ++i) {
            Expression childExpr = expressions[i];
            int index = i;
            Boolean continueVisit = func.apply(new ExprSite(expr, childExpr, newChildExpr -> {
                expressions[index] = newChildExpr;
            }));
            if (!continueVisit.booleanValue()) continue;
            this.traverseChildren(childExpr, func);
        }
    }

    private static /* synthetic */ void lambda$traverseList$2(List expressions, int index, Expression newChildExpr) {
        expressions.set(index, newChildExpr);
    }

    public static class ExprSite {
        public final Expression current;
        public final Expression parent;
        private final Consumer<Expression> updateFunc;

        ExprSite(Expression current) {
            this(null, current, null);
        }

        ExprSite(Expression parent, Expression current, Consumer<Expression> updateFunc) {
            this.parent = parent;
            this.current = current;
            this.updateFunc = updateFunc;
        }

        public void update(Expression newExpr) {
            ((Consumer)Preconditions.checkNotNull(this.updateFunc)).accept(newExpr);
        }

        public String toString() {
            return "ExprSite{current=" + this.current + ", parent=" + this.parent + ", updateFunc=" + this.updateFunc + '}';
        }
    }

    public static final class ExprHolder {
        private final Map<Object, Expression> expressionsMap;

        private ExprHolder(Object ... kv) {
            Preconditions.checkArgument((kv.length % 2 == 0 ? 1 : 0) != 0);
            this.expressionsMap = new HashMap<Object, Expression>();
            for (int i = 0; i < kv.length; i += 2) {
                this.expressionsMap.put(kv[i], (Expression)kv[i + 1]);
            }
        }

        public static ExprHolder of(String k1, Expression v1) {
            return new ExprHolder(k1, v1);
        }

        public static ExprHolder of(String k1, Expression v1, String k2, Expression v2) {
            return new ExprHolder(k1, v1, k2, v2);
        }

        public static ExprHolder of(String k1, Expression v1, String k2, Expression v2, String k3, Expression v3) {
            return new ExprHolder(k1, v1, k2, v2, k3, v3);
        }

        public Expression get(String key) {
            return this.expressionsMap.get(key);
        }

        public Map<Object, Expression> getExpressionsMap() {
            return this.expressionsMap;
        }
    }
}

