/*
 * Decompiled with CFR 0.152.
 */
package io.fury.type;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.fury.annotation.Ignore;
import io.fury.annotation.Internal;
import io.fury.collection.Tuple2;
import io.fury.type.TypeUtils;
import io.fury.util.StringUtils;
import io.fury.util.Utils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;

public class Descriptor {
    private static Cache<Class<?>, Tuple2<SortedMap<Field, Descriptor>, SortedMap<Field, Descriptor>>> descCache = CacheBuilder.newBuilder().weakKeys().softValues().concurrencyLevel(64).build();
    private static final Map<Class<?>, AtomicBoolean> flags = Collections.synchronizedMap(new WeakHashMap());
    private TypeToken<?> typeToken;
    private Class<?> type;
    private final String name;
    private final int modifier;
    private final String declaringClass;
    private final Field field;
    private final Method readMethod;
    private final Method writeMethod;
    private static final Comparator<Field> fieldComparator = (f1, f2) -> {
        int compare = f1.getName().compareTo(f2.getName());
        if (compare == 0) {
            return f1.getDeclaringClass().getName().compareTo(f2.getDeclaringClass().getName());
        }
        return compare;
    };

    @Internal
    public static void clearDescriptorCache() {
        descCache.cleanUp();
        descCache = CacheBuilder.newBuilder().weakKeys().softValues().concurrencyLevel(64).build();
    }

    public Descriptor(Field field, TypeToken<?> typeToken, Method readMethod, Method writeMethod) {
        this.field = field;
        this.name = field.getName();
        this.modifier = field.getModifiers();
        this.declaringClass = field.getDeclaringClass().getName();
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.typeToken = typeToken;
    }

    public Descriptor(Field field) {
        this.field = field;
        this.name = field.getName();
        this.modifier = field.getModifiers();
        this.declaringClass = field.getDeclaringClass().getName();
        this.readMethod = null;
        this.writeMethod = null;
        this.typeToken = null;
    }

    public Descriptor(TypeToken<?> typeToken, String name, int modifier, String declaringClass) {
        this.field = null;
        this.name = name;
        this.modifier = modifier;
        this.declaringClass = declaringClass;
        this.typeToken = typeToken;
        this.readMethod = null;
        this.writeMethod = null;
    }

    public Descriptor(TypeToken<?> typeToken, String name, int modifier, String declaringClass, Field field, Method readMethod, Method writeMethod) {
        this.typeToken = typeToken;
        this.name = name;
        this.modifier = modifier;
        this.declaringClass = declaringClass;
        this.field = field;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    public Descriptor copy(TypeToken<?> typeToken, Method readMethod, Method writeMethod) {
        return new Descriptor(typeToken, this.name, this.modifier, this.declaringClass, this.field, readMethod, writeMethod);
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifier;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Class<?> getRawType() {
        Class<?> type = this.type;
        if (type == null) {
            if (this.field != null) {
                this.type = this.field.getType();
                return this.type;
            }
            this.type = TypeUtils.getRawType(this.getTypeToken());
            return this.type;
        }
        return Objects.requireNonNull(type);
    }

    public TypeToken<?> getTypeToken() {
        TypeToken typeToken = this.typeToken;
        if (typeToken == null && this.field != null) {
            this.typeToken = typeToken = TypeToken.of((Type)this.field.getGenericType());
        }
        return typeToken;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Descriptor{");
        sb.append("name=").append(this.name);
        sb.append(", field=").append(this.field);
        sb.append(", readMethod=").append(this.readMethod);
        sb.append(", writeMethod=").append(this.writeMethod);
        sb.append(", typeToken=").append(this.typeToken);
        sb.append('}');
        return sb.toString();
    }

    public static List<Descriptor> getDescriptors(Class<?> clz) {
        SortedMap<Field, Descriptor> allDescriptorsMap = Descriptor.getAllDescriptorsMap(clz);
        Map<String, List<Field>> duplicateNameFields = Descriptor.getDuplicateNameFields(allDescriptorsMap);
        Utils.checkArgument(duplicateNameFields.size() == 0, "%s has duplicate fields %s", clz, duplicateNameFields);
        return new ArrayList<Descriptor>(allDescriptorsMap.values());
    }

    public static SortedMap<String, Descriptor> getDescriptorsMap(Class<?> clz) {
        SortedMap<Field, Descriptor> allDescriptorsMap = Descriptor.getAllDescriptorsMap(clz);
        Map<String, List<Field>> duplicateNameFields = Descriptor.getDuplicateNameFields(allDescriptorsMap);
        Preconditions.checkArgument((duplicateNameFields.size() == 0 ? 1 : 0) != 0, (String)"%s has duplicate fields %s", clz, duplicateNameFields);
        TreeMap<String, Descriptor> map = new TreeMap<String, Descriptor>();
        allDescriptorsMap.forEach((k, v) -> map.put(k.getName(), (Descriptor)v));
        return map;
    }

    public static Map<String, List<Field>> getDuplicateNameFields(SortedMap<Field, Descriptor> allDescriptorsMap) {
        HashMap<String, List<Field>> duplicateNameFields = new HashMap();
        for (Field field : allDescriptorsMap.keySet()) {
            duplicateNameFields.compute(field.getName(), (fieldName, fields) -> {
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                fields.add(field);
                return fields;
            });
        }
        duplicateNameFields = Maps.filterValues(duplicateNameFields, fields -> Objects.requireNonNull(fields).size() > 1);
        return duplicateNameFields;
    }

    public static Map<String, List<Field>> getSortedDuplicatedFields(SortedMap<Field, Descriptor> allFields) {
        Map<String, List<Field>> duplicated = Descriptor.getDuplicateNameFields(allFields);
        HashMap<String, List<Field>> map = new HashMap<String, List<Field>>();
        for (Map.Entry<String, List<Field>> e : duplicated.entrySet()) {
            e.getValue().sort((f1, f2) -> {
                if (f1.getDeclaringClass() == f2.getDeclaringClass()) {
                    return 0;
                }
                return f1.getDeclaringClass().isAssignableFrom(f2.getDeclaringClass()) ? -1 : 1;
            });
            if (map.put(e.getKey(), e.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return map;
    }

    public static Set<Field> getFields(Class<?> clz) {
        return Descriptor.getAllDescriptorsMap(clz).keySet();
    }

    public static SortedMap<Field, Descriptor> getAllDescriptorsMap(Class<?> clz) {
        return Descriptor.getAllDescriptorsMap(clz, true);
    }

    public static SortedMap<Field, Descriptor> getAllDescriptorsMap(Class<?> clz, boolean searchParent) {
        try {
            Tuple2 tuple2 = (Tuple2)descCache.get(clz, () -> Descriptor.createAllDescriptorsMap(clz));
            if (searchParent) {
                return (SortedMap)tuple2.f0;
            }
            return (SortedMap)tuple2.f1;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Tuple2<SortedMap<Field, Descriptor>, SortedMap<Field, Descriptor>> createAllDescriptorsMap(Class<?> clz) {
        TreeMap<Field, Descriptor> descriptorMap = new TreeMap<Field, Descriptor>(fieldComparator);
        TreeMap currentDescriptorMap = new TreeMap(fieldComparator);
        Class<?> clazz = clz;
        ForkJoinPool compilationService = ForkJoinPool.commonPool();
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Descriptor.warmField(clz, field, compilationService);
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isAnnotationPresent(Ignore.class)) continue;
                descriptorMap.put(field, new Descriptor(field));
            }
            if (clazz != clz) continue;
            currentDescriptorMap = new TreeMap(descriptorMap);
        } while ((clazz = clazz.getSuperclass()) != null);
        return Tuple2.of(descriptorMap, currentDescriptorMap);
    }

    static void warmField(Class<?> context, Field field, ExecutorService compilationService) {
        Class<?> componentType;
        Class<?> fieldRawType = field.getType();
        if (fieldRawType.isPrimitive() || fieldRawType == String.class || fieldRawType == Object.class) {
            return;
        }
        if (TypeUtils.isBoxed(fieldRawType)) {
            return;
        }
        if (fieldRawType == context) {
            return;
        }
        if (!fieldRawType.getName().startsWith("java")) {
            compilationService.submit(() -> {
                AtomicBoolean flag = flags.computeIfAbsent(fieldRawType, k -> new AtomicBoolean(false));
                if (flag.compareAndSet(false, true)) {
                    Descriptor.getAllDescriptorsMap(fieldRawType);
                }
            });
        } else if (TypeUtils.isCollection(fieldRawType) || TypeUtils.isMap(fieldRawType)) {
            compilationService.submit(() -> Descriptor.warmGenericTask(TypeToken.of((Type)field.getGenericType())));
        } else if (fieldRawType.isArray() && !(componentType = fieldRawType.getComponentType()).isPrimitive()) {
            compilationService.submit(() -> Descriptor.warmGenericTask(TypeToken.of((Type)field.getGenericType())));
        }
    }

    static void warmGenericTask(TypeToken<?> typeToken) {
        Class<?> rawType = TypeUtils.getRawType(typeToken);
        if (rawType.isPrimitive() || rawType == String.class || rawType == Object.class) {
            return;
        }
        if (TypeUtils.isBoxed(rawType)) {
            return;
        }
        if (!rawType.getName().startsWith("java")) {
            Descriptor.getAllDescriptorsMap(rawType);
        } else if (TypeUtils.isCollection(rawType)) {
            TypeToken<?> elementType = TypeUtils.getElementType(typeToken);
            Descriptor.warmGenericTask(elementType);
        } else if (TypeUtils.isMap(rawType)) {
            Tuple2<TypeToken<?>, TypeToken<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeToken);
            Descriptor.warmGenericTask((TypeToken)mapKeyValueType.f0);
            Descriptor.warmGenericTask((TypeToken)mapKeyValueType.f1);
        } else if (rawType.isArray()) {
            Descriptor.warmGenericTask(typeToken.getComponentType());
        }
    }

    static SortedMap<Field, Descriptor> buildBeanedDescriptorsMap(Class<?> clz, boolean searchParent) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> clazz = clz;
        HashMap methodMap = new HashMap();
        do {
            AnnotatedElement[] fields = clazz.getDeclaredFields();
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isAnnotationPresent(Ignore.class)) continue;
                fieldList.add(field);
            }
            Arrays.stream(clazz.getDeclaredMethods()).filter(m -> !Modifier.isPrivate(m.getModifiers())).forEach(m -> methodMap.put(Tuple2.of(m.getDeclaringClass(), m.getName()), (Method)m));
        } while ((clazz = clazz.getSuperclass()) != null && searchParent);
        for (AnnotatedElement annotatedElement : clz.getInterfaces()) {
            Method[] methods;
            for (Method method : methods = ((Class)annotatedElement).getDeclaredMethods()) {
                if (!method.isDefault()) continue;
                methodMap.put(Tuple2.of(method.getDeclaringClass(), method.getName()), method);
            }
        }
        TreeMap<Field, Descriptor> descriptorMap = new TreeMap<Field, Descriptor>(fieldComparator);
        for (Field field : fieldList) {
            Method setter;
            Class<?> clazz2 = field.getDeclaringClass();
            String fieldName = field.getName();
            String cap = StringUtils.capitalize(fieldName);
            Method getter = "boolean".equalsIgnoreCase(field.getType().getSimpleName()) ? (Method)methodMap.get(Tuple2.of(clazz2, "is" + cap)) : (Method)methodMap.get(Tuple2.of(clazz2, "get" + cap));
            if (!(getter == null || getter.getParameterCount() == 0 && getter.getGenericReturnType().getTypeName().equals(field.getGenericType().getTypeName()))) {
                getter = null;
            }
            if (!((setter = (Method)methodMap.get(Tuple2.of(clazz2, "set" + cap))) == null || setter.getParameterCount() == 1 && setter.getGenericParameterTypes()[0].getTypeName().equals(field.getGenericType().getTypeName()))) {
                setter = null;
            }
            TypeToken fieldType = TypeToken.of((Type)field.getGenericType());
            descriptorMap.put(field, new Descriptor(field, fieldType, getter, setter));
        }
        return descriptorMap;
    }
}

