/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.collection.Tuple3;
import io.fury.exception.FuryException;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoCache;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.Serializer;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.type.FinalObjectTypeStub;
import io.fury.type.GenericType;
import io.fury.type.Generics;
import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import io.fury.util.UnsafeFieldAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public final class ObjectSerializer<T>
extends Serializer<T> {
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final GenericTypeField[] otherFields;
    private final GenericTypeField[] containerFields;
    private final Constructor<T> constructor;
    private final int classVersionHash;

    public ObjectSerializer(Fury fury, Class<T> cls) {
        this(fury, cls, true);
    }

    public ObjectSerializer(Fury fury, Class<T> cls, boolean resolveParent) {
        super(fury, cls);
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.classResolver.setSerializerIfAbsent(cls, this);
        this.constructor = ReflectionUtils.getExecutableNoArgConstructor(cls);
        Collection<Descriptor> descriptors = fury.getClassResolver().getAllDescriptorsMap(cls, resolveParent).values();
        this.classVersionHash = fury.checkClassVersion() ? ObjectSerializer.computeVersionHash(descriptors) : 0;
        DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(descriptors, false, fury.compressNumber());
        Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> infos = ObjectSerializer.buildFieldInfos(fury, descriptorGrouper);
        this.finalFields = (FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (GenericTypeField[])infos.f1;
        this.containerFields = (GenericTypeField[])infos.f2;
    }

    static Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> buildFieldInfos(Fury fury, DescriptorGrouper grouper) {
        Collection<Descriptor> primitives = grouper.getPrimitiveDescriptors();
        Collection<Descriptor> boxed = grouper.getBoxedDescriptors();
        Collection<Descriptor> finals = grouper.getFinalDescriptors();
        FinalTypeField[] finalFields = new FinalTypeField[primitives.size() + boxed.size() + finals.size()];
        int cnt = 0;
        for (Descriptor d : primitives) {
            finalFields[cnt++] = ObjectSerializer.buildFinalTypeField(fury, d);
        }
        for (Descriptor d : boxed) {
            finalFields[cnt++] = ObjectSerializer.buildFinalTypeField(fury, d);
        }
        for (Descriptor d : finals) {
            finalFields[cnt++] = ObjectSerializer.buildFinalTypeField(fury, d);
        }
        boolean[] isFinal = new boolean[finalFields.length];
        for (int i = 0; i < isFinal.length; ++i) {
            ClassInfo classInfo = finalFields[i].classInfo;
            isFinal[i] = classInfo != null && fury.getClassResolver().isFinal(classInfo.getCls());
        }
        cnt = 0;
        GenericTypeField[] otherFields = new GenericTypeField[grouper.getOtherDescriptors().size()];
        for (Descriptor descriptor : grouper.getOtherDescriptors()) {
            GenericTypeField genericTypeField = new GenericTypeField(descriptor.getRawType(), descriptor.getDeclaringClass() + "." + descriptor.getName(), descriptor.getField() != null ? new UnsafeFieldAccessor(descriptor.getField()) : null, fury);
            otherFields[cnt++] = genericTypeField;
        }
        cnt = 0;
        Collection<Descriptor> collections = grouper.getCollectionDescriptors();
        Collection<Descriptor> maps = grouper.getMapDescriptors();
        GenericTypeField[] containerFields = new GenericTypeField[collections.size() + maps.size()];
        for (Descriptor d : collections) {
            containerFields[cnt++] = ObjectSerializer.buildContainerField(fury, d);
        }
        for (Descriptor d : maps) {
            containerFields[cnt++] = ObjectSerializer.buildContainerField(fury, d);
        }
        return Tuple3.of(Tuple2.of(finalFields, isFinal), otherFields, containerFields);
    }

    private static FinalTypeField buildFinalTypeField(Fury fury, Descriptor d) {
        return new FinalTypeField(d.getRawType(), d.getDeclaringClass() + "." + d.getName(), d.getField() != null ? new UnsafeFieldAccessor(d.getField()) : null, fury);
    }

    private static GenericTypeField buildContainerField(Fury fury, Descriptor d) {
        return new GenericTypeField(d.getTypeToken(), d.getDeclaringClass() + "." + d.getName(), d.getField() != null ? new UnsafeFieldAccessor(d.getField()) : null, fury);
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            buffer.writeInt(this.classVersionHash);
        }
        this.writeFinalFields(buffer, value, fury, refResolver, classResolver);
        for (GenericTypeField fieldInfo : this.otherFields) {
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            if (fieldInfo.trackingRef) {
                fury.writeRef(buffer, fieldValue, fieldInfo.classInfoCache);
                continue;
            }
            fury.writeNullable(buffer, fieldValue, fieldInfo.classInfoCache);
        }
        this.writeContainerFields(buffer, value, fury, refResolver, classResolver);
    }

    private void writeFinalFields(MemoryBuffer buffer, T value, Fury fury, RefResolver refResolver, ClassResolver classResolver) {
        FinalTypeField[] finalFields = this.finalFields;
        boolean metaContextShareEnabled = fury.getConfig().shareMetaContext();
        for (int i = 0; i < finalFields.length; ++i) {
            Object fieldValue;
            FinalTypeField fieldInfo = finalFields[i];
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.writePrimitiveFieldValueFailed(fury, buffer, value, fieldAccessor, classId) || !ObjectSerializer.writeBasicObjectFieldValueFailed(fury, buffer, fieldValue = fieldAccessor.getObject(value), classId)) continue;
            Serializer<Object> serializer = fieldInfo.classInfo.getSerializer();
            if (!metaContextShareEnabled || this.isFinal[i]) {
                fury.writeRef(buffer, fieldValue, serializer);
                continue;
            }
            if (serializer.needToWriteRef()) {
                if (refResolver.writeRefOrNull(buffer, fieldValue)) continue;
                classResolver.writeClass(buffer, fieldInfo.classInfo);
                serializer.write(buffer, fieldValue);
                continue;
            }
            fury.writeNullable(buffer, fieldValue, fieldInfo.classInfo);
        }
    }

    private void writeContainerFields(MemoryBuffer buffer, T value, Fury fury, RefResolver refResolver, ClassResolver classResolver) {
        Generics generics = fury.getGenerics();
        for (GenericTypeField fieldInfo : this.containerFields) {
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            ObjectSerializer.writeContainerFieldValue(fury, refResolver, classResolver, generics, fieldInfo, buffer, fieldValue);
        }
    }

    protected static void writeContainerFieldValue(Fury fury, RefResolver refResolver, ClassResolver classResolver, Generics generics, GenericTypeField fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        if (fieldInfo.trackingRef) {
            if (!refResolver.writeRefOrNull(buffer, fieldValue)) {
                ClassInfo classInfo = classResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoCache);
                generics.pushGenericType(fieldInfo.genericType);
                fury.writeNonRef(buffer, fieldValue, classInfo);
                generics.popGenericType();
            }
        } else if (fieldValue == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            generics.pushGenericType(fieldInfo.genericType);
            fury.writeNonRef(buffer, fieldValue, classResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoCache));
            generics.popGenericType();
        }
    }

    @Override
    public T read(MemoryBuffer buffer) {
        T obj = ObjectSerializer.newBean(this.constructor, this.type);
        this.refResolver.reference(obj);
        return this.readAndSetFields(buffer, obj);
    }

    public T readAndSetFields(MemoryBuffer buffer, T obj) {
        Object fieldValue;
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            int hash = buffer.readInt();
            ObjectSerializer.checkClassVersion(fury, hash, this.classVersionHash);
        }
        FinalTypeField[] finalFields = this.finalFields;
        boolean metaContextShareEnabled = fury.getConfig().shareMetaContext();
        for (int i = 0; i < finalFields.length; ++i) {
            FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = !metaContextShareEnabled || this.isFinal[i];
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, obj, fieldAccessor, classId) || !ObjectSerializer.readBasicObjectFieldValueFailed(fury, buffer, obj, fieldAccessor, classId)) continue;
            fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
            fieldAccessor.putObject(obj, fieldValue);
        }
        for (GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue2 = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue2);
        }
        Generics generics = fury.getGenerics();
        for (GenericTypeField fieldInfo : this.containerFields) {
            fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    static Object readFinalObjectFieldValue(Fury fury, RefResolver refResolver, ClassResolver classResolver, FinalTypeField fieldInfo, boolean isFinal, MemoryBuffer buffer) {
        Object fieldValue;
        Serializer serializer = fieldInfo.classInfo.getSerializer();
        if (isFinal) {
            fieldValue = fury.readRef(buffer, serializer);
        } else if (serializer.needToWriteRef()) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                classResolver.readClassInfo(buffer, fieldInfo.classInfo);
                fieldValue = serializer.read(buffer);
                refResolver.setReadObject(nextReadRefId, fieldValue);
            } else {
                fieldValue = refResolver.getReadObject();
            }
        } else {
            byte headFlag = buffer.readByte();
            if (headFlag == -3) {
                fieldValue = null;
            } else {
                classResolver.readClassInfo(buffer, fieldInfo.classInfo);
                fieldValue = serializer.read(buffer);
            }
        }
        return fieldValue;
    }

    static Object readOtherFieldValue(Fury fury, GenericTypeField fieldInfo, MemoryBuffer buffer) {
        byte headFlag;
        Object fieldValue = fieldInfo.trackingRef ? fury.readRef(buffer, fieldInfo.classInfoCache) : ((headFlag = buffer.readByte()) == -3 ? null : fury.readNonRef(buffer, fieldInfo.classInfoCache));
        return fieldValue;
    }

    static Object readContainerFieldValue(Fury fury, Generics generics, GenericTypeField fieldInfo, MemoryBuffer buffer) {
        Object fieldValue;
        if (fieldInfo.trackingRef) {
            generics.pushGenericType(fieldInfo.genericType);
            fieldValue = fury.readRef(buffer, fieldInfo.classInfoCache);
            generics.popGenericType();
        } else {
            byte headFlag = buffer.readByte();
            if (headFlag == -3) {
                fieldValue = null;
            } else {
                generics.pushGenericType(fieldInfo.genericType);
                fieldValue = fury.readNonRef(buffer, fieldInfo.classInfoCache);
                generics.popGenericType();
            }
        }
        return fieldValue;
    }

    static boolean writePrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, UnsafeFieldAccessor fieldAccessor, short classId) {
        switch (classId) {
            case 5: {
                buffer.writeBoolean(fieldAccessor.getBoolean(targetObject));
                return false;
            }
            case 6: {
                buffer.writeByte(fieldAccessor.getByte(targetObject));
                return false;
            }
            case 7: {
                buffer.writeChar(fieldAccessor.getChar(targetObject));
                return false;
            }
            case 8: {
                buffer.writeShort(fieldAccessor.getShort(targetObject));
                return false;
            }
            case 9: {
                int fieldValue = fieldAccessor.getInt(targetObject);
                if (fury.compressNumber()) {
                    buffer.writeVarInt(fieldValue);
                } else {
                    buffer.writeInt(fieldValue);
                }
                return false;
            }
            case 10: {
                buffer.writeFloat(fieldAccessor.getFloat(targetObject));
                return false;
            }
            case 11: {
                long fieldValue = fieldAccessor.getLong(targetObject);
                if (fury.compressNumber()) {
                    buffer.writeVarLong(fieldValue);
                } else {
                    buffer.writeLong(fieldValue);
                }
                return false;
            }
            case 12: {
                buffer.writeDouble(fieldAccessor.getDouble(targetObject));
                return false;
            }
        }
        return true;
    }

    static boolean writeBasicObjectFieldValueFailed(Fury fury, MemoryBuffer buffer, Object fieldValue, short classId) {
        if (!fury.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fury.writeJavaStringRef(buffer, (String)fieldValue);
                return false;
            }
            case 14: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeBoolean((Boolean)fieldValue);
                }
                return false;
            }
            case 15: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeByte((Byte)fieldValue);
                }
                return false;
            }
            case 16: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeChar(((Character)fieldValue).charValue());
                }
                return false;
            }
            case 17: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeShort((Short)fieldValue);
                }
                return false;
            }
            case 18: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    if (fury.compressNumber()) {
                        buffer.writeVarInt((Integer)fieldValue);
                    } else {
                        buffer.writeInt((Integer)fieldValue);
                    }
                }
                return false;
            }
            case 19: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeFloat(((Float)fieldValue).floatValue());
                }
                return false;
            }
            case 20: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    if (fury.compressNumber()) {
                        buffer.writeVarLong((Long)fieldValue);
                    } else {
                        buffer.writeLong((Long)fieldValue);
                    }
                }
                return false;
            }
            case 21: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeDouble((Double)fieldValue);
                }
                return false;
            }
        }
        return true;
    }

    static boolean readPrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, UnsafeFieldAccessor fieldAccessor, short classId) {
        switch (classId) {
            case 5: {
                fieldAccessor.putBoolean(targetObject, buffer.readBoolean());
                return false;
            }
            case 6: {
                fieldAccessor.putByte(targetObject, buffer.readByte());
                return false;
            }
            case 7: {
                fieldAccessor.putChar(targetObject, buffer.readChar());
                return false;
            }
            case 8: {
                fieldAccessor.putShort(targetObject, buffer.readShort());
                return false;
            }
            case 9: {
                if (fury.compressNumber()) {
                    fieldAccessor.putInt(targetObject, buffer.readVarInt());
                } else {
                    fieldAccessor.putInt(targetObject, buffer.readInt());
                }
                return false;
            }
            case 10: {
                fieldAccessor.putFloat(targetObject, buffer.readFloat());
                return false;
            }
            case 11: {
                if (fury.compressNumber()) {
                    fieldAccessor.putLong(targetObject, buffer.readVarLong());
                } else {
                    fieldAccessor.putLong(targetObject, buffer.readLong());
                }
                return false;
            }
            case 12: {
                fieldAccessor.putDouble(targetObject, buffer.readDouble());
                return false;
            }
            case 22: {
                fieldAccessor.putObject(targetObject, fury.readJavaStringRef(buffer));
                return false;
            }
        }
        return true;
    }

    static boolean readBasicObjectFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, UnsafeFieldAccessor fieldAccessor, short classId) {
        if (!fury.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fieldAccessor.putObject(targetObject, fury.readJavaStringRef(buffer));
                return false;
            }
            case 14: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readBoolean());
                }
                return false;
            }
            case 15: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readByte());
                }
                return false;
            }
            case 16: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Character.valueOf(buffer.readChar()));
                }
                return false;
            }
            case 17: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readShort());
                }
                return false;
            }
            case 18: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else if (fury.compressNumber()) {
                    fieldAccessor.putObject(targetObject, buffer.readVarInt());
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readInt());
                }
                return false;
            }
            case 19: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Float.valueOf(buffer.readFloat()));
                }
                return false;
            }
            case 20: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else if (fury.compressNumber()) {
                    fieldAccessor.putObject(targetObject, buffer.readVarLong());
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readLong());
                }
                return false;
            }
            case 21: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readDouble());
                }
                return false;
            }
        }
        return true;
    }

    static <T> T newBean(Constructor<T> constructor, Class<T> type) {
        if (constructor != null) {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Platform.throwException(e);
            }
        }
        return Platform.newInstance(type);
    }

    private static short getRegisteredClassId(Fury fury, Class<?> cls) {
        Short classId = fury.getClassResolver().getRegisteredClassId(cls);
        return classId == null ? (short)0 : classId;
    }

    public static int computeVersionHash(Collection<Descriptor> descriptors) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Descriptor d : descriptors) {
            Integer integer = Objects.hash(d.getName(), d.getRawType().getName(), d.getDeclaringClass());
            list.add(integer);
        }
        return list.hashCode();
    }

    public static void checkClassVersion(Fury fury, int readHash, int classVersionHash) {
        if (readHash != classVersionHash) {
            throw new FuryException(String.format("Read class %s version %s is not consistent with %s", fury.getClassResolver().getCurrentReadClass(), readHash, classVersionHash));
        }
    }

    static final class FinalTypeField
    extends InternalFieldInfo {
        final ClassInfo classInfo;

        private FinalTypeField(Class<?> type, String fieldName, UnsafeFieldAccessor accessor, Fury fury) {
            super(ObjectSerializer.getRegisteredClassId(fury, type), fieldName, accessor);
            this.classInfo = type == FinalObjectTypeStub.class ? null : fury.getClassResolver().getClassInfo(type);
        }
    }

    static final class GenericTypeField
    extends InternalFieldInfo {
        protected final GenericType genericType;
        protected final ClassInfoCache classInfoCache;
        protected final boolean trackingRef;

        private GenericTypeField(Class<?> cls, String qualifiedFieldName, UnsafeFieldAccessor accessor, Fury fury) {
            super(ObjectSerializer.getRegisteredClassId(fury, cls), qualifiedFieldName, accessor);
            this.genericType = fury.getClassResolver().buildGenericType(cls);
            this.classInfoCache = fury.getClassResolver().nilClassInfoCache();
            this.trackingRef = fury.getClassResolver().needToWriteRef(cls);
        }

        private GenericTypeField(TypeToken<?> typeToken, String qualifiedFieldName, UnsafeFieldAccessor accessor, Fury fury) {
            super(ObjectSerializer.getRegisteredClassId(fury, TypeUtils.getRawType(typeToken)), qualifiedFieldName, accessor);
            this.genericType = fury.getClassResolver().buildGenericType(typeToken);
            this.classInfoCache = fury.getClassResolver().nilClassInfoCache();
            this.trackingRef = fury.getClassResolver().needToWriteRef(TypeUtils.getRawType(typeToken));
        }

        @Override
        public String toString() {
            return "GenericTypeField{genericType=" + this.genericType + ", classId=" + this.classId + ", qualifiedFieldName=" + this.qualifiedFieldName + ", field=" + (this.fieldAccessor != null ? this.fieldAccessor.getField() : null) + '}';
        }
    }

    static class InternalFieldInfo {
        protected final short classId;
        protected final String qualifiedFieldName;
        protected final UnsafeFieldAccessor fieldAccessor;

        private InternalFieldInfo(short classId, String qualifiedFieldName, UnsafeFieldAccessor fieldAccessor) {
            this.classId = classId;
            this.qualifiedFieldName = qualifiedFieldName;
            this.fieldAccessor = fieldAccessor;
        }

        public String toString() {
            return "InternalFieldInfo{classId=" + this.classId + ", fieldName=" + this.qualifiedFieldName + ", field=" + (this.fieldAccessor != null ? this.fieldAccessor.getField() : null) + '}';
        }
    }
}

