/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfoCache;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.MapSerializers;
import io.fury.serializer.ReplaceResolveSerializer;
import io.fury.type.Type;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import io.fury.util.unsafe._JDKAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class GuavaSerializers {
    private static final String pkg = "com.google.common.collect";
    private static volatile Object[] regularImmutableListInvokeCache;

    private static Object[] regularImmutableListInvoke() {
        Object[] regularImmutableListInvoke = regularImmutableListInvokeCache;
        if (regularImmutableListInvoke == null) {
            Class<?> cls;
            regularImmutableListInvoke = new Object[3];
            regularImmutableListInvoke[0] = cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableList", ImmutableList.of((Object)1, (Object)2).getClass());
            regularImmutableListInvoke[1] = ReflectionUtils.getFieldOffset(cls, "array");
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(cls);
            try {
                Function func;
                MethodHandle ctr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Object[].class));
                regularImmutableListInvoke[2] = func = _JDKAccess.makeJDKFunction(lookup, ctr);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                Platform.throwException(e);
            }
            regularImmutableListInvokeCache = regularImmutableListInvoke;
        }
        return regularImmutableListInvoke;
    }

    public static void registerDefaultSerializers(Fury fury) {
        Class<?> cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableBiMap", ImmutableBiMap.of().getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.SingletonImmutableBiMap", ImmutableBiMap.of((Object)1, (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableMap", ImmutableMap.of().getClass());
        fury.registerSerializer(cls, new ImmutableMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableList", ImmutableList.of().getClass());
        fury.registerSerializer(cls, new RegularImmutableListSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.SingletonImmutableList", ImmutableList.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableListSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableSet", ImmutableSet.of().getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.SingletonImmutableSet", ImmutableSet.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.RegularImmutableSortedSet", ImmutableSortedSet.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)).getClass());
        fury.registerSerializer(cls, new ImmutableSortedSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass("com.google.common.collect.ImmutableSortedMap", ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableSortedMapSerializer(fury, cls));
    }

    static Class<?> loadClass(String className, Class<?> cache) {
        if (cache.getName().equals(className)) {
            return cache;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class ImmutableBiMapSerializer<T extends ImmutableBiMap>
    extends GuavaMapSerializer<T> {
        private final Function<Integer, ImmutableBiMap.Builder> builderCtr = ImmutableBiMapSerializer.builderCtr(ImmutableBiMap.Builder.class);

        public ImmutableBiMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected ImmutableMap.Builder makeBuilder(int size) {
            return (ImmutableMap.Builder)this.builderCtr.apply(size);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableBiMap.copyOf((Map)map);
        }
    }

    public static final class ImmutableMapSerializer<T extends ImmutableMap>
    extends GuavaMapSerializer<T> {
        private final Function<Integer, ImmutableMap.Builder> builderCtr = ImmutableMapSerializer.builderCtr(ImmutableMap.Builder.class);

        public ImmutableMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected ImmutableMap.Builder makeBuilder(int size) {
            return this.builderCtr.apply(size);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableMap.copyOf((Map)map);
        }
    }

    public static final class RegularImmutableListSerializer<T extends ImmutableList>
    extends GuavaCollectionSerializer<T> {
        private final long offset;
        private final Function<Object[], ImmutableList> function;
        private final ClassInfoCache classInfoCache;

        public RegularImmutableListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            Object[] cache = GuavaSerializers.regularImmutableListInvoke();
            this.offset = (Long)cache[1];
            this.function = (Function)cache[2];
            this.classInfoCache = fury.getClassResolver().nilClassInfoCache();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            Object[] array = (Object[])Platform.getObject(value, this.offset);
            buffer.writePositiveVarInt(array.length);
            for (Object o : array) {
                this.fury.writeRef(buffer, o, this.classInfoCache);
            }
        }

        @Override
        public T read(MemoryBuffer buffer) {
            int len = buffer.readPositiveVarInt();
            Object[] array = new Object[len];
            for (int i = 0; i < len; ++i) {
                array[i] = this.fury.readRef(buffer, this.classInfoCache);
            }
            return (T)this.function.apply(array);
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        protected T xnewInstance(Collection collection) {
            return (T)ImmutableList.copyOf((Collection)collection);
        }
    }

    public static final class ImmutableListSerializer<T extends ImmutableList>
    extends GuavaCollectionSerializer<T> {
        public ImmutableListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            buffer.writePositiveVarInt(value.size());
            for (Object o : value) {
                this.fury.writeRef(buffer, o, this.elementClassInfoWriteCache);
            }
        }

        @Override
        public T read(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            Object[] array = new Object[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.fury.readRef(buffer, this.elementClassInfoReadCache);
            }
            return (T)ImmutableList.copyOf((Object[])array);
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public T xnewInstance(Collection collection) {
            return (T)ImmutableList.copyOf((Collection)collection);
        }
    }

    public static final class ImmutableSetSerializer<T extends ImmutableSet>
    extends GuavaCollectionSerializer<T> {
        public ImmutableSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            buffer.writePositiveVarInt(value.size());
            for (Object o : value) {
                this.fury.writeRef(buffer, o, this.elementClassInfoWriteCache);
            }
        }

        @Override
        public T read(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            Object[] array = new Object[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.fury.readRef(buffer, this.elementClassInfoReadCache);
            }
            return (T)ImmutableSet.copyOf((Object[])array);
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        protected T xnewInstance(Collection collection) {
            return (T)ImmutableSet.copyOf((Collection)collection);
        }
    }

    public static final class ImmutableSortedSetSerializer<T extends ImmutableSortedSet>
    extends CollectionSerializers.CollectionSerializer<T> {
        public ImmutableSortedSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.fury.writeRef(buffer, value.comparator());
            buffer.writePositiveVarInt(value.size());
            for (Object o : value) {
                this.fury.writeRef(buffer, o, this.elementClassInfoWriteCache);
            }
        }

        @Override
        public T read(MemoryBuffer buffer) {
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            int size = buffer.readPositiveVarInt();
            Object[] array = new Object[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.fury.readRef(buffer, this.elementClassInfoReadCache);
            }
            return (T)new ImmutableSortedSet.Builder(comparator).add(array).build();
        }
    }

    public static final class ImmutableSortedMapSerializer<T extends ImmutableSortedMap>
    extends MapSerializers.MapSerializer<T> {
        public ImmutableSortedMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.fury.writeRef(buffer, value.comparator());
            buffer.writePositiveVarInt(value.size());
            this.simpleWriteElements(this.fury, buffer, value);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(comparator);
            int size = buffer.readPositiveVarInt();
            ClassInfoCache keyClassInfoReadCache = this.keyClassInfoReadCache;
            ClassInfoCache valueClassInfoReadCache = this.valueClassInfoReadCache;
            for (int i = 0; i < size; ++i) {
                Object key = this.fury.readRef(buffer, keyClassInfoReadCache);
                Object value = this.fury.readRef(buffer, valueClassInfoReadCache);
                builder.put(key, value);
            }
            return (T)((ImmutableSortedMap)builder.buildOrThrow());
        }
    }

    static abstract class GuavaMapSerializer<T extends Map>
    extends MapSerializers.MapSerializer<T> {
        public GuavaMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            buffer.writePositiveVarInt(value.size());
            this.simpleWriteElements(this.fury, buffer, value);
        }

        protected abstract ImmutableMap.Builder makeBuilder(int var1);

        @Override
        public T read(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            ImmutableMap.Builder builder = this.makeBuilder(size);
            Fury fury = this.fury;
            ClassInfoCache keyClassInfoReadCache = this.keyClassInfoReadCache;
            ClassInfoCache valueClassInfoReadCache = this.valueClassInfoReadCache;
            for (int i = 0; i < size; ++i) {
                Object key = fury.readRef(buffer, keyClassInfoReadCache);
                Object value = fury.readRef(buffer, valueClassInfoReadCache);
                builder.put(key, value);
            }
            return (T)builder.buildOrThrow();
        }

        @Override
        public short getXtypeId() {
            return -Type.MAP.getId();
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            HashMap map = new HashMap();
            GuavaMapSerializer.xreadElements(this.fury, buffer, map, size);
            T immutableMap = this.xnewInstance(map);
            this.fury.getRefResolver().reference(immutableMap);
            return immutableMap;
        }

        protected abstract T xnewInstance(Map var1);

        protected static Function builderCtr(Class<?> builderClass) {
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(builderClass);
            MethodHandle ctr = null;
            try {
                ctr = lookup.findConstructor(builderClass, MethodType.methodType(Void.TYPE, Integer.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                Platform.throwException(e);
            }
            return _JDKAccess.makeJDKFunction(lookup, ctr);
        }
    }

    static abstract class GuavaCollectionSerializer<T extends Collection>
    extends CollectionSerializers.CollectionSerializer<T> {
        private ReplaceResolveSerializer serializer;

        public GuavaCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        protected ReplaceResolveSerializer getOrCreateSerializer() {
            ReplaceResolveSerializer serializer = this.serializer;
            if (serializer == null) {
                this.serializer = serializer = new ReplaceResolveSerializer(this.fury, this.type);
            }
            return serializer;
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)((Collection)this.getOrCreateSerializer().read(buffer));
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.getOrCreateSerializer().write(buffer, (Object)value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            ArrayList list = new ArrayList();
            GuavaCollectionSerializer.xreadElements(this.fury, buffer, list, size);
            T immutableList = this.xnewInstance(list);
            this.fury.getRefResolver().reference(immutableList);
            return immutableList;
        }

        protected abstract T xnewInstance(Collection var1);
    }
}

