/*
 * Decompiled with CFR 0.152.
 */
package io.fury.resolver;

import com.google.common.base.Preconditions;
import io.fury.annotation.Internal;
import io.fury.util.MurmurHash3;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@Internal
public final class EnumStringBytes {
    static final short DEFAULT_DYNAMIC_WRITE_STRING_ID = -1;
    final byte[] bytes;
    final long hashCode;
    short dynamicWriteStringId = (short)-1;

    public EnumStringBytes(byte[] bytes, long hashCode) {
        assert (hashCode != 0L);
        this.bytes = bytes;
        this.hashCode = hashCode;
    }

    public EnumStringBytes(String string) {
        byte[] classNameBytes = string.getBytes(StandardCharsets.UTF_8);
        Preconditions.checkArgument((classNameBytes.length <= Short.MAX_VALUE ? 1 : 0) != 0);
        long hashCode = MurmurHash3.murmurhash3_x64_128(classNameBytes, 0, classNameBytes.length, 47)[0];
        if (hashCode == 0L) {
            ++hashCode;
        }
        this.bytes = classNameBytes;
        this.hashCode = hashCode;
    }

    public boolean equals(Object o) {
        EnumStringBytes that = (EnumStringBytes)o;
        return this.hashCode == that.hashCode;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return (int)this.hashCode;
    }

    public String toString() {
        String str = new String(this.bytes);
        return "string: " + str + " size: " + this.bytes.length + " " + Arrays.toString(this.bytes);
    }
}

