/*
 * Decompiled with CFR 0.152.
 */
package io.fury.memory;

import com.google.common.base.Preconditions;
import io.fury.memory.MemoryBuffer;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class MemoryUtils {
    private static final long BAS_BUF_BUF = ReflectionUtils.getFieldOffsetChecked(ByteArrayOutputStream.class, "buf");
    private static final long BAS_BUF_COUNT = ReflectionUtils.getFieldOffsetChecked(ByteArrayOutputStream.class, "count");
    private static final long BIS_BUF_BUF = ReflectionUtils.getFieldOffsetChecked(ByteArrayInputStream.class, "buf");
    private static final long BIS_BUF_POS = ReflectionUtils.getFieldOffsetChecked(ByteArrayInputStream.class, "pos");
    private static final long BIS_BUF_COUNT = ReflectionUtils.getFieldOffsetChecked(ByteArrayInputStream.class, "count");

    public static MemoryBuffer buffer(int size) {
        return MemoryUtils.wrap(new byte[size]);
    }

    public static MemoryBuffer buffer(long address, int size) {
        return MemoryBuffer.fromNativeAddress(address, size);
    }

    public static MemoryBuffer wrap(byte[] buffer, int offset, int length) {
        return MemoryBuffer.fromByteArray(buffer, offset, length);
    }

    public static MemoryBuffer wrap(byte[] buffer) {
        return MemoryBuffer.fromByteArray(buffer);
    }

    public static MemoryBuffer wrap(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            return MemoryBuffer.fromByteBuffer(buffer);
        }
        int offset = buffer.arrayOffset() + buffer.position();
        return MemoryBuffer.fromByteArray(buffer.array(), offset, buffer.remaining());
    }

    public static void wrap(ByteArrayOutputStream stream, MemoryBuffer buffer) {
        Preconditions.checkNotNull((Object)stream);
        byte[] buf = (byte[])Platform.getObject(stream, BAS_BUF_BUF);
        int count = Platform.getInt(stream, BAS_BUF_COUNT);
        buffer.pointTo(buf, 0, buf.length);
        buffer.writerIndex(count);
    }

    public static void wrap(MemoryBuffer buffer, ByteArrayOutputStream stream) {
        Preconditions.checkNotNull((Object)stream);
        byte[] bytes = buffer.getHeapMemory();
        Preconditions.checkNotNull((Object)bytes);
        Platform.putObject(stream, BAS_BUF_BUF, bytes);
        Platform.putInt(stream, BAS_BUF_COUNT, buffer.writerIndex());
    }

    public static void wrap(ByteArrayInputStream stream, MemoryBuffer buffer) {
        Preconditions.checkNotNull((Object)stream);
        byte[] buf = (byte[])Platform.getObject(stream, BIS_BUF_BUF);
        int count = Platform.getInt(stream, BIS_BUF_COUNT);
        int pos = Platform.getInt(stream, BIS_BUF_POS);
        buffer.pointTo(buf, 0, count);
        buffer.readerIndex(pos);
    }

    public static int writePositiveVarInt(byte[] arr, int index, int v) {
        if (v >>> 7 == 0) {
            arr[index] = (byte)v;
            return 1;
        }
        if (v >>> 14 == 0) {
            arr[index++] = (byte)(v & 0x7F | 0x80);
            arr[index] = (byte)(v >>> 7);
            return 2;
        }
        if (v >>> 21 == 0) {
            arr[index++] = (byte)(v & 0x7F | 0x80);
            arr[index++] = (byte)(v >>> 7 | 0x80);
            arr[index] = (byte)(v >>> 14);
            return 3;
        }
        if (v >>> 28 == 0) {
            arr[index++] = (byte)(v & 0x7F | 0x80);
            arr[index++] = (byte)(v >>> 7 | 0x80);
            arr[index++] = (byte)(v >>> 14 | 0x80);
            arr[index] = (byte)(v >>> 21);
            return 4;
        }
        arr[index++] = (byte)(v & 0x7F | 0x80);
        arr[index++] = (byte)(v >>> 7 | 0x80);
        arr[index++] = (byte)(v >>> 14 | 0x80);
        arr[index++] = (byte)(v >>> 21 | 0x80);
        arr[index] = (byte)(v >>> 28);
        return 5;
    }
}

