/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import com.google.common.base.Preconditions;

public class DecimalUtils {
    public static final int DECIMAL_BYTE_LENGTH = 32;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 18;
    public static final int MAX_COMPACT_PRECISION = 18;
    private static final int[] minBytesForPrecision = new int[39];

    public static int minBytesForPrecision(int precision) {
        Preconditions.checkArgument((0 <= precision && precision <= 38 ? 1 : 0) != 0);
        return minBytesForPrecision[precision];
    }

    static {
        for (int precision = 0; precision < minBytesForPrecision.length; ++precision) {
            int numBytes;
            double tmp = ((double)precision * Math.log(10.0) / Math.log(2.0) + 1.0) / 8.0;
            DecimalUtils.minBytesForPrecision[precision] = numBytes = (int)Math.ceil(tmp);
        }
    }
}

