/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util.unsafe;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import io.fury.util.Utils;
import io.fury.util.unsafe._Lookup;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class _JDKAccess {
    public static final int JAVA_VERSION;
    public static final boolean OPEN_J9;
    public static final Unsafe UNSAFE;
    public static final Class<?> _INNER_UNSAFE_CLASS;
    public static final Object _INNER_UNSAFE;

    public static MethodHandles.Lookup _trustedLookup(Class<?> objectClass) {
        return _Lookup._trustedLookup(objectClass);
    }

    public static <T> T tryMakeFunction(MethodHandles.Lookup lookup, MethodHandle handle, Class<T> functionInterface) {
        try {
            return _JDKAccess.makeFunction(lookup, handle, functionInterface);
        }
        catch (Throwable e) {
            Utils.ignore(e);
            throw new IllegalStateException();
        }
    }

    public static <T> T makeFunction(MethodHandles.Lookup lookup, MethodHandle handle, Method methodToImpl) {
        MethodType methodType = handle.type();
        Class[] paramTypes = new Class[methodType.parameterCount()];
        for (int i = 0; i < paramTypes.length; ++i) {
            TypeDescriptor.OfField t = methodType.parameterType(i);
            if (((Class)t).isPrimitive()) {
                t = Primitives.wrap((Class)t);
            }
            paramTypes[i] = t;
        }
        MethodType instantiatedMethodType = MethodType.methodType(methodType.returnType(), paramTypes);
        MethodType methodToImplType = MethodType.methodType(methodToImpl.getReturnType(), methodToImpl.getParameterTypes());
        try {
            CallSite callSite = LambdaMetafactory.metafactory(lookup, methodToImpl.getName(), MethodType.methodType(methodToImpl.getDeclaringClass()), methodToImplType, handle, instantiatedMethodType);
            return (T)callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    public static <T> T makeFunction(MethodHandles.Lookup lookup, MethodHandle handle, Class<T> functionInterface) {
        String invokedName = "apply";
        try {
            Method[] methods;
            Method method = null;
            for (Method interfaceMethod : methods = functionInterface.getMethods()) {
                if (!interfaceMethod.getName().equals(invokedName)) continue;
                method = interfaceMethod;
                break;
            }
            if (method == null) {
                Preconditions.checkArgument((methods.length == 1 ? 1 : 0) != 0);
                method = methods[0];
                invokedName = method.getName();
            }
            MethodType interfaceType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            CallSite callSite = LambdaMetafactory.metafactory(lookup, invokedName, MethodType.methodType(functionInterface), interfaceType, handle, interfaceType);
            return (T)callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            UNSAFE.throwException(e);
            throw new IllegalStateException(e);
        }
    }

    static {
        Unsafe unsafe;
        String property = System.getProperty("java.specification.version");
        if (property.startsWith("1.")) {
            property = property.substring(2);
        }
        String jmvName = System.getProperty("java.vm.name", "");
        OPEN_J9 = jmvName.contains("OpenJ9");
        JAVA_VERSION = Integer.parseInt(property);
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
        }
        catch (Throwable cause) {
            throw new UnsupportedOperationException("Unsafe is not supported in this platform.");
        }
        UNSAFE = unsafe;
        if (JAVA_VERSION >= 11) {
            try {
                Field theInternalUnsafeField = Unsafe.class.getDeclaredField("theInternalUnsafe");
                theInternalUnsafeField.setAccessible(true);
                _INNER_UNSAFE = theInternalUnsafeField.get(null);
                _INNER_UNSAFE_CLASS = _INNER_UNSAFE.getClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            _INNER_UNSAFE_CLASS = null;
            _INNER_UNSAFE = null;
        }
    }
}

