/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.io.ClassLoaderObjectInputStream;
import io.fury.io.FuryObjectInput;
import io.fury.io.FuryObjectOutput;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import org.slf4j.Logger;

public class JavaSerializer
extends Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSerializer.class);
    private final FuryObjectInput objectInput;
    private final FuryObjectOutput objectOutput;

    public JavaSerializer(Fury fury, Class<?> cls) {
        super(fury, cls);
        if (cls != SerializedLambda.class) {
            LOG.warn("{} use java built-in serialization, which is inefficient. Please replace it with a {} or implements {}", new Object[]{cls, Serializer.class.getCanonicalName(), Externalizable.class.getCanonicalName()});
        }
        this.objectInput = new FuryObjectInput(fury, null);
        this.objectOutput = new FuryObjectOutput(fury, null);
    }

    public void write(MemoryBuffer buffer, Object value) {
        try {
            this.objectOutput.setBuffer(buffer);
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.fury.getSerializationContext().get(this.objectOutput);
            if (objectOutputStream == null) {
                objectOutputStream = new ObjectOutputStream(this.objectOutput);
                this.fury.getSerializationContext().add(this.objectOutput, objectOutputStream);
            }
            objectOutputStream.writeObject(value);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            Platform.throwException(e);
        }
    }

    public Object read(MemoryBuffer buffer) {
        try {
            this.objectInput.setBuffer(buffer);
            ObjectInputStream objectInputStream = (ObjectInputStream)this.fury.getSerializationContext().get(this.objectInput);
            if (objectInputStream == null) {
                objectInputStream = new ClassLoaderObjectInputStream(this.fury.getClassLoader(), this.objectInput);
                this.fury.getSerializationContext().add(this.objectInput, objectInputStream);
            }
            return objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Platform.throwException(e);
            throw new IllegalStateException("unreachable code");
        }
    }

    public static Method getWriteObjectMethod(Class<?> clz) {
        return JavaSerializer.getWriteObjectMethod(clz, true);
    }

    public static Method getWriteObjectMethod(Class<?> clz, boolean searchParent) {
        Method writeObject = JavaSerializer.getMethod(clz, "writeObject", searchParent);
        if (writeObject != null && JavaSerializer.isWriteObjectMethod(writeObject)) {
            return writeObject;
        }
        return null;
    }

    public static boolean isWriteObjectMethod(Method method) {
        return method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == ObjectOutputStream.class && method.getReturnType() == Void.TYPE && Modifier.isPrivate(method.getModifiers());
    }

    public static Method getReadObjectMethod(Class<?> clz) {
        return JavaSerializer.getReadObjectMethod(clz, true);
    }

    public static Method getReadObjectMethod(Class<?> clz, boolean searchParent) {
        Method readObject = JavaSerializer.getMethod(clz, "readObject", searchParent);
        if (readObject != null && JavaSerializer.isReadObjectMethod(readObject)) {
            return readObject;
        }
        return null;
    }

    public static boolean isReadObjectMethod(Method method) {
        return method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == ObjectInputStream.class && method.getReturnType() == Void.TYPE && Modifier.isPrivate(method.getModifiers());
    }

    public static Method getReadObjectNoData(Class<?> clz, boolean searchParent) {
        Method method = JavaSerializer.getMethod(clz, "readObjectNoData", searchParent);
        if (method != null && method.getParameterTypes().length == 0 && method.getReturnType() == Void.TYPE && Modifier.isPrivate(method.getModifiers())) {
            return method;
        }
        return null;
    }

    public static Method getReadResolveMethod(Class<?> clz) {
        Method readResolve = JavaSerializer.getMethod(clz, "readResolve", true);
        if (readResolve != null && readResolve.getParameterTypes().length == 0 && readResolve.getReturnType() == Object.class) {
            return readResolve;
        }
        return null;
    }

    public static Method getWriteReplaceMethod(Class<?> clz) {
        Method writeReplace = JavaSerializer.getMethod(clz, "writeReplace", true);
        if (writeReplace != null && writeReplace.getParameterTypes().length == 0 && writeReplace.getReturnType() == Object.class) {
            return writeReplace;
        }
        return null;
    }

    private static Method getMethod(Class<?> clz, String methodName, boolean searchParent) {
        Class<?> cls = clz;
        do {
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
        } while ((cls = cls.getSuperclass()) != null && searchParent);
        return null;
    }

    public static boolean serializedByJDK(byte[] data) {
        return JavaSerializer.serializedByJDK(data, 0);
    }

    public static boolean serializedByJDK(byte[] data, int offset) {
        short magicNumber = MemoryBuffer.getShortB(data, offset);
        return magicNumber == -21267;
    }

    public static boolean serializedByJDK(ByteBuffer buffer, int offset) {
        byte b0;
        byte b1 = buffer.get(offset + 1);
        short magicNumber = (short)((b1 & 0xFF) + ((b0 = buffer.get(offset)) << 8));
        return magicNumber == -21267;
    }
}

