/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.MapSerializers;
import io.fury.serializer.ReplaceResolveSerializer;
import io.fury.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GuavaSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        String pkg = "com.google.common.collect";
        Class<?> cls = GuavaSerializers.loadClass(pkg + ".RegularImmutableBiMap", ImmutableBiMap.of().getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass(pkg + ".SingletonImmutableBiMap", ImmutableBiMap.of((Object)1, (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass(pkg + ".RegularImmutableMap", ImmutableMap.of().getClass());
        fury.registerSerializer(cls, new ImmutableMapSerializer(fury, cls));
        cls = GuavaSerializers.loadClass(pkg + ".RegularImmutableList", ImmutableList.of().getClass());
        fury.registerSerializer(cls, new ImmutableListSerializer(fury, cls));
        cls = GuavaSerializers.loadClass(pkg + ".SingletonImmutableList", ImmutableList.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass(pkg + ".RegularImmutableSet", ImmutableSet.of().getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaSerializers.loadClass(pkg + ".SingletonImmutableSet", ImmutableSet.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
    }

    static Class<?> loadClass(String className, Class<?> cache) {
        if (cache.getName().equals(className)) {
            return cache;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class ImmutableBiMapSerializer<T extends ImmutableBiMap>
    extends GuavaMapSerializer<T> {
        public ImmutableBiMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableBiMap.copyOf((Map)map);
        }
    }

    public static final class ImmutableMapSerializer<T extends ImmutableMap>
    extends GuavaMapSerializer<T> {
        public ImmutableMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableMap.copyOf((Map)map);
        }
    }

    static abstract class GuavaMapSerializer<T extends Map>
    extends MapSerializers.MapSerializer<T> {
        private ReplaceResolveSerializer serializer;

        public GuavaMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        protected ReplaceResolveSerializer getOrCreateSerializer() {
            ReplaceResolveSerializer serializer = this.serializer;
            if (serializer == null) {
                this.serializer = serializer = new ReplaceResolveSerializer(this.fury, this.type);
            }
            return serializer;
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)((Map)this.getOrCreateSerializer().read(buffer));
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.getOrCreateSerializer().write(buffer, (Object)value);
        }

        @Override
        public short getXtypeId() {
            return -Type.MAP.getId();
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            HashMap map = new HashMap();
            GuavaMapSerializer.xreadElements(this.fury, buffer, map, size);
            T immutableMap = this.xnewInstance(map);
            this.fury.getRefResolver().reference(immutableMap);
            return immutableMap;
        }

        protected abstract T xnewInstance(Map var1);
    }

    public static final class ImmutableSetSerializer<T extends ImmutableSet>
    extends GuavaCollectionSerializer<T> {
        public ImmutableSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        protected T xnewInstance(Collection collection) {
            return (T)ImmutableSet.copyOf((Collection)collection);
        }
    }

    public static final class ImmutableListSerializer<T extends ImmutableList>
    extends GuavaCollectionSerializer<T> {
        public ImmutableListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            ArrayList list = new ArrayList();
            ImmutableListSerializer.xreadElements(this.fury, buffer, list, size);
            ImmutableList immutableList = ImmutableList.copyOf(list);
            this.fury.getRefResolver().reference(immutableList);
            return (T)immutableList;
        }

        @Override
        public T xnewInstance(Collection collection) {
            return (T)ImmutableList.copyOf((Collection)collection);
        }
    }

    static abstract class GuavaCollectionSerializer<T extends Collection>
    extends CollectionSerializers.CollectionSerializer<T> {
        private ReplaceResolveSerializer serializer;

        public GuavaCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        protected ReplaceResolveSerializer getOrCreateSerializer() {
            ReplaceResolveSerializer serializer = this.serializer;
            if (serializer == null) {
                this.serializer = serializer = new ReplaceResolveSerializer(this.fury, this.type);
            }
            return serializer;
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)((Collection)this.getOrCreateSerializer().read(buffer));
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.getOrCreateSerializer().write(buffer, (Object)value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            ArrayList list = new ArrayList();
            GuavaCollectionSerializer.xreadElements(this.fury, buffer, list, size);
            T immutableList = this.xnewInstance(list);
            this.fury.getRefResolver().reference(immutableList);
            return immutableList;
        }

        protected abstract T xnewInstance(Collection var1);
    }
}

