/*
 * Decompiled with CFR 0.152.
 */
package org.funktionale.option;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b6\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0002\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0000\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0000H\u0086\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\nH\u0086\bJ#\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\nH\u0086\bJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\nH\u0086\bJ/\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0000\"\u0004\b\u0001\u0010\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00000\nH\u0086\bJ6\u0010\u0010\u001a\u0002H\u000e\"\u0004\b\u0001\u0010\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000e0\nH\u0086\b\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00150\nH\u0086\bJ\r\u0010\u0016\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\bJ\b\u0010\u0019\u001a\u00020\bH&J)\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0000\"\u0004\b\u0001\u0010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000e0\nH\u0086\bJC\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0000\"\u0004\b\u0001\u0010\u001b\"\u0004\b\u0002\u0010\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00002\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u000e0\u001dH\u0086\bJ\u0006\u0010\u001e\u001a\u00020\bJ\r\u0010\u001f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0017J\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!\u00a8\u0006$"}, d2={"Lorg/funktionale/option/Option;", "T", "", "()V", "and", "X", "value", "exists", "", "predicate", "Lkotlin/Function1;", "filter", "filterNot", "flatMap", "R", "f", "fold", "ifEmpty", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "forEach", "", "get", "()Ljava/lang/Object;", "isDefined", "isEmpty", "map", "P1", "p1", "Lkotlin/Function2;", "nonEmpty", "orNull", "toList", "", "None", "Some", "funktionale-option"})
public abstract class Option<T> {
    public abstract boolean isEmpty();

    public final boolean nonEmpty() {
        return this.isDefined();
    }

    public final boolean isDefined() {
        return !this.isEmpty();
    }

    public abstract T get();

    @Nullable
    public final T orNull() {
        return this.isEmpty() ? null : (T)this.get();
    }

    @NotNull
    public final <R> Option<R> map(@NotNull Function1<? super T, ? extends R> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return this.isEmpty() ? (Option)None.INSTANCE : (Option)new Some<Object>(f.invoke(this.get()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P1, R> Option<R> map(@NotNull Option<? extends P1> p1, @NotNull Function2<? super T, ? super P1, ? extends R> f) {
        Option option2;
        Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        if (this.isEmpty()) {
            option2 = None.INSTANCE;
        } else {
            void this_$iv;
            Option<? extends P1> option3 = p1;
            if (this_$iv.isEmpty()) {
                option2 = None.INSTANCE;
            } else {
                void pp1;
                Some<Object> some;
                T t = this_$iv.get();
                Some<Object> some2 = some;
                Some<Object> some3 = some;
                Object object = f.invoke(this.get(), (Object)pp1);
                some2(object);
                option2 = some3;
            }
        }
        return option2;
    }

    public final <R> R fold(@NotNull Function0<? extends R> ifEmpty, @NotNull Function1<? super T, ? extends R> f) {
        Intrinsics.checkParameterIsNotNull(ifEmpty, (String)"ifEmpty");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return (R)(this.isEmpty() ? ifEmpty.invoke() : f.invoke(this.get()));
    }

    @NotNull
    public final <R> Option<R> flatMap(@NotNull Function1<? super T, ? extends Option<? extends R>> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return this.isEmpty() ? (Option)None.INSTANCE : (Option)f.invoke(this.get());
    }

    @NotNull
    public final Option<T> filter(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        return this.nonEmpty() && (Boolean)predicate.invoke(this.get()) != false ? this : (Option)None.INSTANCE;
    }

    @NotNull
    public final Option<T> filterNot(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        return this.nonEmpty() && (Boolean)predicate.invoke(this.get()) == false ? this : (Option)None.INSTANCE;
    }

    public final boolean exists(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        return this.nonEmpty() && (Boolean)predicate.invoke(this.get()) != false;
    }

    public final void forEach(@NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        if (this.nonEmpty()) {
            f.invoke(this.get());
        }
    }

    @NotNull
    public final List<T> toList() {
        return this.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf(this.get());
    }

    @NotNull
    public final <X> Option<X> and(@NotNull Option<? extends X> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.isEmpty() ? (Option)None.INSTANCE : value;
    }

    private Option() {
    }

    public /* synthetic */ Option(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lorg/funktionale/option/Option$None;", "Lorg/funktionale/option/Option;", "", "()V", "equals", "", "other", "", "get", "hashCode", "", "isEmpty", "funktionale-option"})
    public static final class None
    extends Option {
        public static final None INSTANCE;

        @NotNull
        public Void get() {
            throw (Throwable)new NoSuchElementException("None.get");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            return object instanceof None;
        }

        public int hashCode() {
            return Integer.MAX_VALUE;
        }

        private None() {
            super(null);
            INSTANCE = this;
        }

        static {
            new None();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\r\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/funktionale/option/Option$Some;", "T", "Lorg/funktionale/option/Option;", "t", "(Ljava/lang/Object;)V", "getT", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "", "get", "hashCode", "", "isEmpty", "toString", "", "funktionale-option"})
    public static final class Some<T>
    extends Option<T> {
        private final T t;

        @Override
        public T get() {
            return this.t;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            return object instanceof Some ? Intrinsics.areEqual(this.t, ((Some)other).get()) : false;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            int n;
            void $receiver$iv;
            T t = this.t;
            int i$iv = 17;
            void var3_3 = $receiver$iv;
            if (Intrinsics.areEqual((Object)var3_3, null)) {
                n = i$iv;
            } else {
                void b;
                int n2 = $receiver$iv.hashCode();
                int a = i$iv;
                n = a + b;
            }
            return n;
        }

        @NotNull
        public String toString() {
            return "Some<" + this.t + ">";
        }

        public final T getT() {
            return this.t;
        }

        public Some(T t) {
            super(null);
            this.t = t;
        }
    }
}

