/*
 * Decompiled with CFR 0.152.
 */
package fj.parser;

import fj.Digit;
import fj.F;
import fj.F0;
import fj.P;
import fj.Semigroup;
import fj.Unit;
import fj.data.List;
import fj.data.Stream;
import fj.data.Validation;
import fj.parser.Result;

public final class Parser<I, A, E> {
    private final F<I, Validation<E, Result<I, A>>> f;

    private Parser(F<I, Validation<E, Result<I, A>>> f) {
        this.f = f;
    }

    public Validation<E, Result<I, A>> parse(I i) {
        return this.f.f(i);
    }

    public <Z> Parser<Z, A, E> xmap(F<I, Z> f, F<Z, I> g) {
        return Parser.parser(z -> this.parse(g.f(z)).map((T r) -> r.mapRest(f)));
    }

    public <B> Parser<I, B, E> map(F<A, B> f) {
        return Parser.parser(i -> this.parse(i).map((T r) -> r.mapValue(f)));
    }

    public Parser<I, A, E> filter(F<A, Boolean> f, E e) {
        return Parser.parser(i -> this.parse(i).bind((T r) -> {
            Object v = r.value();
            return (Boolean)f.f(v) != false ? Validation.success(Result.result(r.rest(), v)) : Validation.fail(e);
        }));
    }

    public <B> Parser<I, B, E> bind(F<A, Parser<I, B, E>> f) {
        return Parser.parser(i -> this.parse(i).bind((T r) -> ((Parser)f.f(r.value())).parse(r.rest())));
    }

    public <B, C> Parser<I, C, E> bind(Parser<I, B, E> pb, F<A, F<B, C>> f) {
        return pb.apply(this.map(f));
    }

    public <B, C, D> Parser<I, D, E> bind(Parser<I, B, E> pb, Parser<I, C, E> pc, F<A, F<B, F<C, D>>> f) {
        return pc.apply(this.bind(pb, f));
    }

    public <B, C, D, E$> Parser<I, E$, E> bind(Parser<I, B, E> pb, Parser<I, C, E> pc, Parser<I, D, E> pd, F<A, F<B, F<C, F<D, E$>>>> f) {
        return pd.apply(this.bind(pb, pc, f));
    }

    public <B, C, D, E$, F$> Parser<I, F$, E> bind(Parser<I, B, E> pb, Parser<I, C, E> pc, Parser<I, D, E> pd, Parser<I, E$, E> pe, F<A, F<B, F<C, F<D, F<E$, F$>>>>> f) {
        return pe.apply(this.bind(pb, pc, pd, f));
    }

    public <B, C, D, E$, F$, G> Parser<I, G, E> bind(Parser<I, B, E> pb, Parser<I, C, E> pc, Parser<I, D, E> pd, Parser<I, E$, E> pe, Parser<I, F$, E> pf, F<A, F<B, F<C, F<D, F<E$, F<F$, G>>>>>> f) {
        return pf.apply(this.bind(pb, pc, pd, pe, f));
    }

    public <B, C, D, E$, F$, G, H> Parser<I, H, E> bind(Parser<I, B, E> pb, Parser<I, C, E> pc, Parser<I, D, E> pd, Parser<I, E$, E> pe, Parser<I, F$, E> pf, Parser<I, G, E> pg, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, H>>>>>>> f) {
        return pg.apply(this.bind(pb, pc, pd, pe, pf, f));
    }

    public <B, C, D, E$, F$, G, H, I$> Parser<I, I$, E> bind(Parser<I, B, E> pb, Parser<I, C, E> pc, Parser<I, D, E> pd, Parser<I, E$, E> pe, Parser<I, F$, E> pf, Parser<I, G, E> pg, Parser<I, H, E> ph, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, F<H, I$>>>>>>>> f) {
        return ph.apply(this.bind(pb, pc, pd, pe, pf, pg, f));
    }

    public <B> Parser<I, B, E> sequence(Parser<I, B, E> p) {
        return this.bind(a -> p);
    }

    public <B> Parser<I, B, E> apply(Parser<I, F<A, B>, E> p) {
        return p.bind(this::map);
    }

    public Parser<I, A, E> or(F0<Parser<I, A, E>> alt) {
        return Parser.parser(i -> this.parse(i).f().sequence(((Parser)alt.f()).parse(i)));
    }

    public Parser<I, A, E> or(Parser<I, A, E> alt) {
        return this.or(P.p(alt));
    }

    public Parser<I, A, E> or(F0<Parser<I, A, E>> alt, Semigroup<E> s) {
        return Parser.parser(i -> this.parse(i).f().bind((E e) -> ((Parser)alt.f()).parse(i).f().map(s.sum(e))));
    }

    public Parser<I, A, E> or(Parser<I, A, E> alt, Semigroup<E> s) {
        return this.or(P.p(alt), s);
    }

    public Parser<I, Unit, E> not(F0<E> e) {
        return Parser.parser(i -> this.parse(i).isFail() ? Validation.success(Result.result(i, Unit.unit())) : Validation.fail(e.f()));
    }

    public Parser<I, Unit, E> not(E e) {
        return this.not((E)P.p(e));
    }

    public Parser<I, Stream<A>, E> repeat() {
        return this.repeat1().or(() -> Parser.value(Stream.nil()));
    }

    public Parser<I, Stream<A>, E> repeat1() {
        return this.bind(a -> this.repeat().map(as -> as.cons(a)));
    }

    public <K> Parser<I, A, K> mapError(F<E, K> f) {
        return Parser.parser(i -> this.f.f(i).f().map(f));
    }

    public static <I, A, E> Parser<I, A, E> parser(F<I, Validation<E, Result<I, A>>> f) {
        return new Parser<I, A, E>(f);
    }

    public static <I, A, E> Parser<I, A, E> value(A a) {
        return Parser.parser(i -> Validation.success(Result.result(i, a)));
    }

    public static <I, A, E> Parser<I, A, E> fail(E e) {
        return Parser.parser(i -> Validation.fail(e));
    }

    public static <I, A, E> Parser<I, List<A>, E> sequence(List<Parser<I, A, E>> ps) {
        return ps.isEmpty() ? Parser.value(List.nil()) : ps.head().bind(a -> Parser.sequence(ps.tail()).map(List.cons_(a)));
    }

    public static final class CharsParser {
        private CharsParser() {
        }

        public static <E> Parser<Stream<Character>, Character, E> character(F0<E> e) {
            return StreamParser.element(e);
        }

        public static <E> Parser<Stream<Character>, Character, E> character(E e) {
            return CharsParser.character(P.p(e));
        }

        public static <E> Parser<Stream<Character>, Character, E> character(F0<E> missing, F<Character, E> sat, char c) {
            return StreamParser.satisfy(missing, sat, x -> x.charValue() == c);
        }

        public static <E> Parser<Stream<Character>, Character, E> character(E missing, F<Character, E> sat, char c) {
            return CharsParser.character(P.p(missing), sat, c);
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(F0<E> missing, int n) {
            return n <= 0 ? Parser.value(Stream.nil()) : CharsParser.character(missing).bind(CharsParser.characters(missing, n - 1), Stream.cons_());
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(E missing, int n) {
            return CharsParser.characters(P.p(missing), n);
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(F0<E> missing, F<Character, E> sat, Stream<Character> cs) {
            return cs.isEmpty() ? Parser.value(Stream.nil()) : CharsParser.character(missing, sat, cs.head().charValue()).bind(CharsParser.characters(missing, sat, cs.tail()._1()), Stream.cons_());
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(E missing, F<Character, E> sat, Stream<Character> cs) {
            return CharsParser.characters(P.p(missing), sat, cs);
        }

        public static <E> Parser<Stream<Character>, String, E> string(F0<E> missing, F<Character, E> sat, String s) {
            return CharsParser.characters(missing, sat, List.fromString(s).toStream()).map(cs -> List.asString(cs.toList()));
        }

        public static <E> Parser<Stream<Character>, String, E> string(E missing, F<Character, E> sat, String s) {
            return CharsParser.string(P.p(missing), sat, s);
        }

        public static <E> Parser<Stream<Character>, Digit, E> digit(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isDigit).map(c1 -> Digit.fromChar(c1.charValue()).some());
        }

        public static <E> Parser<Stream<Character>, Digit, E> digit(E missing, F<Character, E> sat) {
            return CharsParser.digit(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> lower(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isLowerCase);
        }

        public static <E> Parser<Stream<Character>, Character, E> lower(E missing, F<Character, E> sat) {
            return CharsParser.lower(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> upper(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isUpperCase);
        }

        public static <E> Parser<Stream<Character>, Character, E> upper(E missing, F<Character, E> sat) {
            return CharsParser.upper(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> defined(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isDefined);
        }

        public static <E> Parser<Stream<Character>, Character, E> defined(E missing, F<Character, E> sat) {
            return CharsParser.defined(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> highSurrogate(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isHighSurrogate);
        }

        public static <E> Parser<Stream<Character>, Character, E> highSurrogate(E missing, F<Character, E> sat) {
            return CharsParser.highSurrogate(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> identifierIgnorable(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isIdentifierIgnorable);
        }

        public static <E> Parser<Stream<Character>, Character, E> identifierIgnorable(E missing, F<Character, E> sat) {
            return CharsParser.identifierIgnorable(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> isoControl(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isISOControl);
        }

        public static <E> Parser<Stream<Character>, Character, E> isoControl(E missing, F<Character, E> sat) {
            return CharsParser.isoControl(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierPart(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isJavaIdentifierPart);
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierPart(E missing, F<Character, E> sat) {
            return CharsParser.javaIdentifierPart(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierStart(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isJavaIdentifierStart);
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierStart(E missing, F<Character, E> sat) {
            return CharsParser.javaIdentifierStart(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> alpha(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isLetter);
        }

        public static <E> Parser<Stream<Character>, Character, E> alpha(E missing, F<Character, E> sat) {
            return CharsParser.alpha(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> alphaNum(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isLetterOrDigit);
        }

        public static <E> Parser<Stream<Character>, Character, E> alphaNum(E missing, F<Character, E> sat) {
            return CharsParser.alphaNum(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> lowSurrogate(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isLowSurrogate);
        }

        public static <E> Parser<Stream<Character>, Character, E> lowSurrogate(E missing, F<Character, E> sat) {
            return CharsParser.lowSurrogate(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> mirrored(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isMirrored);
        }

        public static <E> Parser<Stream<Character>, Character, E> mirrored(E missing, F<Character, E> sat) {
            return CharsParser.mirrored(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> space(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isSpaceChar);
        }

        public static <E> Parser<Stream<Character>, Character, E> space(E missing, F<Character, E> sat) {
            return CharsParser.space(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> titleCase(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isTitleCase);
        }

        public static <E> Parser<Stream<Character>, Character, E> titleCase(E missing, F<Character, E> sat) {
            return CharsParser.titleCase(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferPart(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isUnicodeIdentifierPart);
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferPart(E missing, F<Character, E> sat) {
            return CharsParser.unicodeIdentiferPart(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferStart(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isUnicodeIdentifierStart);
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferStart(E missing, F<Character, E> sat) {
            return CharsParser.unicodeIdentiferStart(P.p(missing), sat);
        }

        public static <E> Parser<Stream<Character>, Character, E> whitespace(F0<E> missing, F<Character, E> sat) {
            return StreamParser.satisfy(missing, sat, Character::isWhitespace);
        }

        public static <E> Parser<Stream<Character>, Character, E> whitespace(E missing, F<Character, E> sat) {
            return CharsParser.whitespace(P.p(missing), sat);
        }
    }

    public static final class StreamParser {
        private StreamParser() {
        }

        public static <I, E> Parser<Stream<I>, I, E> element(F0<E> e) {
            return Parser.parser(is -> is.isEmpty() ? Validation.fail(e.f()) : Validation.success(Result.result(is.tail()._1(), is.head())));
        }

        public static <I, E> Parser<Stream<I>, I, E> element(E e) {
            return StreamParser.element(P.p(e));
        }

        public static <I, E> Parser<Stream<I>, I, E> satisfy(F0<E> missing, F<I, E> sat, F<I, Boolean> f) {
            return StreamParser.element(missing).bind(x -> (Boolean)f.f(x) != false ? Parser.value(x) : Parser.fail(sat.f(x)));
        }

        public static <I, E> Parser<Stream<I>, I, E> satisfy(E missing, F<I, E> sat, F<I, Boolean> f) {
            return StreamParser.satisfy(P.p(missing), sat, f);
        }
    }
}

