/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.F;
import fj.Function;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Option;
import fj.data.Stream;
import fj.data.fingertrees.Empty;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.Four;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.Node;
import fj.data.fingertrees.One;
import fj.data.fingertrees.Three;
import fj.data.fingertrees.Two;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;

public abstract class Digit<V, A> {
    private final Measured<V, A> m;

    public abstract <B> B foldRight(F<A, F<B, B>> var1, B var2);

    public abstract <B> B foldLeft(F<B, F<A, B>> var1, B var2);

    public final A reduceRight(F<A, F<A, A>> f) {
        return (A)this.match(One::value, two -> {
            V2 v = two.values();
            return ((F)f.f(v._1())).f(v._2());
        }, three -> {
            V3 v = three.values();
            return ((F)f.f(v._1())).f(((F)f.f(v._2())).f(v._3()));
        }, four -> {
            V4 v = four.values();
            return ((F)f.f(v._1())).f(((F)f.f(v._2())).f(((F)f.f(v._3())).f(v._4())));
        });
    }

    public final A reduceLeft(F<A, F<A, A>> f) {
        return (A)this.match(One::value, two -> {
            V2 v = two.values();
            return ((F)f.f(v._1())).f(v._2());
        }, three -> {
            V3 v = three.values();
            return ((F)f.f(((F)f.f(v._1())).f(v._2()))).f(v._3());
        }, four -> {
            V4 v = four.values();
            return ((F)f.f(((F)f.f(((F)f.f(v._1())).f(v._2()))).f(v._3()))).f(v._4());
        });
    }

    public final <B> Digit<V, B> map(F<A, B> f, Measured<V, B> m) {
        return this.match(one -> new One(m, f.f(one.value())), two -> new Two(m, two.values().map(f)), three -> new Three(m, three.values().map(f)), four -> new Four(m, four.values().map(f)));
    }

    public abstract <B> B match(F<One<V, A>, B> var1, F<Two<V, A>, B> var2, F<Three<V, A>, B> var3, F<Four<V, A>, B> var4);

    Digit(Measured<V, A> m) {
        this.m = m;
    }

    final Measured<V, A> measured() {
        return this.m;
    }

    public final V measure() {
        return (V)this.foldLeft(Function.curry((v, a) -> this.m.sum(v, this.m.measure(a))), this.m.zero());
    }

    public final FingerTree<V, A> toTree() {
        MakeTree mk = FingerTree.mkTree(this.m);
        return this.match(one -> mk.single(one.value()), two -> mk.deep(mk.one(two.values()._1()), new Empty<V, Node<V, A>>(this.m.nodeMeasured()), mk.one(two.values()._2())), three -> mk.deep(mk.two(three.values()._1(), three.values()._2()), new Empty<V, Node<V, A>>(this.m.nodeMeasured()), mk.one(three.values()._3())), four -> mk.deep(mk.two(four.values()._1(), four.values()._2()), new Empty<V, Node<V, A>>(this.m.nodeMeasured()), mk.two(four.values()._3(), four.values()._4())));
    }

    final Option<Digit<V, A>> tail() {
        return this.match(one -> Option.none(), two -> Option.some(FingerTree.mkTree(this.m).one(two.values()._2())), three -> Option.some(FingerTree.mkTree(this.m).two(three.values()._2(), three.values()._3())), four -> Option.some(FingerTree.mkTree(this.m).three(four.values()._2(), four.values()._3(), four.values()._4())));
    }

    final Option<Digit<V, A>> init() {
        return this.match(one -> Option.none(), two -> Option.some(FingerTree.mkTree(this.m).one(two.values()._1())), three -> Option.some(FingerTree.mkTree(this.m).two(three.values()._1(), three.values()._2())), four -> Option.some(FingerTree.mkTree(this.m).three(four.values()._1(), four.values()._2(), four.values()._3())));
    }

    abstract P3<Option<Digit<V, A>>, A, Option<Digit<V, A>>> split1(F<V, Boolean> var1, V var2);

    public abstract P2<Integer, A> lookup(F<V, Integer> var1, int var2);

    public abstract int length();

    public String toString() {
        return Show.digitShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    public abstract Stream<A> toStream();
}

