/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.P;
import fj.control.Trampoline;
import fj.data.List;
import java.util.Iterator;

public final class DList<A> {
    private final F<List<A>, Trampoline<List<A>>> appendFn;

    private DList(F<List<A>, Trampoline<List<A>>> appendFn) {
        this.appendFn = appendFn;
    }

    public static <A> DList<A> dlist(F<List<A>, Trampoline<List<A>>> f) {
        return new DList<A>(f);
    }

    public static <A> DList<A> listDList(List<A> a) {
        return DList.dlist(tail -> Trampoline.pure(a.append((List)tail)));
    }

    public static <A> DList<A> iterableDList(Iterable<A> it) {
        return DList.listDList(List.iterableList(it));
    }

    public static <A> DList<A> iteratorDList(Iterator<A> it) {
        return DList.iterableDList(() -> it);
    }

    @SafeVarargs
    public static <A> DList<A> arrayDList(A ... as) {
        return DList.listDList(List.list(as));
    }

    public List<A> run() {
        return this.appendFn.f(List.nil()).run();
    }

    public java.util.List<A> toJavaList() {
        return this.run().toJavaList();
    }

    public static <A> DList<A> nil() {
        return new DList<A>(Trampoline.pure());
    }

    public static <A> DList<A> single(A a) {
        return new DList<A>(tail -> Trampoline.pure(tail.cons(a)));
    }

    public DList<A> cons(A a) {
        return DList.single(a).append(this);
    }

    public DList<A> snoc(A a) {
        return this.append(DList.single(a));
    }

    public DList<A> append(DList<A> other) {
        return new DList<A>(DList.kleisliTrampCompose(this.appendFn, other.appendFn));
    }

    private static <A, B, C> F<A, Trampoline<C>> kleisliTrampCompose(F<B, Trampoline<C>> bc, F<A, Trampoline<B>> ab) {
        return a -> ((Trampoline)ab.f(a)).bind(b -> Trampoline.suspend(P.lazy(() -> (Trampoline)bc.f(b))));
    }
}

