/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.control.parallel.Actor;
import fj.control.parallel.Callables;
import fj.control.parallel.Strategy;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Effect1;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class Promise<A> {
    private final Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> actor;
    private final Strategy<Unit> s;
    private final CountDownLatch l = new CountDownLatch(1);
    private volatile Option<A> v = Option.none();
    private final Queue<Actor<A>> waiting = new LinkedList<Actor<A>>();

    private Promise(Strategy<Unit> s, Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> qa) {
        this.s = s;
        this.actor = qa;
    }

    private static <A> Promise<A> mkPromise(Strategy<Unit> s) {
        Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> q = Actor.queueActor(s, new Effect1<P2<Either<P1<A>, Actor<A>>, Promise<A>>>(){

            @Override
            public void f(P2<Either<P1<A>, Actor<A>>, Promise<A>> p) {
                Promise snd = p._2();
                Queue as = snd.waiting;
                if (p._1().isLeft()) {
                    Object a = p._1().left().value()._1();
                    snd.v = Option.some(a);
                    snd.l.countDown();
                    while (!as.isEmpty()) {
                        ((Actor)as.remove()).act(a);
                    }
                } else if (snd.v.isNone()) {
                    as.add(p._1().right().value());
                } else {
                    p._1().right().value().act(snd.v.some());
                }
            }
        });
        return new Promise<A>(s, q);
    }

    public static <A> Promise<A> promise(Strategy<Unit> s, P1<A> a) {
        Promise<A> p = Promise.mkPromise(s);
        p.actor.act(P.p(Either.left(a), p));
        return p;
    }

    public static <A> F<P1<A>, Promise<A>> promise(Strategy<Unit> s) {
        return a -> Promise.promise(s, a);
    }

    public static <A> Promise<Callable<A>> promise(Strategy<Unit> s, Callable<A> a) {
        return Promise.promise(s, P.lazy(() -> Callables.normalise(a)));
    }

    public static <A, B> F<A, Promise<B>> promise(Strategy<Unit> s, F<A, B> f) {
        return a -> Promise.promise(s, P1.curry(f).f(a));
    }

    public void to(Actor<A> a) {
        this.actor.act(P.p(Either.right(a), this));
    }

    public <B> Promise<B> fmap(F<A, B> f) {
        return this.bind(Promise.promise(this.s, f));
    }

    public static <A, B> F<Promise<A>, Promise<B>> fmap_(F<A, B> f) {
        return a -> a.fmap(f);
    }

    public static <A> Promise<A> join(Promise<Promise<A>> p) {
        F id = Function.identity();
        return p.bind(id);
    }

    public static <A> Promise<A> join(Strategy<Unit> s, P1<Promise<A>> p) {
        return Promise.join(Promise.promise(s, p));
    }

    public <B> Promise<B> bind(F<A, Promise<B>> f) {
        final Promise<A> r = Promise.mkPromise(this.s);
        Actor ab = Actor.actor(this.s, new Effect1<B>(){

            @Override
            public void f(B b) {
                r.actor.act(P.p(Either.left(P.p(b)), r));
            }
        });
        this.to(ab.promise().contramap(f));
        return r;
    }

    public <B> Promise<B> apply(Promise<F<A, B>> pf) {
        return pf.bind(this::fmap);
    }

    public <B, C> Promise<C> bind(Promise<B> pb, F<A, F<B, C>> f) {
        return pb.apply(this.fmap(f));
    }

    public <B, C> Promise<C> bind(P1<Promise<B>> p, F<A, F<B, C>> f) {
        return Promise.join(this.s, p).apply(this.fmap(f));
    }

    public static <A, B, C> F<Promise<A>, F<Promise<B>, Promise<C>>> liftM2(F<A, F<B, C>> f) {
        return Function.curry((ca, cb) -> ca.bind((Promise)cb, f));
    }

    public static <A> Promise<List<A>> sequence(Strategy<Unit> s, List<Promise<A>> as) {
        return Promise.join(Promise.foldRight(s, Promise.liftM2(List.cons()), Promise.promise(s, P.p(List.nil()))).f(as));
    }

    public static <A> F<List<Promise<A>>, Promise<List<A>>> sequence(Strategy<Unit> s) {
        return as -> Promise.sequence(s, as);
    }

    public static <A> Promise<Stream<A>> sequence(Strategy<Unit> s, Stream<Promise<A>> as) {
        return Promise.join(Promise.foldRightS(s, Function.curry((o, p) -> o.bind(a -> ((Promise)p._1()).fmap(Stream.cons_().f(a)))), Promise.promise(s, P.p(Stream.nil()))).f(as));
    }

    public static <A> F<List<Promise<A>>, Promise<List<A>>> sequenceS(Strategy<Unit> s) {
        return as -> Promise.sequence(s, as);
    }

    public static <A> Promise<P1<A>> sequence(Strategy<Unit> s, P1<Promise<A>> p) {
        return Promise.join(Promise.promise(s, p)).fmap(P.p1());
    }

    public static <A, B> F<List<A>, Promise<B>> foldRight(final Strategy<Unit> s, final F<A, F<B, B>> f, final B b) {
        return new F<List<A>, Promise<B>>(){

            @Override
            public Promise<B> f(List<A> as) {
                return as.isEmpty() ? Promise.promise((Strategy<Unit>)s, P.p(b)) : Promise.liftM2(f).f(Promise.promise((Strategy<Unit>)s, P.p(as.head()))).f(Promise.join(s, P1.curry(this).f(as.tail())));
            }
        };
    }

    public static <A, B> F<Stream<A>, Promise<B>> foldRightS(final Strategy<Unit> s, final F<A, F<P1<B>, B>> f, final B b) {
        return new F<Stream<A>, Promise<B>>(){

            @Override
            public Promise<B> f(Stream<A> as) {
                return as.isEmpty() ? Promise.promise((Strategy<Unit>)s, P.p(b)) : Promise.liftM2(f).f(Promise.promise((Strategy<Unit>)s, P.p(as.head()))).f(Promise.join(s, P.lazy(() -> this.f(as.tail()._1()).fmap(P.p1()))));
            }
        };
    }

    public A claim() {
        try {
            this.l.await();
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        return this.v.some();
    }

    public Option<A> claim(long timeout, TimeUnit unit) {
        try {
            if (this.l.await(timeout, unit)) {
                return this.v;
            }
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        return Option.none();
    }

    public boolean isFulfilled() {
        return this.v.isSome();
    }

    public <B> Promise<B> cobind(F<Promise<A>, B> f) {
        return Promise.promise(this.s, P.lazy(() -> f.f(this)));
    }

    public Promise<Promise<A>> cojoin() {
        F id = Function.identity();
        return this.cobind(id);
    }

    public <B> Stream<B> sequenceW(Stream<F<Promise<A>, B>> fs) {
        return fs.isEmpty() ? Stream.nil() : Stream.cons(fs.head().f(this), () -> this.sequenceW(fs.tail()._1()));
    }
}

