/*
 * Decompiled with CFR 0.152.
 */
package fj.control;

import fj.Bottom;
import fj.F;
import fj.F1Functions;
import fj.F2;
import fj.F2Functions;
import fj.Function;
import fj.P;
import fj.P1;
import fj.data.Either;
import java.util.Iterator;

public abstract class Trampoline<A> {
    private static <A, B> Codense<B> codense(Normal<A> a, F<A, Trampoline<B>> k) {
        return new Codense(a, k);
    }

    public static <A> F<A, Trampoline<A>> pure() {
        return Trampoline::pure;
    }

    public static <A> Trampoline<A> pure(A a) {
        return new Pure(a);
    }

    public static <A> Trampoline<A> suspend(P1<Trampoline<A>> a) {
        return new Suspend(a);
    }

    public static <A> F<P1<Trampoline<A>>, Trampoline<A>> suspend_() {
        return Trampoline::suspend;
    }

    protected abstract <R> R fold(F<Normal<A>, R> var1, F<Codense<A>, R> var2);

    public abstract <B> Trampoline<B> bind(F<A, Trampoline<B>> var1);

    public final <B> Trampoline<B> map(F<A, B> f) {
        return this.bind(F1Functions.o(Trampoline.pure(), f));
    }

    public static <A, B> F<F<A, Trampoline<B>>, F<Trampoline<A>, Trampoline<B>>> bind_() {
        return f -> a -> a.bind((F)f);
    }

    public static <A, B> F<F<A, B>, F<Trampoline<A>, Trampoline<B>>> map_() {
        return f -> a -> a.map((F)f);
    }

    public static <A> F<Trampoline<A>, Either<P1<Trampoline<A>>, A>> resume_() {
        return Trampoline::resume;
    }

    public abstract Either<P1<Trampoline<A>>, A> resume();

    public final A run() {
        Either<P1<Trampoline<A>>, A> x;
        Iterator<P1<Trampoline<A>>> iterator;
        Trampoline<A> current = this;
        do {
            x = current.resume();
            iterator = x.left().iterator();
            while (iterator.hasNext()) {
                P1<Trampoline<A>> t = iterator.next();
                current = t._1();
            }
        } while (!(iterator = x.right().iterator()).hasNext());
        P1<Trampoline<A>> a = iterator.next();
        return (A)a;
    }

    public final <B> Trampoline<B> apply(Trampoline<F<A, B>> lf) {
        return lf.bind(this::map);
    }

    public final <B, C> Trampoline<C> bind(Trampoline<B> lb, F<A, F<B, C>> f) {
        return lb.apply(this.map(f));
    }

    public static <A, B, C> F<Trampoline<A>, F<Trampoline<B>, Trampoline<C>>> liftM2(F<A, F<B, C>> f) {
        return Function.curry((as, bs) -> as.bind((Trampoline)bs, f));
    }

    public final <B, C> Trampoline<C> zipWith(Trampoline<B> b, F2<A, B, C> f) {
        Iterator<P1<Trampoline<B>>> iterator;
        Either<P1<Trampoline<A>>, A> ea = this.resume();
        Either<P1<Trampoline<B>>, B> eb = b.resume();
        for (P1<Trampoline<Trampoline>> x : ea.left()) {
            iterator = eb.left().iterator();
            if (iterator.hasNext()) {
                P1<Trampoline<B>> y = iterator.next();
                return Trampoline.suspend(x.bind(y, F2Functions.curry((ta, tb) -> Trampoline.suspend(P.lazy(() -> ta.zipWith((Trampoline)tb, f))))));
            }
            iterator = eb.right().iterator();
            if (!iterator.hasNext()) continue;
            P1 y = iterator.next();
            return Trampoline.suspend(x.map(ta -> ta.map(F2Functions.f(F2Functions.flip(f), y))));
        }
        for (P1<Trampoline<Trampoline>> x : ea.right()) {
            iterator = eb.right().iterator();
            if (iterator.hasNext()) {
                P1 y = iterator.next();
                return Trampoline.suspend(P.lazy(() -> Trampoline.pure(f.f(x, y))));
            }
            iterator = eb.left().iterator();
            if (!iterator.hasNext()) continue;
            P1<Trampoline<Trampoline<C>>> y = iterator.next();
            return Trampoline.suspend(y.map(Trampoline.liftM2(F2Functions.curry(f)).f(Trampoline.pure(x))));
        }
        throw Bottom.error("Match error: Trampoline is neither done nor suspended.");
    }

    private static final class Pure<A>
    extends Normal<A> {
        private final A value;

        private Pure(A a) {
            this.value = a;
        }

        @Override
        public <R> R foldNormal(F<A, R> pure, F<P1<Trampoline<A>>, R> k) {
            return pure.f(this.value);
        }

        @Override
        public <R> R fold(F<Normal<A>, R> n, F<Codense<A>, R> gs) {
            return n.f(this);
        }

        @Override
        public Either<P1<Trampoline<A>>, A> resume() {
            return Either.right(this.value);
        }
    }

    private static final class Suspend<A>
    extends Normal<A> {
        private final P1<Trampoline<A>> suspension;

        private Suspend(P1<Trampoline<A>> s) {
            this.suspension = s;
        }

        @Override
        public <R> R foldNormal(F<A, R> pure, F<P1<Trampoline<A>>, R> k) {
            return k.f(this.suspension);
        }

        @Override
        public <R> R fold(F<Normal<A>, R> n, F<Codense<A>, R> gs) {
            return n.f(this);
        }

        @Override
        public Either<P1<Trampoline<A>>, A> resume() {
            return Either.left(this.suspension);
        }
    }

    private static final class Codense<A>
    extends Trampoline<A> {
        private final Normal<Object> sub;
        private final F<Object, Trampoline<A>> cont;

        private Codense(Normal<Object> t, F<Object, Trampoline<A>> k) {
            this.sub = t;
            this.cont = k;
        }

        @Override
        public <R> R fold(F<Normal<A>, R> n, F<Codense<A>, R> gs) {
            return gs.f(this);
        }

        @Override
        public <B> Trampoline<B> bind(F<A, Trampoline<B>> f) {
            return Trampoline.codense(this.sub, o -> Codense.suspend(P.lazy(() -> this.cont.f(o).bind(f))));
        }

        @Override
        public Either<P1<Trampoline<A>>, A> resume() {
            return Either.left(this.sub.resume().either(p -> p.map(ot -> ot.fold(o -> o.foldNormal(this.cont, t -> ((Trampoline)t._1()).bind(this.cont)), c -> Trampoline.codense(c.sub, o -> c.cont.f(o).bind(this.cont)))), o -> P.lazy(() -> this.cont.f(o))));
        }
    }

    private static abstract class Normal<A>
    extends Trampoline<A> {
        private Normal() {
        }

        public abstract <R> R foldNormal(F<A, R> var1, F<P1<Trampoline<A>>, R> var2);

        @Override
        public final <B> Trampoline<B> bind(F<A, Trampoline<B>> f) {
            return Trampoline.codense(this, f);
        }
    }
}

