/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F0;
import fj.F2;
import fj.F3;
import fj.F4;
import fj.F5;
import fj.F6;
import fj.F7;
import fj.F8;
import fj.Function;
import fj.Hash;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Semigroup;
import fj.Show;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Effect1;
import java.util.Iterator;

public class Validation<E, T>
implements Iterable<T> {
    private final Either<E, T> e;
    public static final F<String, Validation<NumberFormatException, Byte>> parseByte = Validation::parseByte;
    public static final F<String, Validation<NumberFormatException, Double>> parseDouble = Validation::parseDouble;
    public static final F<String, Validation<NumberFormatException, Float>> parseFloat = Validation::parseFloat;
    public static final F<String, Validation<NumberFormatException, Integer>> parseInt = Validation::parseInt;
    public static final F<String, Validation<NumberFormatException, Long>> parseLong = Validation::parseLong;
    public static final F<String, Validation<NumberFormatException, Short>> parseShort = Validation::parseShort;

    protected Validation(Either<E, T> e) {
        this.e = e;
    }

    public final boolean isFail() {
        return this.e.isLeft();
    }

    public final boolean isSuccess() {
        return this.e.isRight();
    }

    public final E fail() {
        if (this.isFail()) {
            return this.e.left().value();
        }
        throw Bottom.error("Validation: fail on success value");
    }

    public final T success() {
        if (this.isSuccess()) {
            return this.e.right().value();
        }
        throw Bottom.error("Validation: success on fail value");
    }

    public final <X> X validation(F<E, X> fail, F<T, X> success) {
        return this.e.either(fail, success);
    }

    public final FailProjection<E, T> f() {
        return new FailProjection(this);
    }

    public final Either<E, T> toEither() {
        return this.e;
    }

    public final T successE(F0<String> err) {
        return this.e.right().valueE(err);
    }

    public final T successE(String err) {
        return this.e.right().valueE(P.p(err));
    }

    public final T orSuccess(F0<T> t) {
        return this.e.right().orValue(t);
    }

    public final T orSuccess(T t) {
        return this.e.right().orValue(P.p(t));
    }

    public final T on(F<E, T> f) {
        return this.e.right().on(f);
    }

    public final Unit foreach(F<T, Unit> f) {
        return this.e.right().foreach(f);
    }

    public final void foreachDoEffect(Effect1<T> f) {
        this.e.right().foreachDoEffect(f);
    }

    public final <A> Validation<E, A> map(F<T, A> f) {
        return this.isFail() ? Validation.fail(this.fail()) : Validation.success(f.f(this.success()));
    }

    public final <A> Validation<E, A> bind(F<T, Validation<E, A>> f) {
        return this.isSuccess() ? f.f(this.success()) : Validation.fail(this.fail());
    }

    public final <A> Validation<E, A> sequence(Validation<E, A> v) {
        return this.bind(Function.constant(v));
    }

    public static <E, A> Validation<E, List<A>> sequence(Semigroup<E> s, List<Validation<E, A>> list) {
        if (list.exists(Validation::isFail)) {
            return Validation.fail(list.filter(Validation::isFail).map((A v) -> v.fail()).foldLeft1(s::sum));
        }
        return Validation.success(list.foldLeft((acc, v) -> acc.cons(v.success()), List.nil()).reverse());
    }

    public final <A> Option<Validation<A, T>> filter(F<T, Boolean> f) {
        return this.e.right().filter(f).map(Validation.validation());
    }

    public final <A> Validation<E, A> apply(Validation<E, F<T, A>> v) {
        return v.bind(this::map);
    }

    public final boolean forall(F<T, Boolean> f) {
        return this.e.right().forall(f);
    }

    public final boolean exists(F<T, Boolean> f) {
        return this.e.right().exists(f);
    }

    public final boolean equals(Object other) {
        return Equal.equals0(Validation.class, this, other, () -> Equal.validationEqual(Equal.anyEqual(), Equal.anyEqual()));
    }

    public final int hashCode() {
        return Hash.validationHash(Hash.anyHash(), Hash.anyHash()).hash(this);
    }

    public final List<T> toList() {
        return this.e.right().toList();
    }

    public final Option<T> toOption() {
        return this.e.right().toOption();
    }

    public final Array<T> toArray() {
        return this.e.right().toArray();
    }

    public final Stream<T> toStream() {
        return this.e.right().toStream();
    }

    public final <A> Validation<E, A> accumapply(Semigroup<E> s, Validation<E, F<T, A>> v) {
        return this.isFail() ? Validation.fail(v.isFail() ? s.sum(v.fail(), this.fail()) : this.fail()) : (v.isFail() ? Validation.fail(v.fail()) : Validation.success(v.success().f(this.success())));
    }

    public final <A, B> Validation<E, B> accumulate(Semigroup<E> s, Validation<E, A> va, F<T, F<A, B>> f) {
        return va.accumapply(s, this.map(f));
    }

    public final <A, B> Validation<E, B> accumulate(Semigroup<E> s, Validation<E, A> va, F2<T, A, B> f) {
        return va.accumapply(s, this.map(Function.curry(f)));
    }

    public final <A> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va) {
        return this.accumulate(s, va, (T t, A a) -> Unit.unit()).f().toOption();
    }

    public final <A, B, C> Validation<E, C> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, F<T, F<A, F<B, C>>> f) {
        return vb.accumapply(s, this.accumulate(s, va, f));
    }

    public final <A, B, C> Validation<E, C> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, F3<T, A, B, C> f) {
        return vb.accumapply(s, this.accumulate(s, va, Function.curry(f)));
    }

    public final <A, B> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb) {
        return this.accumulate(s, va, vb, (T t, A a, B b) -> Unit.unit()).f().toOption();
    }

    public final <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, F<T, F<A, F<B, F<C, D>>>> f) {
        return vc.accumapply(s, this.accumulate(s, va, vb, f));
    }

    public final <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, F4<T, A, B, C, D> f) {
        return vc.accumapply(s, this.accumulate(s, va, vb, Function.curry(f)));
    }

    public final <A, B, C> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc) {
        return this.accumulate(s, va, vb, vc, (T t, A a, B b, C c) -> Unit.unit()).f().toOption();
    }

    public final <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, F<T, F<A, F<B, F<C, F<D, E$>>>>> f) {
        return vd.accumapply(s, this.accumulate(s, va, vb, vc, f));
    }

    public final <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, F5<T, A, B, C, D, E$> f) {
        return vd.accumapply(s, this.accumulate(s, va, vb, vc, Function.curry(f)));
    }

    public final <A, B, C, D> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd) {
        return this.accumulate(s, va, vb, vc, vd, (T t, A a, B b, C c, D d) -> Unit.unit()).f().toOption();
    }

    public final <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, F<T, F<A, F<B, F<C, F<D, F<E$, F$>>>>>> f) {
        return ve.accumapply(s, this.accumulate(s, va, vb, vc, vd, f));
    }

    public final <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, F6<T, A, B, C, D, E$, F$> f) {
        return ve.accumapply(s, this.accumulate(s, va, vb, vc, vd, Function.curry(f)));
    }

    public final <A, B, C, D, E$> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve) {
        return this.accumulate(s, va, vb, vc, vd, ve, (T t, A a, B b, C c, D d, E$ e1) -> Unit.unit()).f().toOption();
    }

    public final <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, G>>>>>>> f) {
        return vf.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, f));
    }

    public final <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, F7<T, A, B, C, D, E$, F$, G> f) {
        return vf.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, Function.curry(f)));
    }

    public final <A, B, C, D, E$, F$> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf) {
        return this.accumulate(s, va, vb, vc, vd, ve, vf, (T t, A a, B b, C c, D d, E$ e1, F$ f) -> Unit.unit()).f().toOption();
    }

    public final <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, H>>>>>>>> f) {
        return vg.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, vf, f));
    }

    public final <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg, F8<T, A, B, C, D, E$, F$, G, H> f) {
        return vg.accumapply(s, this.accumulate(s, va, vb, vc, vd, ve, vf, Function.curry(f)));
    }

    public final <A, B, C, D, E$, F$, G> Option<E> accumulate(Semigroup<E> s, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg) {
        return this.accumulate(s, va, vb, vc, vd, ve, vf, vg, (T t, A a, B b, C c, D d, E$ e1, F$ f, G g) -> Unit.unit()).f().toOption();
    }

    @Override
    public final Iterator<T> iterator() {
        return this.toEither().right().iterator();
    }

    public final Validation<List<E>, T> accumulate() {
        if (this.isFail()) {
            return Validation.fail(List.single(this.fail()));
        }
        return Validation.success(this.success());
    }

    public final <B> Validation<List<E>, B> accumulate(F<T, B> f) {
        if (this.isFail()) {
            return Validation.fail(List.single(this.fail()));
        }
        return Validation.success(f.f(this.success()));
    }

    public final <B, C> Validation<List<E>, C> accumulate(Validation<E, B> v2, F2<T, B, C> f) {
        List<E> list = List.nil();
        if (this.isFail()) {
            list = list.cons(this.fail());
        }
        if (v2.isFail()) {
            list = list.cons(v2.fail());
        }
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success()));
    }

    public final <B, C, D> Validation<List<E>, D> accumulate(Validation<E, B> v2, Validation<E, C> v3, F3<T, B, C, D> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success()));
    }

    public final <B, C, D, $E> Validation<List<E>, $E> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, F4<T, B, C, D, $E> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success()));
    }

    public final <B, C, D, $E, $F> Validation<List<E>, $F> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, F5<T, B, C, D, $E, $F> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success()));
    }

    public final <B, C, D, $E, $F, G> Validation<List<E>, G> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, Validation<E, $F> v6, F6<T, B, C, D, $E, $F, G> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success(), v6.success()));
    }

    public final <B, C, D, $E, $F, G, H> Validation<List<E>, H> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, Validation<E, $F> v6, Validation<E, G> v7, F7<T, B, C, D, $E, $F, G, H> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success(), v6.success(), v7.success()));
    }

    public final <B, C, D, $E, $F, G, H, I> Validation<List<E>, I> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, Validation<E, $F> v6, Validation<E, G> v7, Validation<E, H> v8, F8<T, B, C, D, $E, $F, G, H, I> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success(), v6.success(), v7.success(), v8.success()));
    }

    public static <A, E> Validation<List<E>, List<A>> sequenceNonCumulative(List<Validation<E, A>> list) {
        if (list.exists(Validation::isFail)) {
            F2<List, Validation, List> f = (acc, v) -> acc.cons(v.fail());
            return Validation.fail(list.filter(Validation::isFail).foldLeft(f, List.nil()).reverse());
        }
        F2<List, Validation, List> f = (acc, v) -> acc.cons(v.success());
        return Validation.success(list.filter(Validation::isSuccess).foldLeft(f, List.nil()).reverse());
    }

    public final <C> List<Validation<E, C>> traverseList(F<T, List<C>> f) {
        return this.isSuccess() ? f.f(this.success()).map(Validation::success) : List.iterableList(Validation.fail(this.e.left().value()));
    }

    public final <C> Stream<Validation<E, C>> traverseStream(F<T, Stream<C>> f) {
        return this.isSuccess() ? f.f(this.success()).map(Validation::success) : Stream.iterableStream(Validation.fail(this.e.left().value()));
    }

    public final <C> Option<Validation<E, C>> traverseOption(F<T, Option<C>> f) {
        return this.isSuccess() ? f.f(this.success()).map(Validation::success) : Option.some(Validation.fail(this.e.left().value()));
    }

    public final <C> IO<Validation<E, C>> traverseIO(F<T, IO<C>> f) {
        return this.isSuccess() ? IOFunctions.map(f.f(this.success()), Validation::success) : IOFunctions.unit(Validation.fail(this.e.left().value()));
    }

    public final <C> P1<Validation<E, C>> traverseP1(F<T, P1<C>> f) {
        return this.isSuccess() ? f.f(this.success()).map(Validation::success) : P.p(Validation.fail(this.e.left().value()));
    }

    public static <A, E> List<E> fails(List<Validation<E, ?>> list) {
        return list.filter(Validation::isFail).map((A v) -> v.fail());
    }

    public static <A, E> List<A> successes(List<Validation<?, A>> list) {
        return list.filter(Validation::isSuccess).map((A v) -> v.success());
    }

    public final Validation<NonEmptyList<E>, T> nel() {
        return this.isSuccess() ? Validation.success(this.success()) : Validation.fail(NonEmptyList.nel(this.fail(), new Object[0]));
    }

    public static <E, T> Validation<E, T> validation(Either<E, T> e) {
        return new Validation<E, T>(e);
    }

    public static <E, T> F<Either<E, T>, Validation<E, T>> validation() {
        return Validation::validation;
    }

    public static <E, T> F<Validation<E, T>, Either<E, T>> either() {
        return Validation::toEither;
    }

    public static <E, T> Validation<E, T> success(T t) {
        return Validation.validation(Either.right(t));
    }

    public static <E, T> Validation<E, T> fail(E e) {
        return Validation.validation(Either.left(e));
    }

    public static <E, T> Validation<NonEmptyList<E>, T> failNEL(E e) {
        return Validation.fail(NonEmptyList.nel(e, new Object[0]));
    }

    public static <E, T> Validation<E, T> condition(boolean c, E e, T t) {
        return c ? Validation.success(t) : Validation.fail(e);
    }

    public static Validation<NumberFormatException, Byte> parseByte(String s) {
        try {
            return Validation.success(Byte.parseByte(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Double> parseDouble(String s) {
        try {
            return Validation.success(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Float> parseFloat(String s) {
        try {
            return Validation.success(Float.valueOf(Float.parseFloat(s)));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Integer> parseInt(String s) {
        try {
            return Validation.success(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Long> parseLong(String s) {
        try {
            return Validation.success(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Short> parseShort(String s) {
        try {
            return Validation.success(Short.parseShort(s));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static <A, B> P2<List<A>, List<B>> partition(List<Validation<A, B>> list) {
        return P.p(list.filter(Validation::isFail).map((A v) -> v.fail()), list.filter(Validation::isSuccess).map((A v) -> v.success()));
    }

    public final String toString() {
        return Show.validationShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    public static final class FailProjection<E, T>
    implements Iterable<E> {
        private final Validation<E, T> v;

        private FailProjection(Validation<E, T> v) {
            this.v = v;
        }

        public Validation<E, T> validation() {
            return this.v;
        }

        public E failE(F0<String> err) {
            return this.v.toEither().left().valueE(err);
        }

        public E failE(String err) {
            return this.failE(P.p(err));
        }

        public E orFail(F0<E> e) {
            return (E)this.v.toEither().left().orValue((E)e);
        }

        public E orFail(E e) {
            return (E)this.orFail((E)P.p(e));
        }

        public E on(F<T, E> f) {
            return this.v.toEither().left().on(f);
        }

        public Unit foreach(F<E, Unit> f) {
            return this.v.toEither().left().foreach(f);
        }

        public void foreachDoEffect(Effect1<E> f) {
            this.v.toEither().left().foreachDoEffect(f);
        }

        public <A> Validation<A, T> map(F<E, A> f) {
            return Validation.validation(this.v.toEither().left().map(f));
        }

        public <A> Validation<A, T> bind(F<E, Validation<A, T>> f) {
            return this.v.isFail() ? f.f(this.v.fail()) : Validation.success(this.v.success());
        }

        public <A> Validation<A, T> sequence(Validation<A, T> v) {
            return this.bind(e1 -> v);
        }

        public <A> Option<Validation<E, A>> filter(F<E, Boolean> f) {
            return this.v.toEither().left().filter(f).map(Validation.validation());
        }

        public <A> Validation<A, T> apply(Validation<F<E, A>, T> v) {
            return v.f().bind(this::map);
        }

        public boolean forall(F<E, Boolean> f) {
            return this.v.toEither().left().forall(f);
        }

        public boolean exists(F<E, Boolean> f) {
            return this.v.toEither().left().exists(f);
        }

        public List<E> toList() {
            return this.v.toEither().left().toList();
        }

        public Option<E> toOption() {
            return this.v.toEither().left().toOption();
        }

        public Array<E> toArray() {
            return this.v.toEither().left().toArray();
        }

        public Stream<E> toStream() {
            return this.v.toEither().left().toStream();
        }

        @Override
        public Iterator<E> iterator() {
            return this.v.toEither().left().iterator();
        }
    }
}

