/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.F;
import fj.F0;
import fj.Function;
import fj.P;
import fj.P1;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import java.util.concurrent.Callable;

public final class Callables {
    private Callables() {
    }

    public static <A> Callable<A> callable(A a) {
        return () -> a;
    }

    public static <A> Callable<A> callable(Exception e) {
        return () -> {
            throw e;
        };
    }

    public static <A> F<A, Callable<A>> callable() {
        return Callables::callable;
    }

    public static <A, B> F<A, Callable<B>> callable(F<A, B> f) {
        return a -> () -> f.f(a);
    }

    public static <A, B> F<F<A, B>, F<A, Callable<B>>> arrow() {
        return Callables::callable;
    }

    public static <A, B> Callable<B> bind(Callable<A> a, F<A, Callable<B>> f) {
        return () -> ((Callable)f.f(a.call())).call();
    }

    public static <A, B> F<Callable<A>, Callable<B>> fmap(F<A, B> f) {
        return a -> Callables.bind(a, Callables.callable(f));
    }

    public static <A, B> Callable<B> apply(Callable<A> ca, Callable<F<A, B>> cf) {
        return Callables.bind(cf, f -> Callables.fmap(f).f(ca));
    }

    public static <A, B, C> Callable<C> bind(Callable<A> ca, Callable<B> cb, F<A, F<B, C>> f) {
        return Callables.apply(cb, Callables.fmap(f).f(ca));
    }

    public static <A> Callable<A> join(Callable<Callable<A>> a) {
        return Callables.bind(a, Function.identity());
    }

    public static <A, B, C> F<Callable<A>, F<Callable<B>, Callable<C>>> liftM2(F<A, F<B, C>> f) {
        return Function.curry((ca, cb) -> Callables.bind(ca, cb, f));
    }

    public static <A> Callable<List<A>> sequence(List<Callable<A>> as) {
        return as.foldRight(Callables.liftM2(List.cons()), Callables.callable(List.nil()));
    }

    public static <A> F<List<Callable<A>>, Callable<List<A>>> sequence_() {
        return Callables::sequence;
    }

    public static <A> P1<Option<A>> option(Callable<A> a) {
        return P.lazy(() -> {
            try {
                return Option.some(a.call());
            }
            catch (Exception e) {
                return Option.none();
            }
        });
    }

    public static <A> F<Callable<A>, P1<Option<A>>> option() {
        return Callables::option;
    }

    public static <A> P1<Either<Exception, A>> either(Callable<A> a) {
        return P.lazy(() -> {
            try {
                return Either.right(a.call());
            }
            catch (Exception e) {
                return Either.left(e);
            }
        });
    }

    public static <A> F<Callable<A>, P1<Either<Exception, A>>> either() {
        return Callables::either;
    }

    public static <A> Callable<A> fromEither(F0<Either<Exception, A>> e) {
        return () -> {
            Either e1 = (Either)e.f();
            if (e1.isLeft()) {
                throw (Exception)e1.left().value();
            }
            return e1.right().value();
        };
    }

    public static <A> F<P1<Either<Exception, A>>, Callable<A>> fromEither() {
        return Callables::fromEither;
    }

    public static <A> Callable<A> fromOption(F0<Option<A>> o) {
        return () -> {
            Option o1 = (Option)o.f();
            if (o1.isSome()) {
                return o1.some();
            }
            throw new Exception("No value.");
        };
    }

    public static <A> F<P1<Option<A>>, Callable<A>> fromOption() {
        return Callables::fromOption;
    }

    public static <A> Callable<A> normalise(Callable<A> a) {
        try {
            return Callables.callable(a.call());
        }
        catch (Exception e) {
            return Callables.callable(e);
        }
    }

    public static <A> F<Callable<A>, Callable<A>> normalise() {
        return Callables::normalise;
    }
}

