/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDBTransaction;
import com.apple.foundationdb.FutureResults;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.RangeResult;
import com.apple.foundationdb.RangeResultInfo;
import com.apple.foundationdb.RangeResultSummary;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

class RangeQuery
implements AsyncIterable<KeyValue> {
    private final FDBTransaction tr;
    private final KeySelector begin;
    private final KeySelector end;
    private final boolean snapshot;
    private final int rowLimit;
    private final boolean reverse;
    private final StreamingMode streamingMode;
    private final EventKeeper eventKeeper;

    RangeQuery(FDBTransaction fDBTransaction, boolean bl, KeySelector keySelector, KeySelector keySelector2, int n, boolean bl2, StreamingMode streamingMode, EventKeeper eventKeeper) {
        this.tr = fDBTransaction;
        this.begin = keySelector;
        this.end = keySelector2;
        this.snapshot = bl;
        this.rowLimit = n;
        this.reverse = bl2;
        this.streamingMode = streamingMode;
        this.eventKeeper = eventKeeper;
    }

    @Override
    public CompletableFuture<List<KeyValue>> asList() {
        StreamingMode streamingMode = this.streamingMode;
        if (streamingMode == StreamingMode.ITERATOR) {
            StreamingMode streamingMode2 = streamingMode = this.rowLimit == 0 ? StreamingMode.WANT_ALL : StreamingMode.EXACT;
        }
        if (streamingMode == StreamingMode.EXACT) {
            FutureResults futureResults = this.tr.getRange_internal(this.begin, this.end, this.rowLimit, 0, StreamingMode.EXACT.code(), 1, this.snapshot, this.reverse);
            return ((CompletableFuture)futureResults.thenApply(rangeResultInfo -> rangeResultInfo.get().values)).whenComplete((list, throwable) -> futureResults.close());
        }
        return AsyncUtil.collect(new RangeQuery(this.tr, this.snapshot, this.begin, this.end, this.rowLimit, this.reverse, streamingMode, this.eventKeeper), this.tr.getExecutor());
    }

    @Override
    public AsyncRangeIterator iterator() {
        return new AsyncRangeIterator(this.rowLimit, this.reverse, this.streamingMode);
    }

    private class AsyncRangeIterator
    implements AsyncIterator<KeyValue> {
        private final boolean rowsLimited;
        private final boolean reverse;
        private final StreamingMode streamingMode;
        private RangeResult chunk = null;
        private RangeResult nextChunk = null;
        private boolean fetchOutstanding = false;
        private byte[] prevKey = null;
        private int index = 0;
        private int iteration = 0;
        private KeySelector begin;
        private KeySelector end;
        private int rowsRemaining;
        private FutureResults fetchingChunk;
        private CompletableFuture<Boolean> nextFuture;
        private boolean isCancelled = false;

        private AsyncRangeIterator(int n, boolean bl, StreamingMode streamingMode) {
            this.begin = RangeQuery.this.begin;
            this.end = RangeQuery.this.end;
            this.rowsLimited = n != 0;
            this.rowsRemaining = n;
            this.reverse = bl;
            this.streamingMode = streamingMode;
            this.startNextFetch();
        }

        private synchronized boolean mainChunkIsTheLast() {
            return !this.chunk.more || this.rowsLimited && this.rowsRemaining < 1;
        }

        private synchronized void startNextFetch() {
            if (this.fetchOutstanding) {
                throw new IllegalStateException("Reentrant call not allowed");
            }
            if (this.isCancelled) {
                return;
            }
            if (this.chunk != null && this.mainChunkIsTheLast()) {
                return;
            }
            this.fetchOutstanding = true;
            this.nextChunk = null;
            this.nextFuture = new CompletableFuture();
            long l = System.nanoTime();
            this.fetchingChunk = RangeQuery.this.tr.getRange_internal(this.begin, this.end, this.rowsLimited ? this.rowsRemaining : 0, 0, this.streamingMode.code(), ++this.iteration, RangeQuery.this.snapshot, this.reverse);
            BiConsumer<RangeResultInfo, Throwable> biConsumer = new FetchComplete(this.fetchingChunk, this.nextFuture);
            if (RangeQuery.this.eventKeeper != null) {
                RangeQuery.this.eventKeeper.increment(EventKeeper.Events.RANGE_QUERY_FETCHES);
                biConsumer = biConsumer.andThen((rangeResultInfo, throwable) -> RangeQuery.this.eventKeeper.timeNanos(EventKeeper.Events.RANGE_QUERY_FETCH_TIME_NANOS, System.nanoTime() - l));
            }
            this.fetchingChunk.whenComplete(biConsumer);
        }

        @Override
        public synchronized CompletableFuture<Boolean> onHasNext() {
            if (this.isCancelled) {
                throw new CancellationException();
            }
            if (this.chunk == null) {
                return this.nextFuture;
            }
            if (this.index < this.chunk.values.size()) {
                return AsyncUtil.READY_TRUE;
            }
            return this.mainChunkIsTheLast() ? AsyncUtil.READY_FALSE : this.nextFuture;
        }

        @Override
        public boolean hasNext() {
            return this.onHasNext().join();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KeyValue next() {
            CompletableFuture<Boolean> completableFuture;
            AsyncRangeIterator asyncRangeIterator = this;
            synchronized (asyncRangeIterator) {
                if (this.isCancelled) {
                    throw new CancellationException();
                }
                if (this.chunk != null && this.index < this.chunk.values.size()) {
                    boolean bl2 = this.index == 0;
                    KeyValue keyValue = this.chunk.values.get(this.index);
                    this.prevKey = keyValue.getKey();
                    ++this.index;
                    if (RangeQuery.this.eventKeeper != null) {
                        RangeQuery.this.eventKeeper.count(EventKeeper.Events.BYTES_FETCHED, keyValue.getKey().length + keyValue.getValue().length + 8);
                        RangeQuery.this.eventKeeper.increment(EventKeeper.Events.RANGE_QUERY_RECORDS_FETCHED);
                    }
                    assert (!bl2 || this.nextChunk == null);
                    if (this.index == this.chunk.values.size() && this.nextChunk != null) {
                        this.index = 0;
                        this.chunk = this.nextChunk;
                        this.nextChunk = null;
                    }
                    if (bl2) {
                        this.startNextFetch();
                    }
                    return keyValue;
                }
                completableFuture = this.onHasNext();
            }
            return (KeyValue)((CompletableFuture)completableFuture.thenApply(bl -> {
                if (bl.booleanValue()) {
                    return this.next();
                }
                throw new NoSuchElementException();
            })).join();
        }

        @Override
        public synchronized void remove() {
            if (this.prevKey == null) {
                throw new IllegalStateException("No value has been fetched from database");
            }
            RangeQuery.this.tr.clear(this.prevKey);
        }

        @Override
        public synchronized void cancel() {
            this.isCancelled = true;
            this.nextFuture.cancel(true);
            this.fetchingChunk.cancel(true);
        }

        class FetchComplete
        implements BiConsumer<RangeResultInfo, Throwable> {
            final FutureResults fetchingChunk;
            final CompletableFuture<Boolean> promise;

            FetchComplete(FutureResults futureResults, CompletableFuture<Boolean> completableFuture) {
                this.fetchingChunk = futureResults;
                this.promise = completableFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(RangeResultInfo rangeResultInfo, Throwable throwable) {
                try {
                    if (throwable != null) {
                        if (RangeQuery.this.eventKeeper != null) {
                            RangeQuery.this.eventKeeper.increment(EventKeeper.Events.RANGE_QUERY_CHUNK_FAILED);
                        }
                        this.promise.completeExceptionally(throwable);
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        return;
                    }
                    RangeResult rangeResult = rangeResultInfo.get();
                    RangeResultSummary rangeResultSummary = rangeResult.getSummary();
                    if (rangeResultSummary.lastKey == null) {
                        this.promise.complete(Boolean.FALSE);
                        return;
                    }
                    AsyncRangeIterator asyncRangeIterator = AsyncRangeIterator.this;
                    synchronized (asyncRangeIterator) {
                        AsyncRangeIterator.this.fetchOutstanding = false;
                        AsyncRangeIterator.this.rowsRemaining -= rangeResultSummary.keyCount;
                        if (AsyncRangeIterator.this.reverse) {
                            AsyncRangeIterator.this.end = KeySelector.firstGreaterOrEqual(rangeResultSummary.lastKey);
                        } else {
                            AsyncRangeIterator.this.begin = KeySelector.firstGreaterThan(rangeResultSummary.lastKey);
                        }
                        if (AsyncRangeIterator.this.chunk == null || AsyncRangeIterator.this.index == ((AsyncRangeIterator)AsyncRangeIterator.this).chunk.values.size()) {
                            AsyncRangeIterator.this.nextChunk = null;
                            AsyncRangeIterator.this.chunk = rangeResult;
                            AsyncRangeIterator.this.index = 0;
                        } else {
                            AsyncRangeIterator.this.nextChunk = rangeResult;
                        }
                    }
                    this.promise.complete(Boolean.TRUE);
                }
                finally {
                    this.fetchingChunk.close();
                }
            }
        }
    }
}

