/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.DirectBufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class DirectBufferIterator
implements AutoCloseable {
    protected ByteBuffer byteBuffer;
    protected int current = 0;
    protected int keyCount = -1;
    protected boolean more = false;

    public DirectBufferIterator(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.byteBuffer.order(ByteOrder.nativeOrder());
    }

    @Override
    public void close() {
        if (this.byteBuffer != null) {
            DirectBufferPool.getInstance().add(this.byteBuffer);
            this.byteBuffer = null;
        }
    }

    public boolean hasResultReady() {
        return this.keyCount > -1;
    }

    public boolean hasNext() {
        assert (this.hasResultReady());
        return this.current < this.keyCount;
    }

    public ByteBuffer getBuffer() {
        return this.byteBuffer;
    }

    public int count() {
        assert (this.hasResultReady());
        return this.keyCount;
    }

    public boolean hasMore() {
        assert (this.hasResultReady());
        return this.more;
    }

    public int currentIndex() {
        return this.current;
    }

    public void readResultsSummary() {
        this.byteBuffer.rewind();
        this.byteBuffer.position(0);
        this.keyCount = this.byteBuffer.getInt();
        this.more = this.byteBuffer.getInt() > 0;
    }
}

