/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver.fabricDataWarehouse;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.sqlserver.SQLServerConnection;
import org.flywaydb.database.sqlserver.SQLServerDatabase;
import org.flywaydb.database.sqlserver.fabricDataWarehouse.FabricDataWarehouseConnection;

public class FabricDataWarehouseDatabase
extends SQLServerDatabase {
    public FabricDataWarehouseDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    protected SQLServerConnection doGetConnection(Connection connection) {
        return new FabricDataWarehouseConnection(this, connection);
    }

    @Override
    protected String computeVersionDisplayName(MigrationVersion version) {
        return this.getVersion().getMajorAsString();
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + String.valueOf(table) + " (\n    [installed_rank] INT NOT NULL,\n    [version] VARCHAR(50),\n    [description] VARCHAR(200),\n    [type] VARCHAR(20) NOT NULL,\n    [script] VARCHAR(1000) NOT NULL,\n    [checksum] INT,\n    [installed_by] VARCHAR(100) NOT NULL,\n    [installed_on] DATETIME2(6) NOT NULL,\n    [execution_time] INT NOT NULL,\n    [success] BIT NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + String.valueOf(table) + " ADD CONSTRAINT [" + table.getName() + "_pk] PRIMARY KEY NONCLUSTERED (installed_rank) NOT ENFORCED;\nGO\n";
    }

    public String getInsertStatement(Table table) {
        String currentDateTime = new Timestamp(new Date().getTime()).toString();
        return "INSERT INTO " + String.valueOf(table) + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, '" + currentDateTime + "', ?, ?)";
    }

    @Override
    public String getDatabaseHosting() {
        return "microsoft-fabric-data-warehouse";
    }
}

